/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.user.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.structure.GenericFieldConfigStructureProvider;
import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.fieldsettings.user.structure.UserFieldSettingsProperty;
import com.inet.lib.json.Json;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@InternalApi
public class UserFieldsConfigStructureProvider
extends GenericFieldConfigStructureProvider {
    public static final String CATEGORY_USER_FIELDS = "category.fields.user";
    public static final String PROP_GROUP_FIELD_USERS_TITLE_LABEL = "propGroup.field.users.title";
    public static final String PROP_GROUP_FIELD_USERS = "propGroup.field.users";
    public static final String PROPERTY_KEY_USERFIELDS = "property.fields.user";
    public static final String ICON_CUSTOM_FIELD = "custom-user";
    public static final String ICON_SYSTEM_FIELD = "system-user";
    private Supplier<AbstractFieldSettingsManager<?, ?>> u;

    public UserFieldsConfigStructureProvider(Supplier<AbstractFieldSettingsManager<?, ?>> manager) {
        super(manager, PROPERTY_KEY_USERFIELDS);
        this.u = manager;
    }

    public void addGroupsTo(Set<ConfigGroup> groups, boolean advanced, ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(Set<ConfigCategory> categories, String groupKey, boolean advanced, ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.components": {
                categories.add(new ConfigCategory(131, CATEGORY_USER_FIELDS, this.translate(settings, CATEGORY_USER_FIELDS, new Object[0]), "field.settings.user"));
            }
        }
    }

    public URL getCategoryIcon(String categoryKey) {
        try {
            switch (categoryKey) {
                case "category.fields.user": {
                    return UserFieldsConfigStructureProvider.class.getResource("/com/inet/fieldsettings/user/structure/user_field_config_48.png");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addPropertyGroupsTo(Set<ConfigPropertyGroup> configPropertyGroups, String categoryKey, boolean advanced, ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.fields.user": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_FIELD_USERS_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_FIELD_USERS));
            }
        }
    }

    public void addPropertiesTo(Set<ConfigProperty> configProperties, String propertyGroupKey, boolean advanced, ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "propGroup.field.users": {
                configProperties.add((ConfigProperty)new UserFieldSettingsProperty(PROPERTY_KEY_USERFIELDS, settings, UserFieldSettingsManager.getInstance()));
                break;
            }
            case "propGroup.field.users.title": {
                this.addTo(configProperties, "field.users.title_label", "Label", settings);
            }
        }
    }

    @Override
    public void validate(String categoryKey, ArrayList<ConfigValidationMsg> messages, ArrayList<ConfigConditionAction> conditions, ConfigStructureSettings settings) {
        super.validate(categoryKey, messages, conditions, settings);
        if (settings.getChangedValue(PROPERTY_KEY_USERFIELDS) != null) {
            GenericFieldSetting genericFieldSetting2;
            Map map2;
            List list = (List)new Json().fromJson(settings.getValue(PROPERTY_KEY_USERFIELDS), List.class);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (Map map2 : list) {
                String string = (String)map2.get("fieldsettingsKey");
                Object object = FieldSettingsType.valueOf((String)map2.get("type"));
                genericFieldSetting2 = this.u.get().getSetting(string);
                if (genericFieldSetting2 == null) {
                    arrayList.add(string);
                } else if (genericFieldSetting2.getType() != object) {
                    arrayList.add(string);
                    arrayList2.add(string);
                }
                arrayList3.add(string);
            }
            this.u.get().getSettings().forEach(genericFieldSetting -> {
                if (!arrayList3.contains(genericFieldSetting.getKey())) {
                    arrayList2.add(genericFieldSetting.getKey());
                }
            });
            SearchCondition searchCondition = new SearchCondition(UsersAndGroups.FIELD_USER_LOCKED.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)"");
            map2 = new OrSearchExpression();
            for (Object object : arrayList2) {
                genericFieldSetting2 = (UserFieldDefinition)UserFieldSettingsManager.getInstance().getDefinitionForSetting((String)object);
                Object object2 = this.a((UserFieldDefinition)genericFieldSetting2);
                if (object2 != null) {
                    map2.add(new SearchCondition((String)object, SearchCondition.SearchTermOperator.Unequals, object2));
                    continue;
                }
                map2.add(new SearchCondition((String)object, SearchCondition.SearchTermOperator.StartsWith, (Object)""));
            }
            int n = UserManager.getInstance().getSearchEngine().search(new SearchCommand(new SearchExpression[]{searchCondition, map2})).getEntries().size();
            if (n > 0) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, UserFieldSettingsManager.USER_TRANSLATIONS.getMsg("fields.validation.confirm.deleteDataOfLockedUsers", new Object[]{n}), PROPERTY_KEY_USERFIELDS));
            }
        }
    }

    private Object a(UserFieldDefinition userFieldDefinition) {
        UserField userField = userFieldDefinition.getUserField();
        if (userField != null) {
            return userField.getDefaultValue();
        }
        return null;
    }
}

