/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.user.model;

import com.inet.annotations.InternalApi;
import com.inet.field.ConfigurableField;
import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.RegisteredNature;
import com.inet.usersandgroups.api.ui.fields.user.BooleanUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.CurrencyUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.DoubleUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.EmailUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.IntegerUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.StringUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import java.util.Collections;
import java.util.List;

@InternalApi
public class UserFieldDefinitionNature<T>
extends RegisteredNature {
    private UserFieldDefinition<T> B;

    public UserFieldDefinitionNature(UserFieldDefinition<T> definition) {
        this.B = definition;
    }

    @Override
    public List<SelectOption> getSelectOptions(String filter, GenericFieldSetting settings) {
        if (this.B instanceof SelectUserFieldDefinition) {
            SelectOptionResult selectOptionResult = ((SelectUserFieldDefinition)this.B).getOptions(null, filter, 0, Integer.MAX_VALUE);
            return selectOptionResult.getOptions();
        }
        return Collections.emptyList();
    }

    @Override
    public FieldSettingsType getType() {
        return UserFieldDefinitionNature.getTypeForDefinition(this.B);
    }

    public static FieldSettingsType getTypeForDefinition(UserFieldDefinition<?> definition) {
        if (definition instanceof CurrencyUserFieldDefinition) {
            return FieldSettingsType.TYPE_CURRENCY;
        }
        if (definition instanceof DoubleUserFieldDefinition) {
            return FieldSettingsType.TYPE_DOUBLE;
        }
        if (definition instanceof BooleanUserFieldDefinition) {
            return FieldSettingsType.TYPE_BOOLEAN;
        }
        if (definition instanceof IntegerUserFieldDefinition) {
            return FieldSettingsType.TYPE_NUMBER;
        }
        if (definition instanceof SelectUserFieldDefinition) {
            Class clazz = FieldUtils.getValueTypeViaReflection(definition.getClass());
            if (clazz == String.class || clazz == Integer.class) {
                return FieldSettingsType.TYPE_SELECT;
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(definition.getClass()));
        }
        if (definition instanceof StringUserFieldDefinition) {
            if (definition.getDisplayType().equals("fieldtype_multiline")) {
                return FieldSettingsType.TYPE_MULTILINE_TEXT;
            }
            return FieldSettingsType.TYPE_TEXT;
        }
        if (definition instanceof EmailUserFieldDefinition) {
            return FieldSettingsType.TYPE_TEXT;
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(definition.getClass()));
    }

    public ConfigurableField getDefinition() {
        return this.B;
    }
}

