/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.user.model;

import com.inet.annotations.InternalApi;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.usersandgroups.api.UserField;
import javax.annotation.Nonnull;

@InternalApi
public class UserFieldCustom<T>
extends UserField<T> {
    private GenericFieldSetting y;

    public UserFieldCustom(GenericFieldSetting setting, int searchPrio) {
        super(setting.getKey(), null, FieldTypeFactory.custom((Object)setting).withSearchPrio(searchPrio), setting.getType().getValueType());
        this.y = setting;
        this.setDefaultValue(this.getFieldType().valueOf(setting.getDefaultValue()));
    }

    private UserFieldCustom(GenericFieldSetting setting) {
        super(setting.getKey(), null, FieldTypeFactory.custom((Object)setting), setting.getType().getValueType());
        this.y = setting;
    }

    @Nonnull
    public FieldType<T> createFieldType(Object setting) {
        final GenericFieldSetting genericFieldSetting = (GenericFieldSetting)setting;
        if (genericFieldSetting.getType() == FieldSettingsType.TYPE_SELECT) {
            return new FieldTypeSelect_String(this.getKey(), () -> this.getLabel(), bl -> genericFieldSetting.getSelectOptions(null));
        }
        if (genericFieldSetting.getType() == FieldSettingsType.TYPE_DATE) {
            return new FieldTypeDate(this.getKey(), () -> this.getLabel(), false){

                public boolean withTimezone() {
                    return !"true".equalsIgnoreCase(genericFieldSetting.getSpecificProperty("fieldSettingsIgnoreTimezone"));
                }
            };
        }
        if (genericFieldSetting.getType() == FieldSettingsType.TYPE_DATE_TIME) {
            return new FieldTypeDate(this.getKey(), () -> this.getLabel(), true){

                public boolean withTimezone() {
                    return !"true".equalsIgnoreCase(genericFieldSetting.getSpecificProperty("fieldSettingsIgnoreTimezone"));
                }
            };
        }
        return genericFieldSetting.getType().toFieldType(genericFieldSetting, () -> this.getLabel());
    }

    public boolean isCustomField() {
        return true;
    }

    public static UserFieldCustom create(GenericFieldSetting setting) {
        return new UserFieldCustom(setting);
    }

    public String getLabel() {
        return UserFieldSettingsManager.USER_FIELD_TRANSLATIONS.getMsg("field." + this.getKey(), new Object[0]);
    }
}

