/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.api;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.classloader.translations.ResourceManager;
import com.inet.classloader.translations.TranslationKey;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.I18NChooserProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.ConfigurableDefaultValue;
import com.inet.field.ConfigurableField;
import com.inet.field.Field;
import com.inet.field.FieldManager;
import com.inet.fieldsettings.api.FieldSettingsChangeListener;
import com.inet.fieldsettings.api.FieldSettingsPropertyExtension;
import com.inet.fieldsettings.api.FieldSettingsStructureInfo;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.a;
import com.inet.fieldsettings.api.model.nature.CustomNature;
import com.inet.fieldsettings.api.model.nature.GenericFieldNature;
import com.inet.fieldsettings.api.model.nature.RegisteredNature;
import com.inet.fieldsettings.internal.c;
import com.inet.fieldsettings.internal.d;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.EventDispatcher;
import com.inet.thread.RunnableSession;
import com.inet.thread.ThreadPool;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class AbstractFieldSettingsManager<DEFTYPE extends ConfigurableField, INDEXINFO extends Field> {
    private Map<String, GenericFieldSetting> a = new HashMap<String, GenericFieldSetting>();
    private Map<String, DEFTYPE> b = new HashMap<String, DEFTYPE>();
    private c c;
    private ThreadLocal<Map.Entry<List<INDEXINFO>, List<INDEXINFO>>> d = new ThreadLocal();
    private Logger e;
    private List<String> f = new CopyOnWriteArrayList<String>();
    public static final I18nMessages BASE_TRANSLATIONS = new I18nMessages("com.inet.fieldsettings.api.i18n.BaseTranslations", AbstractFieldSettingsManager.class);
    private String g;
    private EventDispatcher<FieldSettingsChangeListener> h = new EventDispatcher();

    public AbstractFieldSettingsManager(String fieldKindKey, Logger logger) {
        this.g = fieldKindKey;
        this.e = logger;
        this.c = new c(fieldKindKey, logger);
    }

    public void init() {
        Optional<GenericFieldSetting> optional;
        if (!this.a.isEmpty()) {
            throw new IllegalStateException("is already initialized!");
        }
        List<GenericFieldSetting> list = this.c.b();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GenericFieldSetting object22 : list) {
            if (!object22.isCustom()) continue;
            arrayList.add(object22.getKey());
            CustomNature customNature = this.c.b(object22.getKey());
            if (customNature == null) {
                this.e.warn((Object)("Cannot load setting for " + object22.getKey()));
                continue;
            }
            com.inet.fieldsettings.api.model.a.a(object22, customNature);
            optional = this.createAndRegisterForCustom(object22);
            this.registerTranslationKeys((ConfigurableField)optional.getKey());
            this.updateConfigurableValuesOfField((ConfigurableField)optional.getKey(), object22);
            this.a.put(object22.getKey(), object22);
            this.b.put(object22.getKey(), (ConfigurableField)optional.getKey());
        }
        list.removeIf(genericFieldSetting -> genericFieldSetting.isCustom());
        List<DEFTYPE> list2 = this.getAllRegisteredDefinitions();
        list2.removeIf(configurableField -> arrayList.contains(configurableField.getFieldKey()));
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ConfigurableField configurableField2 = (ConfigurableField)iterator.next();
            optional = list.stream().filter(genericFieldSetting -> genericFieldSetting.getKey().equals(configurableField2.getFieldKey())).findFirst();
            if (optional.isPresent()) {
                var7_13 = this.getRegisteredNatureFor(configurableField2);
                com.inet.fieldsettings.api.model.a.a((GenericFieldSetting)optional.get(), (GenericFieldNature)var7_13);
                this.updateConfigurableValuesOfField(configurableField2, (GenericFieldSetting)optional.get());
                list.remove(optional.get());
                this.a.put(((GenericFieldSetting)optional.get()).getKey(), (GenericFieldSetting)optional.get());
            } else {
                var7_13 = new HashMap();
                var7_13.put("sortPrio", String.valueOf(configurableField2.getPriority()));
                String string = this.setSpecificDefaultValues(configurableField2, (Map<String, String>)var7_13);
                GenericFieldSetting genericFieldSetting2 = new GenericFieldSetting(configurableField2.getFieldKey(), false, string, this.getRegisteredNatureFor(configurableField2), (Map<String, String>)var7_13);
                this.c.b(genericFieldSetting2);
                this.a.put(genericFieldSetting2.getKey(), genericFieldSetting2);
            }
            if (configurableField2.getLabelTranslationKey() == null) continue;
            this.registerTranslationKeys(configurableField2);
        }
        for (GenericFieldSetting genericFieldSetting3 : list) {
            this.handleUnknownRegisteredField(genericFieldSetting3);
        }
    }

    protected void handleUnknownRegisteredField(GenericFieldSetting setting) {
        this.e.debug((Object)String.format("Found settings for no longer existing field: %s", setting.getKey()));
    }

    protected void registerTranslationKeys(DEFTYPE definition) {
        DynamicExtensionManager.getInstance().register(TranslationKey.class, (Object)definition.getLabelTranslationKey());
        DynamicExtensionManager.getInstance().register(TranslationKey.class, (Object)definition.getDescriptionBaseTranslationKey());
    }

    private void a(DEFTYPE DEFTYPE) {
        DynamicExtensionManager.getInstance().unregister(TranslationKey.class, (Object)DEFTYPE.getLabelTranslationKey());
        DynamicExtensionManager.getInstance().unregister(TranslationKey.class, (Object)DEFTYPE.getDescriptionBaseTranslationKey());
    }

    protected abstract String setSpecificDefaultValues(@Nullable DEFTYPE var1, Map<String, String> var2);

    protected abstract RegisteredNature getRegisteredNatureFor(DEFTYPE var1);

    protected abstract List<DEFTYPE> getAllRegisteredDefinitions();

    protected abstract <T> Map.Entry<DEFTYPE, INDEXINFO> createAndRegisterForCustom(GenericFieldSetting var1);

    protected abstract INDEXINFO unregisterForCustom(GenericFieldSetting var1);

    public void addNewCustomField(String key, Map<String, String> properties) {
        this.checkKeysToDelete(this.f);
        List<ConfigValidationMsg> list = this.validate(key, properties, true);
        if (!list.isEmpty()) {
            throw new IllegalArgumentException(list.get(0).getMsg());
        }
        properties = this.copyPropertiesAndRemoveGUIKeys(properties);
        String string = properties.remove("fieldsettingsLabel");
        String string2 = properties.remove("description");
        this.setSpecificDefaultValues(null, properties);
        GenericFieldSetting genericFieldSetting = this.a(key, properties);
        Map.Entry<DEFTYPE, INDEXINFO> entry = this.saveNewCustomSetting(key, genericFieldSetting);
        this.registerTranslationKeys((ConfigurableField)entry.getKey());
        this.updateLabelsOfField(string, string2, genericFieldSetting);
        this.updateConfigurableValuesOfField((ConfigurableField)entry.getKey(), genericFieldSetting);
        if (this.d.get() != null) {
            this.d.get().getValue().add((Field)entry.getValue());
        } else if (entry.getValue() != null) {
            this.sendExternalSignal(Collections.emptyList(), Collections.singletonList((Field)entry.getValue()));
        }
        this.e.debug((Object)("Added field " + key));
        com.inet.fieldsettings.internal.a.k.a(key, this.g, new Object[0]);
        this.h.dispatchEvent(fieldSettingsChangeListener -> fieldSettingsChangeListener.fieldSettingChanged(key, false));
    }

    protected Map.Entry<DEFTYPE, INDEXINFO> saveNewCustomSetting(String key, GenericFieldSetting genericFieldSetting) {
        Map.Entry<DEFTYPE, INDEXINFO> entry = this.createAndRegisterForCustom(genericFieldSetting);
        this.c.b(genericFieldSetting);
        this.a.put(key, genericFieldSetting);
        this.b.put(key, (ConfigurableField)entry.getKey());
        return entry;
    }

    private GenericFieldSetting a(String string, Map<String, String> map) {
        CustomNature customNature = new CustomNature(map);
        String string2 = this.a(map, customNature.getType());
        FieldSettingsType.all().forEach(fieldSettingsType -> map.remove(fieldSettingsType.getDefaultValuePropertyKey()));
        GenericFieldSetting genericFieldSetting = new GenericFieldSetting(string, true, string2, customNature, map);
        return genericFieldSetting;
    }

    protected Map<String, String> copyPropertiesAndRemoveGUIKeys(Map<String, String> properties) {
        properties = new HashMap<String, String>(properties);
        properties.remove("fieldsettingsKey");
        properties.remove("fieldsettingsIsCustom");
        properties.remove("duplicate");
        properties.remove("fieldsettingsCanSetDefault");
        properties.remove("fieldsettingsCanSetTranslation");
        properties.remove("field.isNew");
        properties.remove("fieldIcon");
        properties.remove("fieldLabel");
        properties.remove("i18nchooser");
        properties.remove("disableDeleteButton");
        properties.remove("previewDescription");
        return properties;
    }

    protected Map<String, String> copyPropertiesAndRemovePropertiesWhichAreOnlyForCustomFields(Map<String, String> properties) {
        properties = new HashMap<String, String>(properties);
        properties.remove("type");
        properties.remove("fieldSettingsSelectMode");
        properties.remove("selectstaticoptions");
        return properties;
    }

    private String a(Map<String, String> map, FieldSettingsType fieldSettingsType) {
        String string = map.get(fieldSettingsType.getDefaultValuePropertyKey());
        if (fieldSettingsType == FieldSettingsType.TYPE_SELECT && string != null) {
            LocalizedKey localizedKey = (LocalizedKey)new Json().fromJson(string, LocalizedKey.class);
            string = localizedKey.getKey();
        }
        return string;
    }

    public List<GenericFieldSetting> getSettings() {
        ArrayList<GenericFieldSetting> arrayList = new ArrayList<GenericFieldSetting>(this.a.values());
        arrayList.sort((genericFieldSetting, genericFieldSetting2) -> genericFieldSetting.getSortPriority() - genericFieldSetting2.getSortPriority());
        return arrayList;
    }

    @Nullable
    public GenericFieldSetting getSetting(String key) {
        return this.a.get(key);
    }

    public void updateSetting(String key, Map<String, String> properties) {
        FieldSettingsType fieldSettingsType2;
        GenericFieldSetting genericFieldSetting;
        properties = this.copyPropertiesAndRemoveGUIKeys(properties);
        String string = properties.remove("fieldsettingsLabel");
        String string2 = properties.remove("description");
        GenericFieldSetting genericFieldSetting2 = this.a.get(key);
        if (genericFieldSetting2 == null) {
            throw new IllegalArgumentException("No setting for key " + key);
        }
        if (genericFieldSetting2.isCustom()) {
            genericFieldSetting = this.a(key, properties);
        } else {
            properties = this.copyPropertiesAndRemovePropertiesWhichAreOnlyForCustomFields(properties);
            String string3 = genericFieldSetting2.canConfigureDefaultValue() ? this.a(properties, genericFieldSetting2.getType()) : null;
            for (FieldSettingsType fieldSettingsType2 : FieldSettingsType.all()) {
                properties.remove(fieldSettingsType2.getDefaultValuePropertyKey());
            }
            genericFieldSetting = new GenericFieldSetting(key, false, string3, genericFieldSetting2.getNature(), properties);
        }
        boolean bl = this.updateLabelsOfField(string, string2, genericFieldSetting2);
        if (!bl && genericFieldSetting2.equals(genericFieldSetting)) {
            this.e.debug((Object)("No Changes in field " + key));
            return;
        }
        boolean bl2 = genericFieldSetting2.equalsIgnorePrio(genericFieldSetting) && !bl;
        fieldSettingsType2 = null;
        Object e2 = null;
        if (genericFieldSetting2.isCustom()) {
            if (this.fieldSettingOnlyContainsSimpleChanges(genericFieldSetting2, genericFieldSetting)) {
                this.e.debug((Object)("Only some simple properties were changed in field " + key));
                com.inet.fieldsettings.api.model.a.b(genericFieldSetting2, genericFieldSetting);
                this.c.b(genericFieldSetting2);
                this.updateConfigurableValuesOfField((ConfigurableField)this.b.get(key), genericFieldSetting2);
            } else {
                e2 = this.unregisterForCustom(genericFieldSetting2);
                Map.Entry<DEFTYPE, INDEXINFO> entry = this.saveNewCustomSetting(key, genericFieldSetting);
                this.updateConfigurableValuesOfField((ConfigurableField)entry.getKey(), genericFieldSetting);
                fieldSettingsType2 = (Field)entry.getValue();
            }
        } else {
            Object t = ((RegisteredNature)genericFieldSetting2.getNature()).getDefinition();
            this.updateConfigurableValuesOfField(t, genericFieldSetting);
            this.c.b(genericFieldSetting);
            this.a.put(genericFieldSetting.getKey(), genericFieldSetting);
            if (!this.fieldSettingOnlyContainsSimpleChanges(genericFieldSetting2, genericFieldSetting)) {
                this.e.debug((Object)("non-simple changes in field " + key));
                INDEXINFO INDEXINFO = this.getIndexInfoForRegisteredField(t);
                fieldSettingsType2 = INDEXINFO;
                e2 = INDEXINFO;
            }
        }
        if (this.d.get() != null) {
            this.d.get().getKey().add(e2);
            this.d.get().getValue().add(fieldSettingsType2);
        } else if (fieldSettingsType2 != null || e2 != null) {
            this.sendDeleteUserFieldsAndSendExternalSignal(new d<Object>(e2), new d<FieldSettingsType>(fieldSettingsType2));
        }
        this.e.debug((Object)("Updated field " + key));
        if (!bl2) {
            com.inet.fieldsettings.internal.a.l.a(key, this.g, new Object[0]);
        } else {
            this.e.debug((Object)("Only prio was changed in field " + key));
        }
        this.h.dispatchEvent(fieldSettingsChangeListener -> fieldSettingsChangeListener.fieldSettingChanged(key, bl2));
    }

    protected boolean updateLabelsOfField(String fieldLabels, String fieldDescriptions, GenericFieldSetting setting) {
        DEFTYPE DEFTYPE = this.getDefinitionForSetting(setting.getKey());
        if (DEFTYPE.getLabelTranslationKey() == null) {
            return false;
        }
        Map map = (Map)new Json().fromJson(fieldLabels, Map.class);
        Map map2 = fieldDescriptions == null ? Collections.emptyMap() : (Map)new Json().fromJson(fieldDescriptions, Map.class);
        ResourceManager resourceManager = ResourceManager.getInstance();
        Map<String, String> map3 = setting.getLabels(this);
        Map<String, String> map4 = setting.getDescriptions(this);
        if (map3.equals(map) && map4.equals(map2)) {
            this.e.debug((Object)("translations were not changed " + DEFTYPE.getFieldKey()));
            return false;
        }
        this.a(DEFTYPE.getLabelTranslationKey(), map, resourceManager, map3);
        this.a(DEFTYPE.getDescriptionBaseTranslationKey(), map2, resourceManager, map4);
        return true;
    }

    private void a(TranslationKey translationKey, Map<String, String> map, ResourceManager resourceManager, Map<String, String> map2) {
        HashMap hashMap = new HashMap();
        map.forEach((string, string2) -> {
            if (string.equalsIgnoreCase("default")) {
                string = "en";
            }
            hashMap.put(new TranslationKey(translationKey.pluginId, translationKey.bundleName, string, translationKey.key), string2);
        });
        map2.forEach((string, string2) -> {
            if (!map.containsKey(string)) {
                if (string.equalsIgnoreCase("default")) {
                    string = "en";
                }
                hashMap.put(new TranslationKey(translationKey.pluginId, translationKey.bundleName, string, translationKey.key), null);
            }
        });
        resourceManager.writeLabels(hashMap);
    }

    protected abstract INDEXINFO getIndexInfoForRegisteredField(DEFTYPE var1);

    protected boolean fieldSettingOnlyContainsSimpleChanges(GenericFieldSetting setting, GenericFieldSetting updatedSetting) {
        if (setting.isCustom() && !((CustomNature)setting.getNature()).onlySimpleValueAreDifferent((CustomNature)updatedSetting.getNature())) {
            return false;
        }
        return Objects.equals(setting.getDefaultValue(), updatedSetting.getDefaultValue());
    }

    protected void updateConfigurableValuesOfField(DEFTYPE definition, GenericFieldSetting setting) {
        definition.setSortPrio(setting.getSortPriority());
        if (setting.canConfigureDefaultValue()) {
            ((ConfigurableDefaultValue)definition).setDefaultValue(setting.getDefaultValue());
        }
    }

    public void deleteCustomSetting(String key) {
        GenericFieldSetting genericFieldSetting = this.a.get(key);
        if (genericFieldSetting == null) {
            throw new IllegalArgumentException("No setting for key " + key);
        }
        if (genericFieldSetting.isCustom()) {
            this.updateLabelsOfField("{}", "{}", genericFieldSetting);
            this.a(this.getDefinitionForSetting(key));
            INDEXINFO INDEXINFO = this.unregisterForCustom(genericFieldSetting);
            this.c.c(genericFieldSetting);
            this.a.remove(genericFieldSetting.getKey());
            this.b.remove(key);
            if (this.d.get() != null) {
                this.d.get().getKey().add(INDEXINFO);
            } else if (INDEXINFO != null) {
                this.sendDeleteUserFieldsAndSendExternalSignal(Collections.singletonList(INDEXINFO), Collections.emptyList());
            }
        } else {
            throw new IllegalArgumentException(String.format("Cannot remove the non-custom field %s! You must omit the registration of this field to get rid of it.", genericFieldSetting.getKey()));
        }
        com.inet.fieldsettings.internal.a.m.a(key, this.g, new Object[0]);
        this.h.dispatchEvent(fieldSettingsChangeListener -> fieldSettingsChangeListener.fieldSettingChanged(key, false));
    }

    public List<FieldSettingsType> getSupportedTypesForCustomFields() {
        ArrayList<FieldSettingsType> arrayList = new ArrayList<FieldSettingsType>();
        arrayList.add(FieldSettingsType.TYPE_BOOLEAN);
        arrayList.add(FieldSettingsType.TYPE_DATE);
        arrayList.add(FieldSettingsType.TYPE_DATE_TIME);
        arrayList.add(FieldSettingsType.TYPE_DOUBLE);
        arrayList.add(FieldSettingsType.TYPE_NUMBER);
        arrayList.add(FieldSettingsType.TYPE_TIME);
        arrayList.add(FieldSettingsType.TYPE_CURRENCY);
        arrayList.add(FieldSettingsType.TYPE_TEXT);
        arrayList.add(FieldSettingsType.TYPE_MULTILINE_TEXT);
        arrayList.add(FieldSettingsType.TYPE_SELECT);
        arrayList.add(FieldSettingsType.TYPE_LINK);
        return arrayList;
    }

    protected void sendExternalSignal(List<INDEXINFO> removedInfos, List<INDEXINFO> addedInfos) {
        List list = removedInfos.stream().map(field -> {
            if (field != null) {
                return field.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List list2 = addedInfos.stream().map(field -> {
            if (field != null) {
                return field.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            this.getManager().getSearchEngine().changeTagsAndReindex(list, list2);
        }
        catch (IOException iOException) {
            this.e.error((Throwable)iOException);
        }
    }

    public List<? extends FieldSettingsPropertyExtension> getFieldPropertyExtensions() {
        return Collections.emptyList();
    }

    public abstract FieldSettingsStructureInfo getFieldSettingsStructureInfo();

    public List<ConfigValidationMsg> validate(String key, Map<String, String> properties, boolean willBeNewField) {
        Object object;
        String string;
        FieldSettingsType fieldSettingsType;
        ArrayList<ConfigValidationMsg> arrayList = new ArrayList<ConfigValidationMsg>();
        if (key == null || key.isEmpty()) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.getFieldSettingsStructureInfo().translate("fields.validation.keynotnull", new Object[0]), "fieldsettingsKey"));
            return arrayList;
        }
        try {
            if (key != null && !key.isEmpty()) {
                Field.throwIfInvalidKey((String)key);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, illegalArgumentException.getMessage(), "fieldsettingsKey"));
        }
        if (willBeNewField && this.a.get(key) != null) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.duplicatekey", new Object[]{key}), "fieldsettingsKey"));
        }
        try {
            PersistenceHelper.checkName((String)key);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.keyInvalid", new Object[0]), "fieldsettingsKey"));
        }
        if (key.contains("/") || key.contains("\\")) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.keyInvalid", new Object[0]), "fieldsettingsKey"));
        }
        if ((fieldSettingsType = FieldSettingsType.valueOf(properties.get("type"))) == null) {
            throw new IllegalArgumentException("Custom field needs a type");
        }
        String string2 = this.a(properties, fieldSettingsType);
        if (string2 != null) {
            try {
                fieldSettingsType.validateStringInput(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, illegalArgumentException.getMessage(), fieldSettingsType.getDefaultValuePropertyKey()));
            }
        }
        if (properties.getOrDefault("fieldsettingsIsCustom", "true").equalsIgnoreCase("true") || ((RegisteredNature)this.getSetting(key).getNature()).canConfigureTranslation()) {
            string = properties.get("fieldsettingsLabel");
            if (string == null || string.isBlank()) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.missingStandardlabel", new Object[0]), "fieldsettingsLabel"));
            } else {
                object = (Map)new Json().fromJson(string, Map.class);
                if (object.isEmpty()) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.missingStandardlabel", new Object[0]), "fieldsettingsLabel"));
                } else if (object.get("default") == null) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.missingStandardlabel", new Object[0]), "fieldsettingsLabel"));
                }
                this.a(arrayList, (Map<String, String>)object, "fieldsettingsLabel");
            }
        }
        if ((string = properties.get("description")) != null && !string.isBlank()) {
            object = (Map)new Json().fromJson(string, Map.class);
            this.a(arrayList, (Map<String, String>)object, "description");
        }
        if (properties.getOrDefault("fieldsettingsIsCustom", "true").equalsIgnoreCase("true") || properties.getOrDefault("duplicate", "true").equalsIgnoreCase("true")) {
            ArrayList arrayList2;
            if (fieldSettingsType == FieldSettingsType.TYPE_SELECT && (string2 == null || string2.isBlank() && properties.getOrDefault("fieldSettingsSelectMode", String.valueOf(1)).equalsIgnoreCase(String.valueOf(1)))) {
                object = (List)new Json().fromJson(properties.getOrDefault("selectstaticoptions", "[[]]"), List.class);
                arrayList2 = new ArrayList(object.size());
                object.forEach(list -> {
                    if (!list.isEmpty()) {
                        arrayList2.add(list.get(0));
                    }
                });
                if (!arrayList2.contains(null) && !arrayList2.contains("")) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.defaultCannotBeEmpty", new Object[0]), "fieldsettingsDefaultValueSelect"));
                }
            }
            if (fieldSettingsType == FieldSettingsType.TYPE_SELECT && !StringFunctions.isEmpty((String)string2) && !"true".equalsIgnoreCase(properties.get("usesqlconnection"))) {
                object = (List)new Json().fromJson(properties.getOrDefault("selectstaticoptions", "[[]]"), List.class);
                arrayList2 = new ArrayList(object.size());
                object.forEach(list -> {
                    if (!list.isEmpty()) {
                        arrayList2.add(list.get(0));
                    }
                });
                if (!arrayList2.contains(string2)) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.defaultMustExists", new Object[0]), "fieldsettingsDefaultValueSelect"));
                }
            }
            if (fieldSettingsType == FieldSettingsType.TYPE_SELECT && properties.getOrDefault("fieldSettingsSelectMode", String.valueOf(1)).equalsIgnoreCase(String.valueOf(3))) {
                object = (List)new Json().fromJson(properties.getOrDefault("selectstaticoptions", "[[]]"), List.class);
                arrayList2 = new ArrayList(object.size());
                object.forEach(list -> {
                    if (!list.isEmpty()) {
                        arrayList2.add(list.get(0));
                    }
                });
                if (arrayList2.contains(null) || arrayList2.contains("")) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.noEmptySelectValueForMultiSelect", new Object[0]), "selectstaticoptions"));
                }
            }
            if (!this.getSupportedTypesForCustomFields().contains(fieldSettingsType)) {
                arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.unsupportedDataType", new Object[]{fieldSettingsType.getLabel()}), "type"));
            }
        }
        return arrayList;
    }

    private void a(List<ConfigValidationMsg> list, Map<String, String> map, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                MessageFormat.format(entry.getValue(), null);
                MessageFormat messageFormat = new MessageFormat(entry.getValue());
                if (messageFormat.getFormats().length <= 0) continue;
                throw new IllegalArgumentException(BASE_TRANSLATIONS.getMsg("fields.validation.noFormatAllowed", new Object[0]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                list.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.invalidTranslationLabel", new Object[]{entry.getValue(), I18NChooserProperty.getDisplayLanguage((String)entry.getKey()), illegalArgumentException.getMessage()}), string));
            }
        }
    }

    public void doBatchModification(Runnable task) {
        this.d.set(Map.entry(new d(), new d()));
        try {
            task.run();
        }
        finally {
            if (!this.d.get().getKey().isEmpty() || !this.d.get().getValue().isEmpty()) {
                this.sendDeleteUserFieldsAndSendExternalSignal(this.d.get().getKey(), this.d.get().getValue());
            }
            this.d.remove();
        }
    }

    @Nullable
    public DEFTYPE getDefinitionForSetting(String key) {
        GenericFieldSetting genericFieldSetting = this.a.get(key);
        if (genericFieldSetting == null) {
            return null;
        }
        if (genericFieldSetting.isCustom()) {
            return (DEFTYPE)((ConfigurableField)this.b.get(key));
        }
        return (DEFTYPE)((RegisteredNature)genericFieldSetting.getNature()).getDefinition();
    }

    public String getFieldKindKey() {
        return this.g;
    }

    public void checkKeysToDelete(Collection<String> keys) {
        for (String string : keys) {
            if (!this.f.contains(string)) continue;
            throw new IllegalStateException(String.format("Data of field '%s' is being deleted, please wait until it finishs and try again later.", string));
        }
    }

    protected void sendDeleteUserFieldsAndSendExternalSignal(List<INDEXINFO> fieldsToDelete, List<INDEXINFO> addedInfos) {
        ArrayList<INDEXINFO> arrayList = new ArrayList<INDEXINFO>(fieldsToDelete);
        arrayList.removeIf(field -> this.a(field, addedInfos));
        List<String> list = arrayList.stream().map(Field::getKey).collect(Collectors.toList());
        this.checkKeysToDelete(list);
        this.f.addAll(list);
        ThreadPool.DEFAULT.startMainThread(() -> {
            try {
                if (!arrayList.isEmpty()) {
                    this.deleteFields(arrayList);
                }
                this.sendExternalSignal(fieldsToDelete, addedInfos);
            }
            catch (Throwable throwable) {
                LogManager.getApplicationLogger().error(throwable);
            }
            finally {
                this.f.removeAll(list);
            }
        }, (RunnableSession)new BaseRunnableSession());
    }

    private boolean a(INDEXINFO INDEXINFO, List<INDEXINFO> list) {
        for (Field field : list) {
            if (!Objects.equals(field.getKey(), INDEXINFO.getKey())) continue;
            return field.getValueType().equals(INDEXINFO.getValueType());
        }
        return false;
    }

    protected abstract void deleteFields(List<INDEXINFO> var1);

    public abstract <T> FieldManager<T> getManager();

    public void addChangeListener(@Nonnull FieldSettingsChangeListener listener) {
        this.h.registerListener((Object)listener);
    }

    public void removeChangeListener(@Nonnull FieldSettingsChangeListener listener) {
        this.h.unregisterListener((Object)listener);
    }
}

