/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.api.model;

import com.inet.annotations.JsonData;
import com.inet.classloader.translations.BundleKey;
import com.inet.classloader.translations.ResourceManager;
import com.inet.classloader.translations.TranslationKey;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.SelectOption;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.nature.CustomNature;
import com.inet.fieldsettings.api.model.nature.GenericFieldNature;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class GenericFieldSetting {
    private String key;
    private boolean custom;
    private transient String description;
    private String defaultValue;
    private transient GenericFieldNature nature;
    private Map<String, String> specificProperties;
    private int sortPriority;

    public GenericFieldSetting(@Nonnull String key, boolean custom, String defaultValue, GenericFieldNature nature, Map<String, String> specificProperties) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.key = key;
        this.custom = custom;
        this.defaultValue = defaultValue;
        this.nature = nature;
        try {
            this.sortPriority = Integer.parseInt(specificProperties.remove("sortPrio"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.specificProperties = specificProperties;
    }

    private GenericFieldSetting() {
    }

    public List<SelectOption> getSelectOptions(String filter) {
        try {
            return this.nature.getSelectOptions(filter, this);
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().warn((Object)("Error while fetching select-options for " + this.key));
            LogManager.getConfigLogger().warn((Object)exception);
            return Collections.emptyList();
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isCustom() {
        return this.custom;
    }

    @Deprecated
    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    void setNature(GenericFieldNature nature) {
        this.nature = nature;
    }

    public FieldSettingsType getType() {
        return this.nature.getType();
    }

    public String getSpecificProperty(String propKey) {
        return this.specificProperties.get(propKey);
    }

    public GenericFieldNature getNature() {
        return this.nature;
    }

    public boolean canConfigureDefaultValue() {
        return this.nature.canConfigureDefaultValue();
    }

    public Map<String, String> getSpecificProperties() {
        return new HashMap<String, String>(this.specificProperties);
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericFieldSetting genericFieldSetting = (GenericFieldSetting)obj;
        if (this.custom != genericFieldSetting.custom) {
            return false;
        }
        if (this.defaultValue == null ? genericFieldSetting.defaultValue != null : !this.defaultValue.equals(genericFieldSetting.defaultValue)) {
            return false;
        }
        if (this.description == null ? genericFieldSetting.description != null : !this.description.equals(genericFieldSetting.description)) {
            return false;
        }
        if (this.key == null ? genericFieldSetting.key != null : !this.key.equals(genericFieldSetting.key)) {
            return false;
        }
        if (this.nature == null ? genericFieldSetting.nature != null : !this.nature.equals(genericFieldSetting.nature)) {
            return false;
        }
        if (this.sortPriority != genericFieldSetting.sortPriority) {
            return false;
        }
        return !(this.specificProperties == null ? genericFieldSetting.specificProperties != null : !this.specificProperties.equals(genericFieldSetting.specificProperties));
    }

    public boolean equalsIgnorePrio(GenericFieldSetting updatedSetting) {
        GenericFieldSetting genericFieldSetting = updatedSetting;
        if (this.custom != genericFieldSetting.custom) {
            return false;
        }
        if (this.defaultValue == null ? genericFieldSetting.defaultValue != null : !this.defaultValue.equals(genericFieldSetting.defaultValue)) {
            return false;
        }
        if (this.description == null ? genericFieldSetting.description != null : !this.description.equals(genericFieldSetting.description)) {
            return false;
        }
        if (this.key == null ? genericFieldSetting.key != null : !this.key.equals(genericFieldSetting.key)) {
            return false;
        }
        if (this.nature == null ? genericFieldSetting.nature != null : !this.nature.equals(genericFieldSetting.nature)) {
            return false;
        }
        return !(this.specificProperties == null ? genericFieldSetting.specificProperties != null : !this.specificProperties.equals(genericFieldSetting.specificProperties));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.custom ? 1231 : 1237);
        n2 = 31 * n2 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        n2 = 31 * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = 31 * n2 + (this.key == null ? 0 : this.key.hashCode());
        n2 = 31 * n2 + (this.nature == null ? 0 : this.nature.hashCode());
        n2 = 31 * n2 + this.sortPriority;
        n2 = 31 * n2 + (this.specificProperties == null ? 0 : this.specificProperties.hashCode());
        return n2;
    }

    void updateSimpleValues(GenericFieldSetting updatedSetting) {
        this.description = updatedSetting.description;
        this.sortPriority = updatedSetting.sortPriority;
        this.specificProperties = new HashMap<String, String>(updatedSetting.specificProperties);
        this.defaultValue = updatedSetting.defaultValue;
        ((CustomNature)this.nature).updateSimpleValues((CustomNature)updatedSetting.nature);
    }

    public Map<String, String> toMap(AbstractFieldSettingsManager<?, ?> manager) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fieldsettingsKey", this.getKey());
        hashMap.put("fieldsettingsIsCustom", String.valueOf(this.isCustom()));
        if (this.getType() == FieldSettingsType.TYPE_SELECT) {
            Optional<SelectOption> optional;
            object = new LocalizedKey("", "");
            String string = this.getDefaultValue();
            if (string != null && (optional = this.getSelectOptions(null).stream().filter(o -> Objects.equals(o.getValue(), string)).findFirst()).isPresent()) {
                object = optional.get().asLocalizedKey();
            }
            hashMap.put("fieldsettingsDefaultValueSelect", new Json().toJson(object));
        } else {
            hashMap.put(this.getType().getDefaultValuePropertyKey(), this.getDefaultValue() == null ? "" : String.valueOf(this.getDefaultValue()));
        }
        hashMap.put("type", this.getType().toString());
        hashMap.put("sortPrio", String.valueOf(this.getSortPriority()));
        if (this.isCustom()) {
            object = (CustomNature)this.getNature();
            hashMap.put("selectstaticoptions", new Json().toJson(((CustomNature)object).getStaticValuesWithData()));
            hashMap.put("fieldSettingsSelectMode", String.valueOf(((CustomNature)object).getSelectOptionsMode()));
        }
        hashMap.put("fieldsettingsLabel", new Json().toJson(this.getLabels(manager)));
        hashMap.put("description", new Json().toJson(this.getDescriptions(manager)));
        hashMap.putAll(this.getSpecificProperties());
        return hashMap;
    }

    public Map<String, String> getLabels(AbstractFieldSettingsManager<?, ?> fieldManager) {
        return this.loadLabelsFromResourceManager(fieldManager.getDefinitionForSetting(this.key).getLabelTranslationKey());
    }

    public Map<String, String> getDescriptions(AbstractFieldSettingsManager<?, ?> fieldManager) {
        return this.loadLabelsFromResourceManager(fieldManager.getDefinitionForSetting(this.key).getDescriptionBaseTranslationKey());
    }

    public Map<String, String> loadLabelsFromResourceManager(TranslationKey baseKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (baseKey == null) {
            return hashMap;
        }
        ResourceManager resourceManager = ResourceManager.getInstance();
        Set set = resourceManager.getSupportedLanguages(baseKey.pluginId, baseKey.bundleName);
        for (String string : set) {
            Properties properties = resourceManager.getCurrentLabels(new BundleKey(baseKey.pluginId, baseKey.bundleName, string));
            String string2 = properties.getProperty(baseKey.key);
            if (string2 == null || string2.isBlank()) continue;
            if (string.equalsIgnoreCase("en")) {
                string = "default";
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public boolean canConfigureTranslation() {
        return this.nature.canConfigureTranslation();
    }
}

