/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.api.model;

import com.inet.annotations.InternalApi;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.lib.util.StringFunctions;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class LinkField {
    private static final Pattern j = Pattern.compile("\\{([^{}]+)\\}");

    public static String buildTitle(GenericFieldSetting setting, Function<String, String> fieldResolver) {
        String string = setting.getSpecificProperty("linkPatternLabel");
        if (StringFunctions.isEmpty((String)string)) {
            string = setting.getSpecificProperty("linkPatternLink");
        }
        return LinkField.a(fieldResolver, string);
    }

    public static String buildLink(GenericFieldSetting setting, Function<String, String> fieldResolver) {
        String string = setting.getSpecificProperty("linkPatternLink");
        return LinkField.a(fieldResolver, string);
    }

    private static String a(Function<String, String> function, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = j.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = function.apply(string2);
            if (string3 == null) {
                string3 = "";
            }
            matcher.appendReplacement(stringBuilder, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuilder);
        return stringBuilder.toString();
    }
}

