/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.maintenance;

import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.shared.utils.Version;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class a
implements BackupTask {
    public String getKey() {
        return "userfieldsettingsbackup";
    }

    public String getTitle() {
        return UserFieldSettingsManager.USER_TRANSLATIONS.getMsg("backuptask.userfields.title", new Object[0]);
    }

    public String getDescription() {
        return UserFieldSettingsManager.USER_TRANSLATIONS.getMsg("backuptask.userfields.description", new Object[0]);
    }

    public URL getIconURL() {
        return a.class.getResource("/com/inet/fieldsettings/user/structure/custom_field_config_32.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        UserFieldSettingsManager userFieldSettingsManager = UserFieldSettingsManager.getInstance();
        List<GenericFieldSetting> list = userFieldSettingsManager.getSettings();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UserFieldSettingsManager.USER_TRANSLATIONS.getMsg("backuptask.userfields.details.total", new Object[]{list.size()}));
        arrayList.add(UserFieldSettingsManager.USER_TRANSLATIONS.getMsg("backuptask.userfields.details.customFields", new Object[]{list.stream().filter(GenericFieldSetting::isCustom).count()}));
        contentInformation.putTaskDetails(this.getKey(), arrayList);
        int n = 0;
        try (FileOutputStream fileOutputStream = new FileOutputStream(taskPath.resolve("userfieldsettings.zip").toFile());
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            for (GenericFieldSetting genericFieldSetting : list) {
                Map<String, String> map = genericFieldSetting.toMap(userFieldSettingsManager);
                try {
                    ZipEntry zipEntry = new ZipEntry(genericFieldSetting.getKey());
                    zipOutputStream.putNextEntry(zipEntry);
                    new Json().toJson(map, (OutputStream)zipOutputStream);
                }
                finally {
                    zipOutputStream.closeEntry();
                }
                progressUpdater.updateProgress(++n * 100 / list.size());
            }
        }
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, Version backupVersion) throws Throwable {
        UserFieldSettingsManager userFieldSettingsManager = UserFieldSettingsManager.getInstance();
        userFieldSettingsManager.doBatchModification(() -> {
            try (FileInputStream fileInputStream = new FileInputStream(taskPath.resolve("userfieldsettings.zip").toFile());
                 ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    try {
                        String string = zipEntry.getName();
                        Map map = (Map)new Json().fromJson((InputStream)zipInputStream, Map.class);
                        if (userFieldSettingsManager.getSetting(string) == null) {
                            userFieldSettingsManager.addNewCustomField(string, map);
                            continue;
                        }
                        String string2 = (String)map.get("fieldsettingsIsCustom");
                        boolean bl = userFieldSettingsManager.getSetting(string).isCustom();
                        if (string2 == null || !bl && Boolean.valueOf(string2).booleanValue()) {
                            LogManager.getLogger((String)"Maintenance").warn((Object)String.format("[Backup] Cannot restore user field setting %s, because in the backup file custom=%s, but here custom=%s. This cannot be changed and properties cannot be converted.  ", string, string2, String.valueOf(bl)));
                            continue;
                        }
                        userFieldSettingsManager.updateSetting(string, map);
                    }
                    finally {
                        zipInputStream.closeEntry();
                    }
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
    }

    public boolean isVersionSupportedForRestore(Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("22.10"));
    }
}

