/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.preprocess;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsNavigableMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.PSActive;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSDiagnostics;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSExtends;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSParam;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.model.PSSpan;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.schematron.pure.preprocess.PreprocessorIDPool;
import com.helger.schematron.pure.preprocess.PreprocessorLookup;
import com.helger.schematron.pure.preprocess.SchematronPreprocessException;
import com.helger.xml.microdom.IMicroElement;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PSPreprocessor {
    public static final boolean DEFAULT_KEEP_TITLES = false;
    public static final boolean DEFAULT_KEEP_DIAGNOSTICS = false;
    public static final boolean DEFAULT_KEEP_REPORTS = false;
    public static final boolean DEFAULT_KEEP_EMPTY_PATTERNS = true;
    public static final boolean DEFAULT_KEEP_EMPTY_SCHEMA = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(PSPreprocessor.class);
    private final IPSQueryBinding m_aQueryBinding;
    private boolean m_bKeepTitles = false;
    private boolean m_bKeepDiagnostics = false;
    private boolean m_bKeepReports = false;
    private boolean m_bKeepEmptyPatterns = true;
    private boolean m_bKeepEmptySchema = true;

    public PSPreprocessor(@Nonnull IPSQueryBinding iPSQueryBinding) {
        this.m_aQueryBinding = (IPSQueryBinding)ValueEnforcer.notNull((Object)iPSQueryBinding, (String)"QueryBinding");
    }

    @Nonnull
    public IPSQueryBinding getQueryBinding() {
        return this.m_aQueryBinding;
    }

    public boolean isKeepTitles() {
        return this.m_bKeepTitles;
    }

    @Nonnull
    public PSPreprocessor setKeepTitles(boolean bl) {
        this.m_bKeepTitles = bl;
        return this;
    }

    public boolean isKeepDiagnostics() {
        return this.m_bKeepDiagnostics;
    }

    @Nonnull
    public PSPreprocessor setKeepDiagnostics(boolean bl) {
        this.m_bKeepDiagnostics = bl;
        return this;
    }

    public boolean isKeepReports() {
        return this.m_bKeepReports;
    }

    @Nonnull
    public PSPreprocessor setKeepReports(boolean bl) {
        this.m_bKeepReports = bl;
        return this;
    }

    public boolean isKeepEmptyPatterns() {
        return this.m_bKeepEmptyPatterns;
    }

    @Nonnull
    public PSPreprocessor setKeepEmptyPatterns(boolean bl) {
        this.m_bKeepEmptyPatterns = bl;
        return this;
    }

    public boolean isKeepEmptySchema() {
        return this.m_bKeepEmptySchema;
    }

    @Nonnull
    public PSPreprocessor setKeepEmptySchema(boolean bl) {
        this.m_bKeepEmptySchema = bl;
        return this;
    }

    @Nonnull
    private static PSPhase _getPreprocessedPhase(@Nonnull PSPhase pSPhase, @Nonnull PreprocessorIDPool preprocessorIDPool) throws SchematronPreprocessException {
        PSPhase pSPhase2 = new PSPhase();
        pSPhase2.setID(preprocessorIDPool.getUniqueID(pSPhase.getID()));
        pSPhase2.setRich(pSPhase.getRichClone());
        if (pSPhase.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <phase> with an <include>");
        }
        for (IPSElement iPSElement : pSPhase.getAllContentElements()) {
            if (iPSElement instanceof PSActive) {
                pSPhase2.addActive(((PSActive)iPSElement).getClone());
                continue;
            }
            if (!(iPSElement instanceof PSLet)) continue;
            pSPhase2.addLet(((PSLet)iPSElement).getClone());
        }
        pSPhase2.addForeignElements((Iterable<IMicroElement>)pSPhase.getAllForeignElements());
        pSPhase2.addForeignAttributes((Map<String, String>)pSPhase.getAllForeignAttributes());
        return pSPhase2;
    }

    @Nonnull
    private PSAssertReport _getPreprocessedAssert(@Nonnull PSAssertReport pSAssertReport, @Nonnull PreprocessorIDPool preprocessorIDPool, @Nullable ICommonsMap<String, String> iCommonsMap) {
        String string = pSAssertReport.getTest();
        if (pSAssertReport.isReport() && !this.m_bKeepReports) {
            string = this.m_aQueryBinding.getNegatedTestExpression(string);
        }
        PSAssertReport pSAssertReport2 = new PSAssertReport(!this.m_bKeepReports || pSAssertReport.isAssert());
        pSAssertReport2.setTest(this.m_aQueryBinding.getWithParamTextsReplaced(string, (Map<String, String>)iCommonsMap));
        pSAssertReport2.setFlag(pSAssertReport.getFlag());
        pSAssertReport2.setID(preprocessorIDPool.getUniqueID(pSAssertReport.getID()));
        if (this.m_bKeepDiagnostics) {
            pSAssertReport2.setDiagnostics(pSAssertReport.getAllDiagnostics());
        }
        pSAssertReport2.setRich(pSAssertReport.getRichClone());
        pSAssertReport2.setLinkable(pSAssertReport.getLinkableClone());
        for (Object e : pSAssertReport.getAllContentElements()) {
            if (e instanceof String) {
                pSAssertReport2.addText((String)e);
                continue;
            }
            if (e instanceof PSName) {
                pSAssertReport2.addName(((PSName)e).getClone());
                continue;
            }
            if (e instanceof PSValueOf) {
                PSValueOf pSValueOf = ((PSValueOf)e).getClone();
                pSValueOf.setSelect(this.m_aQueryBinding.getWithParamTextsReplaced(pSValueOf.getSelect(), (Map<String, String>)iCommonsMap));
                pSAssertReport2.addValueOf(pSValueOf);
                continue;
            }
            if (e instanceof PSEmph) {
                pSAssertReport2.addEmph(((PSEmph)e).getClone());
                continue;
            }
            if (e instanceof PSDir) {
                pSAssertReport2.addDir(((PSDir)e).getClone());
                continue;
            }
            if (!(e instanceof PSSpan)) continue;
            pSAssertReport2.addSpan(((PSSpan)e).getClone());
        }
        pSAssertReport2.addForeignElements((Iterable<IMicroElement>)pSAssertReport.getAllForeignElements());
        pSAssertReport2.addForeignAttributes((Map<String, String>)pSAssertReport.getAllForeignAttributes());
        return pSAssertReport2;
    }

    private void _resolveRuleContent(@Nonnull PSPattern pSPattern, @Nonnull ICommonsList<IPSElement> iCommonsList, @Nonnull PreprocessorLookup preprocessorLookup, @Nonnull PreprocessorIDPool preprocessorIDPool, @Nullable ICommonsMap<String, String> iCommonsMap, @Nonnull PSRule pSRule) throws SchematronPreprocessException {
        for (IPSElement iPSElement : iCommonsList) {
            IPSElement iPSElement2;
            if (iPSElement instanceof PSAssertReport) {
                iPSElement2 = (PSAssertReport)iPSElement;
                pSRule.addAssertReport(this._getPreprocessedAssert((PSAssertReport)iPSElement2, preprocessorIDPool, iCommonsMap));
                continue;
            }
            iPSElement2 = (PSExtends)iPSElement;
            String string = ((PSExtends)iPSElement2).getRule();
            PSRule pSRule2 = preprocessorLookup.getAbstractRuleOfID(string);
            if (pSRule2 == null) {
                throw new SchematronPreprocessException("Failed to resolve rule ID '" + string + "' in extends statement. Available rules are: " + String.valueOf(preprocessorLookup.getAllAbstractRuleIDs()));
            }
            this._resolveRuleContent(pSPattern, pSRule2.getAllContentElements(), preprocessorLookup, preprocessorIDPool, iCommonsMap, pSRule);
            for (PSLet pSLet : pSRule2.getAllLets()) {
                pSRule.addLet(pSLet.getClone());
            }
        }
    }

    @Nullable
    private PSRule _getPreprocessedRule(@Nonnull PSPattern pSPattern, @Nonnull PSRule pSRule, @Nonnull PreprocessorLookup preprocessorLookup, @Nonnull PreprocessorIDPool preprocessorIDPool, @Nullable ICommonsMap<String, String> iCommonsMap) throws SchematronPreprocessException {
        if (pSRule.isAbstract()) {
            return null;
        }
        PSRule pSRule2 = new PSRule();
        pSRule2.setFlag(pSRule.getFlag());
        pSRule2.setRich(pSRule.getRichClone());
        pSRule2.setLinkable(pSRule.getLinkableClone());
        pSRule2.setContext(this.m_aQueryBinding.getWithParamTextsReplaced(pSRule.getContext(), (Map<String, String>)iCommonsMap));
        pSRule2.setID(preprocessorIDPool.getUniqueID(pSRule.getID()));
        if (pSRule.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <rule> with an <include>");
        }
        for (PSLet pSLet : pSRule.getAllLets()) {
            pSRule2.addLet(pSLet.getClone());
        }
        this._resolveRuleContent(pSPattern, pSRule.getAllContentElements(), preprocessorLookup, preprocessorIDPool, iCommonsMap, pSRule2);
        pSRule2.addForeignElements((Iterable<IMicroElement>)pSRule.getAllForeignElements());
        pSRule2.addForeignAttributes((Map<String, String>)pSRule.getAllForeignAttributes());
        return pSRule2;
    }

    @Nullable
    private PSPattern _getPreprocessedPattern(@Nonnull PSPattern pSPattern, @Nonnull PreprocessorLookup preprocessorLookup, @Nonnull PreprocessorIDPool preprocessorIDPool) throws SchematronPreprocessException {
        String string;
        if (pSPattern.isAbstract()) {
            return null;
        }
        PSPattern pSPattern2 = new PSPattern();
        pSPattern2.setID(preprocessorIDPool.getUniqueID(pSPattern.getID()));
        pSPattern2.setRich(pSPattern.getRichClone());
        if (pSPattern.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <pattern> with an <include>");
        }
        if (this.m_bKeepTitles && pSPattern.hasTitle()) {
            pSPattern2.setTitle(pSPattern.getTitle().getClone());
        }
        if ((string = pSPattern.getIsA()) != null) {
            PSPattern pSPattern3 = preprocessorLookup.getAbstractPatternOfID(string);
            if (pSPattern3 == null) {
                throw new SchematronPreprocessException("Failed to resolve the pattern denoted by is-a='" + string + "'");
            }
            if (!pSPattern2.hasID()) {
                LOGGER.warn("The instance of the abstract pattern denoted with is-a='" + string + "' should have an 'id' attribute to work with ISO Schematron as well");
                pSPattern2.setID(preprocessorIDPool.getUniqueID(pSPattern3.getID()));
            }
            if (!pSPattern2.hasRich()) {
                pSPattern2.setRich(pSPattern3.getRichClone());
            }
            ICommonsNavigableMap<String, String> iCommonsNavigableMap = this.m_aQueryBinding.getStringReplacementMap((List<PSParam>)pSPattern.getAllParams());
            for (IPSElement iPSElement : pSPattern3.getAllContentElements()) {
                PSRule pSRule;
                if (iPSElement instanceof PSLet) {
                    pSPattern2.addLet(((PSLet)iPSElement).getClone());
                    continue;
                }
                if (!(iPSElement instanceof PSRule) || (pSRule = this._getPreprocessedRule(pSPattern, (PSRule)iPSElement, preprocessorLookup, preprocessorIDPool, (ICommonsMap<String, String>)iCommonsNavigableMap)) == null) continue;
                pSPattern2.addRule(pSRule);
            }
        } else {
            for (IPSElement iPSElement : pSPattern.getAllContentElements()) {
                PSRule pSRule;
                if (iPSElement instanceof PSLet) {
                    pSPattern2.addLet(((PSLet)iPSElement).getClone());
                    continue;
                }
                if (!(iPSElement instanceof PSRule) || (pSRule = this._getPreprocessedRule(pSPattern, (PSRule)iPSElement, preprocessorLookup, preprocessorIDPool, null)) == null) continue;
                pSPattern2.addRule(pSRule);
            }
        }
        pSPattern2.addForeignElements((Iterable<IMicroElement>)pSPattern.getAllForeignElements());
        pSPattern2.addForeignAttributes((Map<String, String>)pSPattern.getAllForeignAttributes());
        return pSPattern2;
    }

    @Nonnull
    private static PSDiagnostics _getPreprocessedDiagnostics(@Nonnull PSDiagnostics pSDiagnostics) throws SchematronPreprocessException {
        PSDiagnostics pSDiagnostics2 = new PSDiagnostics();
        if (pSDiagnostics.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <diagnostics> with an <include>");
        }
        for (PSDiagnostic pSDiagnostic : pSDiagnostics.getAllDiagnostics()) {
            pSDiagnostics2.addDiagnostic(pSDiagnostic.getClone());
        }
        pSDiagnostics2.addForeignElements((Iterable<IMicroElement>)pSDiagnostics.getAllForeignElements());
        pSDiagnostics2.addForeignAttributes((Map<String, String>)pSDiagnostics.getAllForeignAttributes());
        return pSDiagnostics2;
    }

    @Nullable
    public PSSchema getAsMinimalSchema(@Nonnull PSSchema pSSchema) throws SchematronPreprocessException {
        ValueEnforcer.notNull((Object)pSSchema, (String)"Schema");
        if (pSSchema.isMinimal()) {
            return pSSchema;
        }
        return this.getForcedPreprocessedSchema(pSSchema);
    }

    @Nullable
    public PSSchema getAsPreprocessedSchema(@Nonnull PSSchema pSSchema) throws SchematronPreprocessException {
        ValueEnforcer.notNull((Object)pSSchema, (String)"Schema");
        if (pSSchema.isPreprocessed()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Schematron does not need any preprocessing. Returning Schema as-is.");
            }
            return pSSchema;
        }
        return this.getForcedPreprocessedSchema(pSSchema);
    }

    @Nullable
    public PSSchema getForcedPreprocessedSchema(@Nonnull PSSchema pSSchema) throws SchematronPreprocessException {
        ValueEnforcer.notNull((Object)pSSchema, (String)"Schema");
        PreprocessorLookup preprocessorLookup = new PreprocessorLookup(pSSchema);
        PreprocessorIDPool preprocessorIDPool = new PreprocessorIDPool();
        PSSchema pSSchema2 = new PSSchema(pSSchema.getResource());
        pSSchema2.setID(preprocessorIDPool.getUniqueID(pSSchema.getID()));
        pSSchema2.setRich(pSSchema.getRichClone());
        pSSchema2.setSchemaVersion(pSSchema.getSchemaVersion());
        pSSchema2.setDefaultPhase(pSSchema.getDefaultPhase());
        pSSchema2.setQueryBinding(pSSchema.getQueryBinding());
        if (this.m_bKeepTitles && pSSchema.hasTitle()) {
            pSSchema2.setTitle(pSSchema.getTitle().getClone());
        }
        if (pSSchema.hasAnyInclude()) {
            throw new SchematronPreprocessException("Cannot preprocess <schema> with an <include>");
        }
        for (IPSElement iPSElement : pSSchema.getAllNSs()) {
            pSSchema2.addNS(iPSElement.getClone());
        }
        for (IPSElement iPSElement : pSSchema.getAllLets()) {
            pSSchema2.addLet(((PSLet)iPSElement).getClone());
        }
        for (IPSElement iPSElement : pSSchema.getAllPhases()) {
            pSSchema2.addPhase(PSPreprocessor._getPreprocessedPhase((PSPhase)iPSElement, preprocessorIDPool));
        }
        for (IPSElement iPSElement : pSSchema.getAllPatterns()) {
            PSPattern pSPattern = this._getPreprocessedPattern((PSPattern)iPSElement, preprocessorLookup, preprocessorIDPool);
            if (pSPattern == null || pSPattern.getRuleCount() <= 0 && !this.m_bKeepEmptyPatterns) continue;
            pSSchema2.addPattern(pSPattern);
        }
        if (pSSchema.getPatternCount() == 0 && !this.m_bKeepEmptySchema) {
            return null;
        }
        if (this.m_bKeepDiagnostics && pSSchema.hasDiagnostics()) {
            pSSchema2.setDiagnostics(PSPreprocessor._getPreprocessedDiagnostics(pSSchema.getDiagnostics()));
        }
        pSSchema2.addForeignElements((Iterable<IMicroElement>)pSSchema.getAllForeignElements());
        pSSchema2.addForeignAttributes((Map<String, String>)pSSchema.getAllForeignAttributes());
        return pSSchema2;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("QueryBinding", (Object)this.m_aQueryBinding).append("KeepTitles", this.m_bKeepTitles).append("KeepDiagnostics", this.m_bKeepDiagnostics).append("KeepReports", this.m_bKeepReports).append("KeepEmptyPatterns", this.m_bKeepEmptyPatterns).append("KeepEmptySchema", this.m_bKeepEmptySchema).getToString();
    }

    @Nonnull
    public static PSPreprocessor createPreprocessorWithoutInformationLoss(@Nonnull IPSQueryBinding iPSQueryBinding) {
        PSPreprocessor pSPreprocessor = new PSPreprocessor(iPSQueryBinding);
        pSPreprocessor.setKeepReports(true);
        pSPreprocessor.setKeepDiagnostics(true);
        pSPreprocessor.setKeepTitles(true);
        return pSPreprocessor;
    }
}

