/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasTexts;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSEmph
implements IPSClonableElement<PSEmph>,
IPSOptionalElement,
IPSHasTexts {
    private final ICommonsList<String> m_aContent = new CommonsArrayList();

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<emph> has no content");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<emph> has no content");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add((Object)string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Nullable
    public String getAsText() {
        return StringHelper.getImploded(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "emph");
        for (String string : this.m_aContent) {
            microElement.appendText((CharSequence)string);
        }
        return microElement;
    }

    @Nonnull
    public PSEmph getClone() {
        PSEmph pSEmph = new PSEmph();
        for (String string : this.m_aContent) {
            pSEmph.addText(string);
        }
        return pSEmph;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).getToString();
    }
}

