/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.single;

import com.helger.collection.iterate.EmptyListIterator;
import com.helger.collection.iterate.SingleElementIterator;
import com.helger.collection.iterate.SingleElementListIterator;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.iterate.EmptyIterator;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SingleElementList<ELEMENTTYPE>
implements ICommonsList<ELEMENTTYPE> {
    private boolean m_bHasElement;
    private ELEMENTTYPE m_aElement;

    public SingleElementList() {
        this.m_bHasElement = false;
        this.m_aElement = null;
    }

    public SingleElementList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_bHasElement = true;
        this.m_aElement = ELEMENTTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public <T> SingleElementList<T> createInstance() {
        return new SingleElementList<ELEMENTTYPE>();
    }

    @Nonnull
    @ReturnsMutableCopy
    public SingleElementList<ELEMENTTYPE> getClone() {
        return this.m_bHasElement ? new SingleElementList<ELEMENTTYPE>(this.m_aElement) : new SingleElementList<ELEMENTTYPE>();
    }

    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = ELEMENTTYPE;
        this.m_bHasElement = true;
        return true;
    }

    public void add(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        ValueEnforcer.isTrue((n == 0 ? 1 : 0) != 0, () -> "Only 1 elements is allowed: " + n);
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        this.m_aElement = ELEMENTTYPE;
        this.m_bHasElement = true;
    }

    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> collection) {
        ValueEnforcer.notNull(collection, (String)"Elements");
        ValueEnforcer.isTrue((collection.size() <= 1 ? 1 : 0) != 0, (String)"Cannot add lists with more than one element!");
        if (this.m_bHasElement) {
            throw new IllegalStateException("List already contains an element");
        }
        Iterator<ELEMENTTYPE> iterator = collection.iterator();
        return iterator.hasNext() && this.add(iterator.next());
    }

    public boolean addAll(@Nonnegative int n, @Nonnull Collection<? extends ELEMENTTYPE> collection) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Only index 0 is valid!");
        }
        return this.addAll(collection);
    }

    public void clear() {
        this.m_aElement = null;
        this.m_bHasElement = false;
    }

    public boolean contains(@Nullable Object object) {
        return this.m_bHasElement && EqualsHelper.equals(this.m_aElement, (Object)object);
    }

    public boolean containsAll(@Nonnull Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public ELEMENTTYPE get(@Nonnegative int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_aElement;
    }

    public int indexOf(Object object) {
        return this.contains(object) ? 0 : -1;
    }

    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_bHasElement ? new SingleElementIterator<ELEMENTTYPE>(this.m_aElement) : new EmptyIterator();
    }

    public int lastIndexOf(@Nullable Object object) {
        return this.contains(object) ? 0 : -1;
    }

    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator() {
        return this.m_bHasElement ? new SingleElementListIterator<ELEMENTTYPE>(this.m_aElement) : new EmptyListIterator();
    }

    @Nonnull
    public ListIterator<ELEMENTTYPE> listIterator(int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.listIterator();
    }

    @Nullable
    public ELEMENTTYPE remove(int n) {
        if (!this.m_bHasElement || n != 0) {
            throw new IndexOutOfBoundsException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aElement;
        this.m_aElement = null;
        this.m_bHasElement = false;
        return ELEMENTTYPE;
    }

    public boolean remove(@Nullable Object object) {
        if (!this.contains(object)) {
            return false;
        }
        this.m_aElement = null;
        this.m_bHasElement = false;
        return true;
    }

    public boolean removeAll(@Nullable Collection<?> collection) {
        boolean bl = true;
        if (collection != null) {
            for (Object obj : collection) {
                if (this.remove(obj)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean retainAll(@Nonnull Collection<?> collection) {
        ValueEnforcer.notNull(collection, (String)"Elements");
        if (this.m_bHasElement) {
            if (collection.contains(this.m_aElement)) {
                return true;
            }
            this.clear();
        }
        return false;
    }

    @Nullable
    public ELEMENTTYPE set(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (n != 0) {
            throw new IllegalArgumentException("The passed index can onyl be 0!");
        }
        ELEMENTTYPE ELEMENTTYPE2 = this.m_aElement;
        this.m_bHasElement = true;
        this.m_aElement = ELEMENTTYPE;
        return ELEMENTTYPE2;
    }

    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public ICommonsList<ELEMENTTYPE> subList(@Nonnegative int n, @Nonnegative int n2) {
        if (n < 0 || n > (this.m_bHasElement ? 1 : 0)) {
            throw new IndexOutOfBoundsException("Invalid from index " + n);
        }
        if (n2 < 0 || n2 > (this.m_bHasElement ? 1 : 0)) {
            throw new IndexOutOfBoundsException("Invalid to index " + n2);
        }
        if (!this.m_bHasElement || n == n2) {
            return new CommonsArrayList(0);
        }
        return this;
    }

    @Nonnull
    public Object[] toArray() {
        if (this.m_bHasElement) {
            Object[] objectArray = new Object[]{this.m_aElement};
            return objectArray;
        }
        return ArrayHelper.EMPTY_OBJECT_ARRAY;
    }

    @Nonnull
    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(@Nonnull ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray) {
        ValueEnforcer.notNull(ARRAYELEMENTTYPEArray, (String)"Dest");
        if (!this.m_bHasElement) {
            return ARRAYELEMENTTYPEArray;
        }
        if (this.m_aElement != null && !ARRAYELEMENTTYPEArray.getClass().getComponentType().isAssignableFrom(this.m_aElement.getClass())) {
            throw new ArrayStoreException("The array class " + String.valueOf(ARRAYELEMENTTYPEArray.getClass()) + " cannot store the item of class " + String.valueOf(this.m_aElement.getClass()));
        }
        ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray2 = ARRAYELEMENTTYPEArray.length < 1 ? ArrayHelper.newArraySameType((Object[])ARRAYELEMENTTYPEArray, (int)1) : ARRAYELEMENTTYPEArray;
        ARRAYELEMENTTYPEArray2[0] = GenericReflection.uncheckedCast(this.m_aElement);
        if (ARRAYELEMENTTYPEArray2.length > 1) {
            ARRAYELEMENTTYPEArray2[1] = null;
        }
        return ARRAYELEMENTTYPEArray2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementList singleElementList = (SingleElementList)object;
        return this.m_bHasElement == singleElementList.m_bHasElement && EqualsHelper.equals(this.m_aElement, singleElementList.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bHasElement).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hasElement", this.m_bHasElement).append("element", this.m_aElement).getToString();
    }
}

