/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ArrayEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private ELEMENTTYPE[] m_aArray;
    private int m_nIndex;

    @SafeVarargs
    public ArrayEnumeration(ELEMENTTYPE ... ELEMENTTYPEArray) {
        this(ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length);
    }

    public ArrayEnumeration(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(ELEMENTTYPEArray, (String)"Array");
        ValueEnforcer.isGE0((int)n, (String)"StartIndex");
        ValueEnforcer.isGE0((int)n2, (String)"Length");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy((Object[])ELEMENTTYPEArray, (int)n, (int)n2);
    }

    @Nonnegative
    protected final int getIndex() {
        return this.m_nIndex;
    }

    @Nullable
    protected final ELEMENTTYPE get(@Nonnegative int n) {
        return this.m_aArray[n];
    }

    @Nonnegative
    protected final int getCount() {
        return this.m_aArray.length;
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aArray[this.m_nIndex];
        ++this.m_nIndex;
        return ELEMENTTYPE;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayEnumeration arrayEnumeration = (ArrayEnumeration)object;
        return EqualsHelper.equals(this.m_aArray, arrayEnumeration.m_aArray) && this.m_nIndex == arrayEnumeration.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object[])this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("array", (Object[])this.m_aArray).append("index", this.m_nIndex).getToString();
    }
}

