/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.logging.ResolverLogger;

public class ResourceConnection {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Pattern CHARSET = Pattern.compile(";\\s*charset\\s*=\\s*([^;]+)");
    private InputStream stream = null;
    private URI uri = null;
    private URI redirect = null;
    private int statusCode = -1;
    private String contentType = null;
    private String encoding = null;
    private String etag = null;
    private Long lastModified = -1L;
    private Long date = -1L;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private boolean connected = false;

    public ResourceConnection(URI initialUri) {
        this.uri = initialUri;
    }

    public void get(ResolverConfiguration config) {
        this.get(config, false);
    }

    public void get(ResolverConfiguration config, boolean headOnly) {
        try {
            HashSet<URI> visited = new HashSet<URI>();
            URI connUri = this.uri;
            URLConnection connection = null;
            boolean tryAgain = true;
            while (tryAgain) {
                visited.add(connUri);
                URL url = connUri.toURL();
                connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    String location;
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    httpConnection.setInstanceFollowRedirects(true);
                    if (headOnly) {
                        httpConnection.setRequestMethod("HEAD");
                    } else {
                        httpConnection.setRequestMethod("GET");
                    }
                    httpConnection.connect();
                    this.statusCode = httpConnection.getResponseCode();
                    tryAgain = this.statusCode == 301 || this.statusCode == 302;
                    if (!tryAgain) continue;
                    if (!headOnly) {
                        try {
                            httpConnection.getInputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!visited.contains(connUri = URI.create(location = httpConnection.getHeaderField("Location")))) continue;
                    throw new IllegalArgumentException("Redirect URI already visited: " + connUri);
                }
                tryAgain = false;
                connection.connect();
                this.statusCode = 200;
            }
            this.connected = true;
            if (headOnly) {
                if (connection.getInputStream() != null) {
                    connection.getInputStream().close();
                }
            } else {
                this.stream = connection.getInputStream();
            }
            this.contentType = connection.getContentType();
            this.encoding = this.getEncoding(this.contentType);
            this.etag = connection.getHeaderField("ETag");
            this.lastModified = connection.getLastModified();
            this.date = connection.getDate();
            Map<String, List<String>> connectionHeaders = connection.getHeaderFields();
            for (String key : connectionHeaders.keySet()) {
                if (key == null) continue;
                String name = key.toLowerCase();
                this.headers.put(name, connectionHeaders.get(key));
            }
            this.redirect = connection.getURL().toURI();
            if (this.uri.equals(this.redirect)) {
                this.redirect = null;
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException use) {
            ResolverLogger logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
            logger.log("warning", "Failed to %s: %s: %s", headOnly ? "HEAD" : "GET", this.uri, use.getMessage());
        }
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
        this.connected = true;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getRedirect() {
        return this.redirect;
    }

    public void setRedirect(URI redirect) {
        this.redirect = redirect;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private String getEncoding(String contentType) {
        Matcher match;
        int pos;
        if (contentType != null && (pos = contentType.indexOf(";")) >= 0 && (match = CHARSET.matcher(contentType = contentType.substring(pos))).find()) {
            return match.group(1);
        }
        return null;
    }
}

