/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.model.IPSElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundElement {
    private final Object m_aElement;
    private final String m_sExpression;
    private final XPathExpression m_aBoundExpression;

    public PSXPathBoundElement(@Nonnull String string) {
        this(string, null, null);
    }

    public PSXPathBoundElement(@Nonnull IPSElement iPSElement) {
        this(iPSElement, null, null);
    }

    public PSXPathBoundElement(@Nonnull Object object, @Nullable String string, @Nullable XPathExpression xPathExpression) {
        ValueEnforcer.notNull((Object)object, (String)"Element");
        ValueEnforcer.isTrue((object instanceof String || object instanceof IPSElement ? 1 : 0) != 0, (String)"Element must be a String of a PS element");
        this.m_aElement = object;
        this.m_sExpression = string;
        this.m_aBoundExpression = xPathExpression;
    }

    @Nonnull
    public final Object getElement() {
        return this.m_aElement;
    }

    @Nullable
    public final String getExpression() {
        return this.m_sExpression;
    }

    @Nullable
    public final XPathExpression getBoundExpression() {
        return this.m_aBoundExpression;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Element", this.m_aElement).appendIfNotNull("Expression", (Object)this.m_sExpression).appendIfNotNull("BoundExpression", (Object)this.m_aBoundExpression).getToString();
    }
}

