/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroProcessingInstruction
extends AbstractMicroNode
implements IMicroProcessingInstruction {
    private final String m_sTarget;
    private final String m_sData;

    public MicroProcessingInstruction(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public MicroProcessingInstruction(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_sTarget = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Target");
        this.m_sData = string2;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.PROCESSING_INSTRUCTION;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return "#pi";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeValue() {
        return this.getTarget();
    }

    @Override
    public String getTarget() {
        return this.m_sTarget;
    }

    @Override
    public String getData() {
        return this.m_sData;
    }

    @Override
    @Nonnull
    public IMicroProcessingInstruction getClone() {
        return new MicroProcessingInstruction(this.m_sTarget, this.m_sData);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroProcessingInstruction microProcessingInstruction = (MicroProcessingInstruction)iMicroNode;
        return this.m_sTarget.equals(microProcessingInstruction.m_sTarget) && EqualsHelper.equals((Object)this.m_sData, (Object)microProcessingInstruction.m_sData);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("target", (Object)this.m_sTarget).append("data", (Object)this.m_sData).getToString();
    }
}

