/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.CatalogResolver;
import org.xmlresolver.NamespaceResolver;
import org.xmlresolver.ResolverConstants;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.sources.ResolverInputSource;
import org.xmlresolver.sources.ResolverLSInput;
import org.xmlresolver.sources.ResolverSAXSource;

public class Resolver
implements URIResolver,
LSResourceResolver,
EntityResolver,
EntityResolver2,
NamespaceResolver {
    public static final String PURPOSE_SCHEMA_VALIDATION = "http://www.rddl.org/purposes#schema-validation";
    public static final String NATURE_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String NATURE_XML_SCHEMA_1_1 = "http://www.w3.org/2001/XMLSchema/v1.1";
    public static final String NATURE_RELAX_NG = "http://relaxng.org/ns/structure/1.0";
    private final ResolverLogger logger;
    protected final XMLResolverConfiguration config;
    protected final XMLResolver resolver;
    protected CatalogResolver catalogResolver = null;

    public Resolver() {
        this(new XMLResolverConfiguration());
    }

    public Resolver(XMLResolverConfiguration config) {
        this.config = config;
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        this.resolver = new XMLResolver(config);
    }

    public Resolver(CatalogResolver resolver) {
        this.config = resolver.getConfiguration();
        this.logger = this.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        this.resolver = new XMLResolver(this.config);
    }

    public static String version() {
        return "6.0.11";
    }

    public XMLResolverConfiguration getConfiguration() {
        return this.config;
    }

    public CatalogResolver getCatalogResolver() {
        if (this.catalogResolver == null) {
            this.catalogResolver = new CatalogResolver(this.config);
        }
        return this.catalogResolver;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        ResourceRequest req = this.resolver.getRequest(href, base);
        return this.resolverAdapter(req);
    }

    @Override
    public Source resolveNamespace(String uri, String nature, String purpose) throws TransformerException {
        ResourceRequest req = this.resolver.getRequest(uri, nature, purpose);
        return this.resolverAdapter(req);
    }

    private Source resolverAdapter(ResourceRequest req) throws TransformerException {
        ResourceResponse resp = this.resolver.resolve(req);
        if (!resp.isResolved()) {
            if (!this.config.getFeature(ResolverFeature.ALWAYS_RESOLVE).booleanValue()) {
                return null;
            }
            try {
                resp = this.config.getResource(req);
            }
            catch (IOException | IllegalArgumentException | URISyntaxException ex) {
                if (this.resolver.getConfiguration().getFeature(ResolverFeature.THROW_URI_EXCEPTIONS).booleanValue()) {
                    throw new TransformerException(ex);
                }
                return null;
            }
        }
        if (resp.isResolved()) {
            ResolverSAXSource source = new ResolverSAXSource(resp);
            source.setSystemId(resp.getResolvedURI().toString());
            return source;
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        ResourceResponse resp;
        ResourceRequest req = null;
        if (type == null || "http://www.w3.org/TR/REC-xml".equals(type)) {
            this.logger.log("request", "resolveResource: XML: %s (baseURI: %s, publicId: %s)", systemId, baseURI, publicId);
            req = this.resolver.getRequest(systemId, baseURI, "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", ResolverConstants.ANY_PURPOSE);
            req.setPublicId(publicId);
        } else {
            this.logger.log("request", "resolveResource: %s, %s (namespace: %s, baseURI: %s, publicId: %s)", type, systemId, namespaceURI, baseURI, publicId);
            String purpose = null;
            if (NATURE_XML_SCHEMA.equals(type) || NATURE_XML_SCHEMA_1_1.equals(type) || NATURE_RELAX_NG.equals(type)) {
                purpose = PURPOSE_SCHEMA_VALIDATION;
            }
            if (systemId != null) {
                req = this.resolver.getRequest(systemId, baseURI, type, purpose);
            }
        }
        if (req != null && (resp = this.resolver.resolve(req)).isResolved()) {
            return new ResolverLSInput(resp, publicId);
        }
        return null;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        ResourceRequest req = this.resolver.getRequest(baseURI, null, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
        req.setEntityName(name);
        ResourceResponse resp = this.resolver.resolve(req);
        if (resp.isResolved()) {
            ResolverInputSource source = new ResolverInputSource(resp);
            source.setSystemId(resp.getResolvedURI().toString());
            return source;
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        ResourceRequest req = this.resolver.getRequest(systemId, baseURI, "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", ResolverConstants.ANY_PURPOSE);
        req.setEntityName(name);
        req.setPublicId(publicId);
        ResourceResponse resp = this.resolver.resolve(req);
        if (resp.isResolved()) {
            ResolverInputSource source = new ResolverInputSource(resp);
            source.setSystemId(resp.getResolvedURI().toString());
            return source;
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }
}

