/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.xpath;

import com.helger.commons.lang.GenericReflection;
import com.helger.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.xpath.JAXPVariableReference;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class XPathEvaluationHelper {
    private XPathEvaluationHelper() {
    }

    private static boolean isSaxonImplementation(@Nonnull XPathExpression xPathExpression) {
        return "net.sf.saxon.xpath.XPathExpressionImpl".equals(xPathExpression.getClass().getName());
    }

    @Nullable
    public static Object evaluateWithTypeAutodetect(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        if (!XPathEvaluationHelper.isSaxonImplementation(xPathExpression)) {
            return null;
        }
        QName qName = SaxonEvaluator.findReturnType(xPathExpression);
        if (qName == null) {
            return null;
        }
        return XPathEvaluationHelper.evaluate(xPathExpression, node, qName, string);
    }

    @Nullable
    public static <T> T evaluate(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nonnull QName qName, @Nullable String string) throws XPathExpressionException {
        Object object = node;
        if (string != null && XPathEvaluationHelper.isSaxonImplementation(xPathExpression)) {
            object = SaxonEvaluator.getBaseUriFixed(xPathExpression, node, string);
        }
        Object object2 = xPathExpression.evaluate(object, qName);
        return (T)GenericReflection.uncheckedCast((Object)object2);
    }

    @Nullable
    public static Boolean evaluateAsBooleanObj(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (Boolean)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.BOOLEAN, string);
    }

    public static boolean evaluateAsBoolean(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        Boolean bl = XPathEvaluationHelper.evaluateAsBooleanObj(xPathExpression, node, string);
        if (bl == null) {
            throw new XPathExpressionException("Failed to evaluate the XPath expression as boolean");
        }
        return bl;
    }

    @Nullable
    public static Node evaluateAsNode(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (Node)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.NODE, string);
    }

    @Nullable
    public static NodeList evaluateAsNodeList(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (NodeList)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.NODESET, string);
    }

    @Nullable
    public static Double evaluateAsNumber(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (Double)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.NUMBER, string);
    }

    @Nullable
    public static String evaluateAsString(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nullable String string) throws XPathExpressionException {
        return (String)XPathEvaluationHelper.evaluate(xPathExpression, node, XPathConstants.STRING, string);
    }

    @Immutable
    private static final class SaxonEvaluator {
        private static final Logger LOGGER = LoggerFactory.getLogger(SaxonEvaluator.class);

        private SaxonEvaluator() {
        }

        @Nonnull
        static Object getBaseUriFixed(@Nonnull XPathExpression xPathExpression, @Nonnull Node node, @Nonnull String string) {
            XPathExpressionImpl xPathExpressionImpl = (XPathExpressionImpl)xPathExpression;
            return new DocumentWrapper((Node)XMLHelper.getOwnerDocument((Node)node), string, xPathExpressionImpl.getConfiguration()).wrap(node);
        }

        private static QName _findReturnType(UType uType) {
            if (uType == UType.BOOLEAN) {
                return XPathConstants.BOOLEAN;
            }
            if (uType == UType.DECIMAL || uType == UType.FLOAT || uType == UType.DOUBLE) {
                return XPathConstants.NUMBER;
            }
            if (uType == UType.ATTRIBUTE || uType == UType.TEXT || uType == UType.COMMENT || uType == UType.PI || uType == UType.NAMESPACE || uType == UType.STRING || uType == UType.DURATION || uType == UType.DATE_TIME || uType == UType.DATE || uType == UType.TIME || uType == UType.G_YEAR_MONTH || uType == UType.G_YEAR || uType == UType.G_MONTH_DAY || uType == UType.G_DAY || uType == UType.G_MONTH || uType == UType.HEX_BINARY || uType == UType.BASE64_BINARY || uType == UType.ANY_URI || uType == UType.QNAME || uType == UType.NOTATION || uType == UType.UNTYPED_ATOMIC) {
                return XPathConstants.STRING;
            }
            if (uType == UType.DOCUMENT || uType == UType.ELEMENT) {
                return XPathConstants.NODE;
            }
            if (uType == UType.ANY_NODE) {
                return XPathConstants.NODESET;
            }
            LOGGER.warn("Unknown Saxon UType: " + String.valueOf(uType));
            return null;
        }

        @Nullable
        private static QName _findReturnType(@Nonnull ItemType itemType) {
            if (itemType instanceof BuiltInAtomicType) {
                BuiltInAtomicType builtInAtomicType = (BuiltInAtomicType)itemType;
                if (builtInAtomicType.equals((Object)BuiltInAtomicType.BOOLEAN)) {
                    return XPathConstants.BOOLEAN;
                }
                if (builtInAtomicType.isNumericType()) {
                    return XPathConstants.NUMBER;
                }
                if (BuiltInAtomicType.isStringLike((ItemType)builtInAtomicType)) {
                    return XPathConstants.STRING;
                }
                return XPathConstants.NODESET;
            }
            if (itemType instanceof NodeKindTest) {
                NodeKindTest nodeKindTest = (NodeKindTest)itemType;
                return SaxonEvaluator._findReturnType(nodeKindTest.getUType());
            }
            LOGGER.warn("Unknown Saxon type: " + (itemType == null ? "null" : itemType.getClass().getName()));
            return null;
        }

        @Nullable
        private static QName _findReturnType(@Nonnull Expression expression) {
            if (expression instanceof ValueComparison || expression instanceof GeneralComparison) {
                return XPathConstants.BOOLEAN;
            }
            if (expression instanceof StringLiteral) {
                return XPathConstants.STRING;
            }
            if (expression instanceof ArithmeticExpression) {
                return XPathConstants.NUMBER;
            }
            if (expression instanceof ContextItemExpression || expression instanceof FirstItemExpression) {
                return XPathConstants.NODE;
            }
            if (expression instanceof SlashExpression || expression instanceof DocumentSorter || expression instanceof ForExpression || expression instanceof FilterExpression) {
                return XPathConstants.NODESET;
            }
            if (expression instanceof Literal) {
                Literal literal = (Literal)expression;
                GroundedValue groundedValue = literal.getGroundedValue();
                if (groundedValue instanceof BooleanValue) {
                    return XPathConstants.BOOLEAN;
                }
                if (groundedValue instanceof BigDecimalValue || groundedValue instanceof Int64Value) {
                    return XPathConstants.NUMBER;
                }
                if (groundedValue instanceof SequenceExtent.Of) {
                    return XPathConstants.NODESET;
                }
                LOGGER.warn("Unknown Saxon grounded value type: " + (groundedValue == null ? "null" : groundedValue.getClass().getName()));
                return null;
            }
            if (expression instanceof CastExpression) {
                AtomicType atomicType = ((CastExpression)expression).getTargetType();
                return SaxonEvaluator._findReturnType((ItemType)atomicType);
            }
            if (expression instanceof StaticFunctionCall) {
                FunctionItem functionItem = ((StaticFunctionCall)expression).getTargetFunction();
                return SaxonEvaluator._findReturnType(functionItem.getFunctionItemType().getResultType().getPrimaryType());
            }
            if (expression instanceof JAXPVariableReference) {
                return null;
            }
            LOGGER.warn("Unknown Saxon expression type: " + expression.getClass().getName());
            return null;
        }

        @Nullable
        static QName findReturnType(@Nonnull XPathExpression xPathExpression) {
            XPathExpressionImpl xPathExpressionImpl = (XPathExpressionImpl)xPathExpression;
            try {
                return SaxonEvaluator._findReturnType(xPathExpressionImpl.getInternalExpression());
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to evaluate Saxon internal type: " + throwable.getClass().getName() + " - " + throwable.getMessage());
                return null;
            }
        }
    }
}

