/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.model.PSAssertReport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundAssertReport {
    private final PSAssertReport m_aAssertReport;
    private final String m_sTestExpression;
    private final XPathExpression m_aBoundTestExpression;
    private final ICommonsList<PSXPathBoundElement> m_aBoundContent;
    private final ICommonsMap<String, PSXPathBoundDiagnostic> m_aBoundDiagnostics;

    public PSXPathBoundAssertReport(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull XPathExpression xPathExpression, @Nonnull ICommonsList<PSXPathBoundElement> iCommonsList, @Nonnull ICommonsMap<String, PSXPathBoundDiagnostic> iCommonsMap) {
        ValueEnforcer.notNull((Object)pSAssertReport, (String)"AssertReport");
        ValueEnforcer.notNull((Object)string, (String)"TestExpression");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"BoundTestExpression");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundContent");
        ValueEnforcer.notNull(iCommonsMap, (String)"BoundDiagnostics");
        this.m_aAssertReport = pSAssertReport;
        this.m_sTestExpression = string;
        this.m_aBoundTestExpression = xPathExpression;
        this.m_aBoundContent = iCommonsList;
        this.m_aBoundDiagnostics = iCommonsMap;
    }

    @Nonnull
    public final PSAssertReport getAssertReport() {
        return this.m_aAssertReport;
    }

    @Nonnull
    public final String getTestExpression() {
        return this.m_sTestExpression;
    }

    @Nonnull
    public final XPathExpression getBoundTestExpression() {
        return this.m_aBoundTestExpression;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<PSXPathBoundElement> getAllBoundContentElements() {
        return (ICommonsList)this.m_aBoundContent.getClone();
    }

    @Nullable
    public final PSXPathBoundDiagnostic getBoundDiagnosticOfID(@Nullable String string) {
        return (PSXPathBoundDiagnostic)this.m_aBoundDiagnostics.get((Object)string);
    }

    @Nullable
    public final ICommonsMap<String, PSXPathBoundDiagnostic> getAllBoundDiagnostics() {
        return (ICommonsMap)this.m_aBoundDiagnostics.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("AssertReport", (Object)this.m_aAssertReport).append("TestExpression", (Object)this.m_sTestExpression).append("BoundTestExpression", (Object)this.m_aBoundTestExpression).append("BoundContent", this.m_aBoundContent).append("BoundDiagnostics", this.m_aBoundDiagnostics).getToString();
    }
}

