/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.location;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface ILocation {
    public static final int ILLEGAL_NUMBER = -1;

    @Nullable
    public String getResourceID();

    default public boolean hasResourceID() {
        return StringHelper.hasText(this.getResourceID());
    }

    public int getLineNumber();

    default public boolean hasLineNumber() {
        return this.getLineNumber() > -1;
    }

    public int getColumnNumber();

    default public boolean hasColumnNumber() {
        return this.getColumnNumber() > -1;
    }

    default public boolean isAnyInformationPresent() {
        return this.hasResourceID() || this.hasLineNumber() || this.hasColumnNumber();
    }

    @Nonnull
    default public String getAsString() {
        Object object = "";
        String string = this.getResourceID();
        if (StringHelper.hasText(string)) {
            object = (String)object + string;
        }
        if (this.hasLineNumber()) {
            object = this.hasColumnNumber() ? (String)object + "(" + this.getLineNumber() + ":" + this.getColumnNumber() + ")" : (String)object + "(" + this.getLineNumber() + ":?)";
        } else if (this.hasColumnNumber()) {
            object = (String)object + "(?:" + this.getColumnNumber() + ")";
        }
        return object;
    }
}

