/*
 * Decompiled with CFR 0.152.
 */
package com.inet.facturx.problemfinder;

import com.inet.annotations.InternalApi;
import com.inet.error.HasErrorCode;
import com.inet.facturx.FacturXPlugin;
import com.inet.facturx.profiles.ModelPathImpl;
import com.inet.plugin.ServerPluginManager;
import com.inet.problemfinder.ProblemFinderWarning;
import com.inet.problemfinder.ProblemFinderWarningImpl;
import com.inet.problemfinder.rules.AbstractRuleReport;
import com.inet.problemfinder.rules.ProblemFinderRule;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.FacturXSettings;
import com.inet.report.Field;
import com.inet.report.FormulaField;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import com.inet.report.output.DocumentOutputStream;
import com.inet.report.renderer.factur.FacturModelProvider;
import com.inet.report.renderer.factur.FacturProvider;
import com.inet.report.renderer.factur.model.FacturModelNode;
import com.inet.report.renderer.factur.model.FacturProfileModel;
import com.inet.report.renderer.factur.model.ModelPath;
import com.inet.report.renderer.factur.model.ProfileLevel;
import com.inet.report.renderer.factur.model.Validator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;

@InternalApi
public class FacturValidateRule
extends AbstractRuleReport {
    private boolean H = false;
    private List<ProblemFinderWarning> I = new ArrayList<ProblemFinderWarning>();
    private URL J;
    private Map<String, String> K;
    private Properties L;
    private ProfileLevel M;
    private FacturModelProvider N;

    public FacturValidateRule() {
        List list = ServerPluginManager.getInstance().get(FacturProvider.class);
        this.N = ((FacturProvider)list.get(0)).getModelProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ProblemFinderWarning> findErrors(Engine originalEngine, Properties userProperties) {
        try {
            FacturXSettings facturXSettings = originalEngine.getFacturXSettings();
            ProfileLevel profileLevel = facturXSettings.getProfile();
            HashMap hashMap = facturXSettings.getFields();
            if (hashMap.size() == 0) {
                return new ArrayList<ProblemFinderWarning>();
            }
            hashMap.put("data_group", facturXSettings.getDataGroup());
            Map<String, String> map = this.a(hashMap);
            if (this.H) return this.I;
            if (originalEngine.getReportFile().equals(this.J) && profileLevel == this.M && map.equals(this.K)) {
                if (Objects.equals(userProperties, this.L)) return this.I;
            }
            this.H = true;
            this.K = map;
            this.J = originalEngine.getReportFile();
            this.L = userProperties;
            this.M = profileLevel;
            this.I.clear();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RDC.saveEngine((OutputStream)byteArrayOutputStream, (Engine)originalEngine);
                byteArrayOutputStream.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                Engine engine = RDC.loadEngine((URL)originalEngine.getReportFile(), (InputStream)byteArrayInputStream, (String)"factur", (Properties)originalEngine.getUserProperties());
                Properties properties = engine.getMetaProperties();
                properties.put("facturerror", "true");
                if (userProperties != null) {
                    RDC.setEngineParams((Engine)engine, (Properties)userProperties, null, null);
                }
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                engine.setDocumentOutput((DocumentOutput)new DocumentOutputStream((OutputStream)byteArrayOutputStream2, true));
                engine.execute();
                engine.getPageCount();
                String string = engine.getErrorMsg();
                if (string != null) {
                    this.I.add((ProblemFinderWarning)new ProblemFinderWarningImpl((Object)ProblemFinderWarning.Sources.FACTURX, ProblemFinderWarning.Type.INFO, (ProblemFinderRule)this, string, this.getRuleLabel(), new AbstractAction[0]));
                }
                this.I.addAll(this.a(byteArrayOutputStream2.toByteArray(), profileLevel));
                return this.I;
            }
            catch (Exception exception) {
                if (exception instanceof HasErrorCode) {
                    int n = ((HasErrorCode)exception).getErrorCode();
                    if (n == ReportErrorCode.Interrupted.getErrorCodeNumber()) {
                        List<ProblemFinderWarning> list = this.I;
                        return list;
                    }
                    if (n == ReportErrorCode.NeedPrompts.getErrorCodeNumber()) {
                        String string = FacturXPlugin.MSG.getMsg("error.needprompts", new Object[0]);
                        this.I.add((ProblemFinderWarning)new ProblemFinderWarningImpl((Object)ProblemFinderWarning.Sources.FACTURX, ProblemFinderWarning.Type.INFO, (ProblemFinderRule)this, string, this.getRuleLabel(), new AbstractAction[0]));
                        List<ProblemFinderWarning> list = this.I;
                        return list;
                    }
                }
                BaseUtils.error((Object)exception);
                this.I.add((ProblemFinderWarning)new ProblemFinderWarningImpl((Object)ProblemFinderWarning.Sources.FACTURX, ProblemFinderWarning.Type.ERROR, (ProblemFinderRule)this, exception.getMessage(), this.getRuleLabel(), new AbstractAction[0]));
                return this.I;
            }
            finally {
                this.H = false;
            }
        }
        catch (ReportException reportException) {
            return this.I;
        }
    }

    private Map<String, String> a(HashMap<String, Field> hashMap) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String string : hashMap.keySet()) {
            hashMap2.put(string, this.a(hashMap.get(string)));
        }
        return hashMap2;
    }

    private String a(Field field) {
        if (field == null) {
            return null;
        }
        if (field instanceof FormulaField) {
            return ((FormulaField)field).getFormula();
        }
        return field.getName() + "_" + field.getValueType();
    }

    private List<ProblemFinderWarning> a(byte[] byArray, ProfileLevel profileLevel) {
        ArrayList<ProblemFinderWarning> arrayList = new ArrayList<ProblemFinderWarning>();
        if (FacturXPlugin.LOGGER.isDebug()) {
            FacturXPlugin.LOGGER.debug((Object)("Validation XML = '" + new String(byArray) + "'"));
        }
        FacturProfileModel facturProfileModel = this.N.getProfileMode(profileLevel);
        List list = facturProfileModel.getValidator().validateXML(byArray);
        for (Validator.ValidationError validationError : list) {
            String string = FacturValidateRule.getMessageAndCode(facturProfileModel, validationError);
            ProblemFinderWarningImpl problemFinderWarningImpl = new ProblemFinderWarningImpl((Object)ProblemFinderWarning.Sources.FACTURX, ProblemFinderWarning.Type.ERROR, (ProblemFinderRule)this, string, string, new AbstractAction[0]);
            if (!arrayList.contains(problemFinderWarningImpl)) {
                arrayList.add((ProblemFinderWarning)problemFinderWarningImpl);
            }
            if (!FacturXPlugin.LOGGER.isDebug()) continue;
            FacturXPlugin.LOGGER.debug((Object)string);
        }
        return arrayList;
    }

    public static String getMessageAndCode(FacturProfileModel model, Validator.ValidationError error) {
        List list;
        Object object = error.getMessage();
        FacturModelNode facturModelNode = FacturValidateRule.a(error.getPath(), model);
        if (facturModelNode != null && (list = facturModelNode.getBusinessTerms()) != null && list.size() > 0) {
            object = list.stream().collect(Collectors.joining(",")) + ": " + (String)object;
        }
        return object;
    }

    private static FacturModelNode a(String string, FacturProfileModel facturProfileModel) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split("/\\*")) {
            String string3;
            if (!string2.startsWith("[local-name()='") || !string2.endsWith("']") || (string3 = string2.substring("[local-name()='".length(), string2.length() - 2)).length() == 0) continue;
            arrayList.add(string3);
        }
        if (arrayList.size() == 0) {
            FacturXPlugin.LOGGER.debug((Object)("Unable to find FacturX business-term by XPath: " + string));
            return null;
        }
        String string4 = arrayList.stream().collect(Collectors.joining("."));
        ModelPathImpl modelPathImpl = new ModelPathImpl(string4);
        FacturModelNode facturModelNode = facturProfileModel.getNode((ModelPath)modelPathImpl);
        if (facturModelNode == null) {
            FacturXPlugin.LOGGER.debug((Object)("Unable to find FacturX business-term by XPath: " + string));
            return null;
        }
        return facturModelNode;
    }

    public String getRuleLabel() {
        return "FacturX_Validation";
    }
}

