/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.resourcebundle;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.resourcebundle.XMLResourceBundleControl;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class XMLResourceBundle
extends ResourceBundle {
    private final ICommonsOrderedMap<String, String> m_aValues;

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> readFromPropertiesXML(@Nonnull @WillClose InputStream inputStream) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
        if (iMicroDocument != null) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("entry")) {
                commonsLinkedHashMap.put((Object)iMicroElement.getAttributeValue("key"), (Object)iMicroElement.getTextContent());
            }
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    public static IMicroDocument getAsPropertiesXML(@Nonnull ICommonsMap<String, String> iCommonsMap) {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("properties");
        for (Map.Entry entry : iCommonsMap.entrySet()) {
            ((IMicroElement)iMicroElement.appendElement("entry").setAttribute("key", (String)entry.getKey())).appendText((CharSequence)entry.getValue());
        }
        return microDocument;
    }

    @DevelopersNote(value="Don't use it manually - use the static methods of this class!")
    XMLResourceBundle(@Nonnull @WillNotClose InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        this.m_aValues = XMLResourceBundle.readFromPropertiesXML(inputStream);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllValues() {
        return this.m_aValues.getClone();
    }

    @Override
    @CodingStyleguideUnaware
    protected Set<String> handleKeySet() {
        return this.m_aValues.keySet();
    }

    @Override
    protected String handleGetObject(@Nullable String string) {
        return (String)this.m_aValues.get((Object)string);
    }

    @Override
    public Enumeration<String> getKeys() {
        return IteratorHelper.getEnumeration((Iterable)this.m_aValues.keySet());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string) {
        return XMLResourceBundle.getXMLBundle(string, Locale.getDefault());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string, @Nonnull Locale locale) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, new XMLResourceBundleControl());
    }

    @Nonnull
    public static XMLResourceBundle getXMLBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull ClassLoader classLoader) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, classLoader, new XMLResourceBundleControl());
    }
}

