/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.entry;

import java.net.URI;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.utils.URIUtils;

public class EntryUri
extends Entry {
    public final String name;
    public final String nature;
    public final String purpose;
    public final URI uri;

    public EntryUri(ResolverConfiguration config, URI baseURI, String id, String name, String uri, String nature, String purpose) {
        super(config, baseURI, id);
        this.name = name.startsWith("classpath:/") ? "classpath:" + name.substring(11) : name;
        this.nature = nature;
        this.purpose = purpose;
        this.uri = URIUtils.resolve(baseURI, uri);
    }

    @Override
    public Entry.Type getType() {
        return Entry.Type.URI;
    }

    public String toString() {
        String str = "uri " + this.name + Entry.rarr + this.uri;
        if (this.nature != null || this.purpose != null) {
            str = str + " (";
            if (this.nature != null) {
                str = str + "nature=" + this.nature;
            }
            if (this.nature != null && this.purpose != null) {
                str = str + "; ";
            }
            if (this.purpose != null) {
                str = str + "purpose=" + this.purpose;
            }
            str = str + ")";
        }
        return str;
    }
}

