/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.net.URI;
import java.net.URISyntaxException;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverConstants;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.utils.URIUtils;

public class ResourceRequest {
    public final ResolverConfiguration config;
    public final String nature;
    public final String purpose;
    private String uri = null;
    private String baseURI = null;
    private String entityName = null;
    private String publicId = null;
    private String encoding = null;
    private boolean openStream = true;
    private boolean resolveAsEntity = false;

    public ResourceRequest(ResolverConfiguration config) {
        this(config, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
    }

    public ResourceRequest(ResolverConfiguration config, String nature, String purpose) {
        this.config = config;
        this.nature = nature;
        this.purpose = purpose;
        this.resolveAsEntity = "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity".equals(nature) || "https://www.iana.org/assignments/media-types/application/xml-dtd".equals(nature);
    }

    public void setURI(String uri) {
        if (uri != null) {
            this.uri = URIUtils.isWindows() && this.config.getFeature(ResolverFeature.FIX_WINDOWS_SYSTEM_IDENTIFIERS) != false ? URIUtils.windowsPathURI(uri) : uri;
        }
    }

    public void setURI(URI uri) {
        this.uri = uri.toString();
    }

    public void setBaseURI(String baseURI) {
        if (baseURI != null) {
            this.baseURI = URIUtils.isWindows() && this.config.getFeature(ResolverFeature.FIX_WINDOWS_SYSTEM_IDENTIFIERS) != false ? URIUtils.windowsPathURI(baseURI) : baseURI;
        }
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI.toString();
    }

    public void setEntityName(String name) {
        this.entityName = name;
        this.resolveAsEntity = true;
    }

    public String getURI() {
        return this.uri;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public URI getAbsoluteURI() throws URISyntaxException {
        URI abs;
        if (this.baseURI != null && (abs = new URI(this.baseURI)).isAbsolute()) {
            if (this.uri == null || this.uri.isEmpty()) {
                return abs;
            }
            return URIUtils.resolve(abs, this.uri);
        }
        if (this.uri != null && (abs = new URI(this.uri)).isAbsolute()) {
            return abs;
        }
        return null;
    }

    public String getSystemId() {
        return this.uri;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
        this.resolveAsEntity = true;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isResolvingAsEntity() {
        return this.resolveAsEntity;
    }

    public void setResolvingAsEntity(boolean asEntity) {
        this.resolveAsEntity = asEntity;
    }

    public void setOpenStream(boolean open) {
        this.openStream = open;
    }

    public boolean openStream() {
        return this.openStream;
    }

    public String toString() {
        String str = this.entityName == null ? "" : this.entityName + ": ";
        str = str + this.uri;
        if (this.baseURI != null) {
            str = str + " (" + this.baseURI + ")";
        }
        return str;
    }
}

