/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.logging.ResolverLogger;

public class ResourceConnection {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Pattern CHARSET = Pattern.compile(";\\s*charset\\s*=\\s*([^;]+)");
    private InputStream stream;
    private URI uri;
    private URI redirect;
    private int statusCode;
    private String contentType;
    private String encoding;
    private String etag;
    private Long lastModified;
    private Long date;
    private Map<String, List<String>> headers;
    private CloseableHttpClient httpclient;
    private boolean connected;

    public ResourceConnection(ResolverConfiguration config, URI uri, boolean headOnly) {
        block13: {
            this.stream = null;
            this.uri = null;
            this.redirect = null;
            this.statusCode = -1;
            this.contentType = null;
            this.encoding = null;
            this.etag = null;
            this.lastModified = -1L;
            this.date = -1L;
            this.headers = new HashMap<String, List<String>>();
            this.httpclient = null;
            this.connected = false;
            try {
                URL url = uri.toURL();
                if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                    Header[] httpHeaders;
                    this.httpclient = HttpClients.createDefault();
                    HttpClientContext context = HttpClientContext.create();
                    Object httpreq = null;
                    httpreq = headOnly ? new HttpHead(uri) : new HttpGet(uri);
                    CloseableHttpResponse httpResponse = this.httpclient.execute((ClassicHttpRequest)httpreq, (HttpContext)context);
                    HttpHost target = context.getHttpRoute().getTargetHost();
                    RedirectLocations redirectLocations = context.getRedirectLocations();
                    URI location = URIUtils.resolve((URI)httpreq.getUri(), (HttpHost)target, (List)redirectLocations.getAll());
                    this.redirect = uri.equals(location) ? null : location;
                    this.connected = true;
                    this.statusCode = httpResponse.getCode();
                    this.contentType = this.getHeader((HttpResponse)httpResponse, "Content-Type", "application/octet-stream");
                    this.encoding = this.getEncoding(this.contentType);
                    this.etag = this.getHeader((HttpResponse)httpResponse, "Etag", null);
                    if (!headOnly) {
                        this.stream = httpResponse.getEntity().getContent();
                    }
                    if ((httpHeaders = httpResponse.getHeaders()) == null) break block13;
                    for (Header header : httpHeaders) {
                        Date d2;
                        String name = header.getName().toLowerCase();
                        if (!this.headers.containsKey(name)) {
                            this.headers.put(name, new ArrayList());
                        }
                        this.headers.get(name).add(header.getValue());
                        if ("last-modified".equals(name) && this.lastModified <= 0L) {
                            try {
                                d2 = DATE_FORMAT.parse(header.getValue());
                                this.lastModified = d2.getTime();
                            }
                            catch (ParseException d2) {
                                // empty catch block
                            }
                        }
                        if (!"date".equals(name) || this.date > 0L) continue;
                        try {
                            d2 = DATE_FORMAT.parse(header.getValue());
                            this.date = d2.getTime();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    break block13;
                }
                URLConnection connection = url.openConnection();
                connection.connect();
                if (headOnly) {
                    connection.getInputStream().close();
                } else {
                    this.stream = connection.getInputStream();
                }
                this.connected = true;
                this.contentType = connection.getHeaderField("Content-Type");
                this.encoding = this.getEncoding(this.contentType);
                this.etag = connection.getHeaderField("Etag");
                this.lastModified = connection.getLastModified();
                this.date = connection.getDate();
                this.statusCode = connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : 200;
            }
            catch (IOException | IllegalArgumentException | URISyntaxException use) {
                ResolverLogger logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
                logger.log("warning", "Failed to %s: %s: %s", headOnly ? "HEAD" : "GET", uri, use.getMessage());
            }
        }
    }

    public InputStream getStream() {
        return this.stream;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEtag() {
        return this.etag;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getRedirect() {
        return this.redirect;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getDate() {
        return this.date;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() {
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getHeader(HttpResponse resp, String name, String def) {
        Header[] headers = resp.getHeaders(name);
        if (headers == null) {
            return def;
        }
        if (headers.length == 0) {
            return def;
        }
        return headers[0].getValue();
    }

    private String getEncoding(String contentType) {
        Matcher match;
        int pos;
        if (contentType != null && (pos = contentType.indexOf(";")) >= 0 && (match = CHARSET.matcher(contentType = contentType.substring(pos))).find()) {
            return match.group(1);
        }
        return null;
    }
}

