/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommonsArrayList<ELEMENTTYPE>
extends ArrayList<ELEMENTTYPE>
implements ICommonsList<ELEMENTTYPE> {
    public CommonsArrayList() {
    }

    public CommonsArrayList(@Nonnegative int n) {
        super(n);
    }

    public CommonsArrayList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        super(CollectionHelper.getSize(collection));
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public CommonsArrayList(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        this.addAll(iterable);
    }

    public CommonsArrayList(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        this.addAll(enumeration);
    }

    public <SRCTYPE> CommonsArrayList(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(CollectionHelper.getSize(collection));
        this.addAllMapped(collection, function);
    }

    public <SRCTYPE> CommonsArrayList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.addAllMapped(iterable, function);
    }

    public CommonsArrayList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        super(1);
        this.add(ELEMENTTYPE);
    }

    @SafeVarargs
    public CommonsArrayList(ELEMENTTYPE ... ELEMENTTYPEArray) {
        super(ArrayHelper.getSize(ELEMENTTYPEArray));
        this.addAll(ELEMENTTYPEArray);
    }

    public <SRCTYPE> CommonsArrayList(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(ArrayHelper.getSize(SRCTYPEArray));
        this.addAllMapped(SRCTYPEArray, function);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <T> CommonsArrayList<T> createInstance() {
        return new CommonsArrayList<ELEMENTTYPE>();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CommonsArrayList<ELEMENTTYPE> getClone() {
        return new CommonsArrayList<CommonsArrayList>(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsArrayList<? super ELEMENTTYPE> commonsArrayList = new CommonsArrayList<ELEMENTTYPE>();
        commonsArrayList.addAll(iterable, predicate);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(CollectionHelper.getSize(iterable));
        commonsArrayList.addAllMapped(iterable, predicate, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createFiltered(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(CollectionHelper.getSize(iterable));
        commonsArrayList.addAllMapped(iterable, function, predicate);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createFiltered(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(ArrayHelper.getSize(ELEMENTTYPEArray));
        commonsArrayList.addAll(ELEMENTTYPEArray, predicate);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createFiltered(@Nullable SRCTYPE[] SRCTYPEArray, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(ArrayHelper.getSize(SRCTYPEArray));
        commonsArrayList.addAllMapped(SRCTYPEArray, predicate, function);
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, ELEMENTTYPE> CommonsArrayList<ELEMENTTYPE> createFiltered(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(ArrayHelper.getSize(SRCTYPEArray));
        commonsArrayList.addAllMapped(SRCTYPEArray, function, predicate);
        return commonsArrayList;
    }
}

