/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsNavigableMap;
import com.helger.commons.collection.impl.ICommonsSortedSet;
import com.helger.commons.compare.IComparator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.xpath.IPSXPathVariables;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.xpath.XPathExpression;

@NotThreadSafe
public class PSXPathVariables
implements IPSXPathVariables {
    private final ICommonsNavigableMap<String, XPathExpression> m_aMap;

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsNavigableMap<String, XPathExpression> _createMap() {
        return new CommonsTreeMap((Comparator)IComparator.getComparatorStringLongestFirst());
    }

    public PSXPathVariables() {
        this.m_aMap = PSXPathVariables._createMap();
    }

    public PSXPathVariables(@Nonnull IPSXPathVariables iPSXPathVariables) {
        this.m_aMap = iPSXPathVariables.getAll();
    }

    @Nonnull
    public EChange add(@Nonnull Map.Entry<String, XPathExpression> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public EChange add(@Nonnull @Nonempty String string, @Nonnull @Nonempty XPathExpression xPathExpression) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"Value");
        if (this.m_aMap.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)string, (Object)xPathExpression);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange remove(@Nullable String string) {
        if (StringHelper.hasText((String)string) && this.m_aMap.remove((Object)("$" + string)) == null) {
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public EChange removeAll(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or((IChangeIndicator)this.remove(string));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsNavigableMap<String, XPathExpression> getAll() {
        return this.m_aMap.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSortedSet<String> getAllNames() {
        return this.m_aMap.copyOfKeySet();
    }

    @Override
    public boolean contains(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return this.m_aMap.containsKey((Object)string);
    }

    @Override
    @Nullable
    public XPathExpression get(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (XPathExpression)this.m_aMap.get((Object)string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PSXPathVariables getClone() {
        return new PSXPathVariables(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }
}

