/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceConnection;
import org.xmlresolver.cache.CacheEntry;
import org.xmlresolver.cache.CacheEntryCatalog;
import org.xmlresolver.cache.CacheInfo;
import org.xmlresolver.cache.CacheParser;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryResource;
import org.xmlresolver.catalog.entry.EntryUri;
import org.xmlresolver.utils.PublicId;
import org.xmlresolver.utils.URIUtils;

public class ResourceCache
extends CatalogManager {
    public static final long deleteWait = 604800L;
    public static final long cacheSize = 1000L;
    public static final long cacheSpace = 10240000L;
    public static final long maxAge = -1L;
    public static final String defaultPattern = ".*";
    public static final String[] excludedPatterns = new String[]{"^file:", "^jar:file:", "^classpath:", "^path:"};
    private boolean loaded = false;
    private File cacheDir = null;
    private File dataDir = null;
    private File entryDir = null;
    private File expiredDir = null;
    private final CacheParser cacheParser;
    private final ArrayList<CacheInfo> cacheInfo = new ArrayList();
    private CacheEntryCatalog catalog = null;
    private CacheInfo defaultCacheInfo = null;
    private String cacheVersion = null;

    public ResourceCache(ResolverConfiguration config) {
        super(config);
        if (!config.getFeature(ResolverFeature.CACHE_ENABLED).booleanValue()) {
            this.cacheDir = null;
            this.cacheParser = null;
            this.defaultCacheInfo = new CacheInfo(defaultPattern, false, 604800L, 1000L, 10240000L, -1L);
            return;
        }
        this.cacheParser = new CacheParser(config);
        this.defaultCacheInfo = new CacheInfo(defaultPattern, true, 604800L, 1000L, 10240000L, -1L);
        String dir = config.getFeature(ResolverFeature.CACHE_DIRECTORY);
        if (dir == null && config.getFeature(ResolverFeature.CACHE_UNDER_HOME).booleanValue() && (dir = System.getProperty("user.home")) != null) {
            dir = dir.endsWith("/") ? dir + ".xmlresolver.org/cache" : dir + "/.xmlresolver.org/cache";
        }
        if (dir == null) {
            return;
        }
        File fDir = new File(dir);
        try {
            this.cacheDir = fDir.getCanonicalFile();
            this.logger.log("cache", "Cache dir: %s", this.cacheDir);
            if (!this.cacheDir.exists()) {
                this.cacheDir.mkdirs();
            }
            if (!this.cacheDir.exists()) {
                this.logger.log("error", "Cannot create cache directory: %s", this.cacheDir);
                this.cacheDir = null;
            }
        }
        catch (IOException ioe) {
            this.logger.log("error", "IOException getting cache directory: %s", dir);
            this.cacheDir = null;
        }
        if (this.cacheDir == null) {
            return;
        }
        boolean update = false;
        boolean parsed = false;
        File control = new File(this.cacheDir, "control.xml");
        if (control.exists()) {
            try {
                XMLReader reader = config.getFeature(ResolverFeature.XMLREADER_SUPPLIER).get();
                reader.setContentHandler(new CacheHandler(604800L, 1000L, 10240000L, -1L));
                InputSource source = new InputSource(control.getAbsolutePath());
                reader.parse(source);
                parsed = true;
                for (String pattern : excludedPatterns) {
                    CacheInfo info = this.getCacheInfo(pattern);
                    if (info != null) continue;
                    update = true;
                    this.cacheInfo.add(new CacheInfo(pattern, false));
                }
            }
            catch (IOException | SAXException ex) {
                this.logger.log("error", "Failed to parse cache control file: %s", ex.getMessage());
            }
        } else {
            update = true;
        }
        if (!parsed) {
            for (String pattern : excludedPatterns) {
                this.cacheInfo.add(new CacheInfo(pattern, false));
            }
        }
        if (update) {
            this.updateCacheControlFile();
        }
    }

    private void updateCacheControlFile() {
        if (this.cacheDir == null) {
            return;
        }
        File control = new File(this.cacheDir, "control.xml");
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(control));
            ps.println("<cache-control version='2' xmlns='http://xmlresolver.org/ns/catalog'>");
            for (CacheInfo info : this.cacheInfo) {
                if (info.cache) {
                    ps.print("<cache ");
                } else {
                    ps.print("<no-cache ");
                }
                ps.print("uri='" + CacheEntryCatalog.xmlEscape(info.pattern) + "'");
                ps.print(" delete-wait='" + info.deleteWait + "'");
                ps.print(" size='" + info.cacheSize + "'");
                ps.print(" space='" + info.cacheSpace + "'");
                ps.println(" max-age='" + info.maxAge + "'/>");
            }
            ps.println("</cache-control>\n");
            ps.close();
        }
        catch (IOException | SecurityException ex) {
            this.logger.log("cache", "Failed to write cache control file: %s: %s", control.getAbsolutePath(), ex.getMessage());
        }
    }

    public String directory() {
        return this.cacheDir == null ? null : this.cacheDir.getAbsolutePath();
    }

    public List<CacheInfo> getCacheInfoList() {
        return new ArrayList<CacheInfo>(this.cacheInfo);
    }

    public CacheInfo getCacheInfo(String pattern) {
        if (pattern == null) {
            return null;
        }
        for (CacheInfo info : this.cacheInfo) {
            if (!pattern.equals(info.pattern)) continue;
            return info;
        }
        return null;
    }

    public CacheInfo getDefaultCacheInfo() {
        return this.defaultCacheInfo;
    }

    public CacheInfo addCacheInfo(String pattern, boolean cache) {
        return this.addCacheInfo(pattern, cache, 604800L, 1000L, 10240000L, -1L);
    }

    public CacheInfo addCacheInfo(String pattern, boolean cache, long deleteWait, long cacheSize, long cacheSpace, long maxAge) {
        CacheInfo info = new CacheInfo(pattern, cache, deleteWait, cacheSize, cacheSpace, maxAge);
        this.removeCacheInfo(pattern, false);
        this.cacheInfo.add(info);
        this.updateCacheControlFile();
        return info;
    }

    public void removeCacheInfo(String pattern) {
        this.removeCacheInfo(pattern, true);
    }

    private void removeCacheInfo(String pattern, boolean writeUpdate) {
        CacheInfo info = this.getCacheInfo(pattern);
        while (info != null) {
            this.cacheInfo.remove(info);
            info = this.getCacheInfo(pattern);
        }
        if (writeUpdate) {
            this.updateCacheControlFile();
        }
    }

    public List<CacheEntry> entries() {
        this.loadCache();
        return new ArrayList<CacheEntry>(this.catalog.cached);
    }

    public boolean expired(URI local) {
        boolean etagsDiffer;
        if (local == null) {
            return false;
        }
        String offline = System.getProperty("xmlresolver.offline");
        if (!(offline == null || "false".equals(offline) || "0".equals(offline) || "no".equals(offline))) {
            return false;
        }
        this.loadCache();
        if (this.cacheDir == null) {
            return true;
        }
        CacheEntry entry = null;
        for (CacheEntry search : this.catalog.cached) {
            if (!local.equals(search.file.toURI())) continue;
            entry = search;
            break;
        }
        if (entry == null) {
            return true;
        }
        CacheInfo info = null;
        for (int count = 0; info == null && count < this.cacheInfo.size(); ++count) {
            CacheInfo chk = this.cacheInfo.get(count);
            if (!chk.uriPattern.matcher(entry.uri.toString()).find()) continue;
            info = chk;
        }
        if (info == null) {
            info = this.defaultCacheInfo;
        }
        if (!info.cache) {
            CacheInfo cleanup = new CacheInfo(info.pattern, false, 604800L, 0L, 0L, 0L);
            this.flushCache(cleanup);
            return true;
        }
        int cacheCount = 0;
        long cacheSize = 0L;
        for (CacheEntry search : this.catalog.cached) {
            if (search.entry.getType() == Entry.Type.PUBLIC || search.expired || !info.uriPattern.matcher(search.uri.toString()).find()) continue;
            ++cacheCount;
            cacheSize += search.file.length();
        }
        if ((long)cacheCount > info.cacheSize || cacheSize > info.cacheSpace) {
            this.logger.log("cache", "Too many cache entries, or cache size too large: expiring oldest entries", new Object[0]);
            this.flushCache(info);
        }
        if (entry.expired) {
            return true;
        }
        long cacheTime = entry.time;
        String cachedEtag = entry.etag();
        ResourceConnection rconn = new ResourceConnection(this.resolverConfiguration, entry.uri.toASCIIString(), true);
        rconn.close();
        String etag = rconn.getEtag();
        long lastModified = rconn.getLastModified();
        if ("".equals(etag)) {
            etag = null;
        }
        if (lastModified < 0L && (etag == null || cachedEtag == null)) {
            long maxAge = info.maxAge;
            if (maxAge >= 0L) {
                long oldest = new Date().getTime() - maxAge * 1000L;
                if (maxAge == 0L || cacheTime < oldest) {
                    return true;
                }
            }
            lastModified = rconn.getDate();
        }
        if (rconn.getStatusCode() != 200) {
            this.logger.log("cache", "Not expired: %s (HTTP %d)", entry.uri, rconn.getStatusCode());
            return false;
        }
        boolean bl = etagsDiffer = etag != null && cachedEtag != null && !etag.equals(cachedEtag);
        if (lastModified < 0L) {
            if (etagsDiffer) {
                this.logger.log("cache", "Expired: %s (no last-modified header, etags differ)", entry.uri);
                return true;
            }
            this.logger.log("cache", "Not expired: %s (no last-modified header, etags identical)", entry.uri);
            return false;
        }
        if (lastModified > cacheTime || etagsDiffer) {
            this.logger.log("cache", "Expired: %s", entry.uri);
            this.catalog.expire(entry);
            return true;
        }
        this.logger.log("cache", "Not expired: %s", entry.uri);
        return false;
    }

    public boolean cacheURI(String uri) {
        this.loadCache();
        if (this.cacheDir == null) {
            return false;
        }
        uri = URIUtils.cwd().resolve(uri).toString();
        CacheInfo info = null;
        for (int count = 0; info == null && count < this.cacheInfo.size(); ++count) {
            CacheInfo chk = this.cacheInfo.get(count);
            if (!chk.uriPattern.matcher(uri).find()) continue;
            info = chk;
        }
        if (info == null) {
            info = this.defaultCacheInfo;
        }
        this.logger.log("cache", "Cache cacheURI: %s (%s)", info.cache, uri);
        return info.cache;
    }

    @Override
    public URI lookupURI(String uri) {
        this.loadCache();
        if (this.cacheDir == null) {
            return null;
        }
        URI local = super.lookupURI(uri);
        return this.expired(local) ? null : local;
    }

    @Override
    public URI lookupNamespaceURI(String uri, String nature, String purpose) {
        this.loadCache();
        if (this.cacheDir == null) {
            return null;
        }
        URI local = super.lookupNamespaceURI(uri, nature, purpose);
        return this.expired(local) ? null : local;
    }

    @Override
    public URI lookupPublic(String systemId, String publicId) {
        this.loadCache();
        if (this.cacheDir == null) {
            return null;
        }
        URI local = super.lookupPublic(systemId, publicId);
        return this.expired(local) ? null : local;
    }

    @Override
    public URI lookupSystem(String systemId) {
        this.loadCache();
        if (this.cacheDir == null) {
            return null;
        }
        URI local = super.lookupSystem(systemId);
        return this.expired(local) ? null : local;
    }

    public CacheEntry cachedUri(URI uri) {
        return this.cachedNamespaceUri(uri, null, null);
    }

    public CacheEntry cachedNamespaceUri(URI uri, String nature, String purpose) {
        CacheEntry entry = this.findNamespaceCacheEntry(uri, nature, purpose);
        if ((entry == null || entry.expired) && this.cacheURI(uri.toString())) {
            try {
                ResourceConnection conn = new ResourceConnection(this.resolverConfiguration, uri.toString());
                if (conn.getStream() != null && conn.getStatusCode() == 200) {
                    entry = this.addNamespaceURI(conn, nature, purpose);
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                this.logger.log("error", "Apache HTTP library classes apparently unavailable, not attempting to cache", new Object[0]);
                return null;
            }
        }
        return entry;
    }

    public CacheEntry cachedSystem(URI systemId, String publicId) {
        CacheEntry entry = this.findSystemCacheEntry(systemId);
        if ((entry == null || entry.expired) && this.cacheURI(systemId.toString())) {
            try {
                ResourceConnection conn = new ResourceConnection(this.resolverConfiguration, systemId.toString());
                if (conn.getStatusCode() == 200 && conn.getStream() != null) {
                    entry = this.addSystem(conn, publicId);
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                this.logger.log("error", "Apache HTTP library classes apparently unavailable, not attempting to cache", new Object[0]);
                return null;
            }
        }
        return entry;
    }

    private synchronized void loadCache() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (this.cacheDir == null) {
            return;
        }
        this.catalog = new CacheEntryCatalog(this.resolverConfiguration, this.cacheDir.toURI(), null, true);
        this.dataDir = new File(this.cacheDir, "data");
        this.entryDir = new File(this.cacheDir, "entry");
        this.expiredDir = new File(this.cacheDir, "expired");
        if (!this.dataDir.exists() && !this.dataDir.mkdir() || !this.entryDir.exists() && !this.entryDir.mkdir() || !this.expiredDir.exists() && !this.expiredDir.mkdir()) {
            this.logger.log("cache", "Failed to setup data, entry, and expired directories in cache", new Object[0]);
            this.cacheDir = null;
            return;
        }
        DirectoryLock lock = new DirectoryLock();
        try {
            lock.lock();
        }
        catch (IOException ex) {
            this.logger.log("cache", "Failed to obtain lock on cache: " + ex.getMessage(), new Object[0]);
            return;
        }
        this.cleanupCache();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        spf.setXIncludeAware(false);
        EntryHandler handler = new EntryHandler(this.entryDir.toURI());
        File[] files = this.entryDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.canRead()) continue;
                try {
                    SAXParser parser = spf.newSAXParser();
                    InputSource source = new InputSource(file.toURI().toASCIIString());
                    handler.setBaseURI(file.toURI());
                    parser.parse(source, (DefaultHandler)handler);
                }
                catch (IOException | ParserConfigurationException | SAXException ex) {
                    this.logger.log("cache", "Failed to read cache entry: " + file.toURI() + ": " + ex.getMessage(), new Object[0]);
                }
            }
        }
        lock.unlock();
    }

    private void cleanupCache() {
        long now = new Date().getTime();
        long threshold = 86400000L;
        long age = 0L;
        File cleanup = new File(this.cacheDir, "cleanup");
        if (cleanup.exists()) {
            age = now - cleanup.lastModified();
        } else {
            try {
                OutputStreamWriter fos = new OutputStreamWriter(new FileOutputStream(cleanup));
                fos.write("The timestamp on this file indicates when the cache was last pruned.\n");
                fos.close();
            }
            catch (IOException | SecurityException cex) {
                this.logger.log("cache", "Failed to create cache cleanup file" + cleanup.getAbsolutePath(), new Object[0]);
                return;
            }
            age = threshold + 1L;
        }
        if (age > threshold) {
            String entryName;
            this.logger.log("cache", "Cleaning up expired cache entries", new Object[0]);
            File[] files = this.expiredDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    age = now - file.lastModified();
                    if (age <= 604800000L) continue;
                    this.logger.log("cache", "Deleting expired entry: %s", file.getName());
                    if (file.delete()) continue;
                    this.logger.log("cache", "Failed to delete expired cache entry: " + file.getAbsolutePath(), new Object[0]);
                }
            }
            if ((files = this.dataDir.listFiles()) != null) {
                for (File file : files) {
                    entryName = file.getName();
                    File entry = new File(this.entryDir, (entryName = entryName.substring(0, entryName.lastIndexOf("."))) + ".xml");
                    if (entry.exists() || (entry = new File(this.expiredDir, entryName + ".xml")).exists()) continue;
                    this.logger.log("cache", "Deleting expired data: %s", file.getName());
                    if (file.delete()) continue;
                    this.logger.log("cache", "Failed to delete expired cache entry: " + file.getAbsolutePath(), new Object[0]);
                }
            }
            if ((files = this.entryDir.listFiles()) != null) {
                for (File file : files) {
                    entryName = file.getName();
                    entryName = entryName.substring(0, entryName.lastIndexOf("."));
                    boolean found = false;
                    File[] dfiles = this.dataDir.listFiles();
                    if (dfiles != null) {
                        for (int dpos = 0; !found && dpos < dfiles.length; ++dpos) {
                            String dataName = dfiles[dpos].getName();
                            dataName = dataName.substring(0, dataName.lastIndexOf("."));
                            found = dataName.equals(entryName);
                        }
                    }
                    if (found) continue;
                    this.logger.log("cache", "Deleting dangling entry: %s", file.getName());
                    if (file.delete()) continue;
                    this.logger.log("cache", "Failed to delete expired cache entry: " + file.getAbsolutePath(), new Object[0]);
                }
            }
            if (!cleanup.setLastModified(now)) {
                this.logger.log("cache", "Failed to update last modified time of cache cleanup file", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry addNamespaceURI(ResourceConnection connection, String nature, String purpose) {
        this.loadCache();
        if (this.cacheDir == null) {
            this.logger.log("cache", "Attempting to cache URI, but no cache is available", new Object[0]);
            return null;
        }
        DirectoryLock lock = new DirectoryLock();
        try {
            lock.lock();
        }
        catch (IOException ex) {
            return null;
        }
        URI name = connection.getUri();
        if (nature == null && purpose == null) {
            this.logger.log("cache", "Caching resource for uri: %s", name);
        } else {
            this.logger.log("cache", "Caching resource for namespace: %s (nature: %s, purpose: %s)", name, nature, purpose);
        }
        String contentType = connection.getContentType();
        InputStream resource = connection.getStream();
        File localFile = null;
        try {
            String basefn = this.cacheBaseName(name);
            File entryFile = new File(this.entryDir, basefn + ".xml");
            localFile = new File(this.dataDir, basefn + this.pickSuffix(name, contentType));
            this.storeStream(resource, localFile);
            resource.close();
            String uri = localFile.getAbsolutePath();
            long now = new Date().getTime();
            EntryUri entry = this.catalog.addUri(entryFile.toURI(), name.toString(), uri, nature, purpose, now);
            entry.setProperty("contentType", contentType);
            entry.setProperty("time", "" + now);
            String prop = null;
            if (connection.getRedirect() != null) {
                prop = connection.getRedirect().toString();
            }
            if (prop != null) {
                entry.setProperty("redir", prop);
            }
            if ((prop = connection.getEtag()) != null) {
                entry.setProperty("etag", prop);
            }
            entry.setProperty("filesize", "" + localFile.length());
            entry.setProperty("filemodified", "" + localFile.lastModified());
            this.catalog.writeCacheEntry(entry, entryFile);
        }
        catch (NoSuchAlgorithmException nsae) {
            this.logger.log("cache", "Failed to obtain SHA-256 digest?", new Object[0]);
        }
        catch (IOException ioe) {
            this.logger.log("error", "Failed to cache resource '%s' to '%s'", name, localFile.getAbsolutePath());
        }
        finally {
            lock.unlock();
        }
        return this.findNamespaceCacheEntry(name, nature, purpose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CacheEntry addSystem(ResourceConnection connection, String publicId) {
        this.loadCache();
        if (this.cacheDir == null) {
            this.logger.log("cache", "Attempting to cache system ID, but no cache is available", new Object[0]);
            return null;
        }
        DirectoryLock lock = new DirectoryLock();
        try {
            lock.lock();
        }
        catch (IOException ex) {
            this.logger.log("error", "Failed to obtain directory lock to cache resource: %s", connection.getUri());
            return null;
        }
        URI name = connection.getUri();
        String contentType = connection.getContentType();
        InputStream resource = connection.getStream();
        this.logger.log("cache", "Caching systemId: %s", name);
        File localFile = null;
        try {
            String basefn = this.cacheBaseName(name);
            File entryFile = new File(this.entryDir, basefn + ".xml");
            localFile = new File(this.dataDir, basefn + this.pickSuffix(name, contentType));
            this.storeStream(resource, localFile);
            resource.close();
            String uri = localFile.getAbsolutePath();
            long now = new Date().getTime();
            EntryResource entry = this.catalog.addSystem(entryFile.toURI(), name.toString(), uri, now);
            entry.setProperty("contentType", contentType);
            entry.setProperty("time", "" + now);
            String prop = null;
            if (connection.getRedirect() != null) {
                prop = connection.getRedirect().toString();
            }
            if (prop != null) {
                entry.setProperty("redir", prop);
            }
            if ((prop = connection.getEtag()) != null) {
                entry.setProperty("etag", prop);
            }
            entry.setProperty("filesize", "" + localFile.length());
            entry.setProperty("filemodified", "" + localFile.lastModified());
            this.catalog.writeCacheEntry(entry, entryFile);
            if (publicId != null) {
                basefn = this.cacheBaseName(PublicId.encodeURN(publicId));
                entryFile = new File(this.entryDir, basefn + ".xml");
                entry = this.catalog.addPublic(entryFile.toURI(), publicId, uri, now);
                entry.setProperty("contentType", contentType);
                entry.setProperty("time", "" + now);
                prop = null;
                if (connection.getRedirect() != null) {
                    prop = connection.getRedirect().toString();
                }
                if (prop != null) {
                    entry.setProperty("redir", prop);
                }
                if ((prop = connection.getEtag()) != null) {
                    entry.setProperty("etag", prop);
                }
                entry.setProperty("filesize", "" + localFile.length());
                entry.setProperty("filemodified", "" + localFile.lastModified());
                this.catalog.writeCacheEntry(entry, entryFile);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            this.logger.log("cache", "Failed to obtain SHA-256 digest?", new Object[0]);
        }
        catch (IOException ioe) {
            this.logger.log("error", "Failed to cache resource '%s' to '%s'", name, localFile.getAbsolutePath());
        }
        finally {
            lock.unlock();
        }
        return this.findSystemCacheEntry(name);
    }

    private CacheEntry findNamespaceCacheEntry(URI uri, String nature, String purpose) {
        if (uri == null) {
            return null;
        }
        this.loadCache();
        if (this.cacheDir == null) {
            return null;
        }
        for (CacheEntry search : this.catalog.cached) {
            if (search.entry.getType() != Entry.Type.URI || !uri.equals(search.uri)) continue;
            EntryUri entry = (EntryUri)search.entry;
            if (nature != null && entry.nature != null && !nature.equals(entry.nature) || purpose != null && entry.purpose != null && !purpose.equals(entry.purpose)) continue;
            return search;
        }
        return null;
    }

    private CacheEntry findSystemCacheEntry(URI systemId) {
        if (systemId == null) {
            return null;
        }
        this.loadCache();
        if (this.cacheDir == null) {
            return null;
        }
        for (CacheEntry search : this.catalog.cached) {
            if (search.entry.getType() != Entry.Type.SYSTEM || !systemId.equals(search.uri)) continue;
            return search;
        }
        return null;
    }

    private void flushCache(CacheInfo info) {
        DirectoryLock lock = new DirectoryLock();
        try {
            lock.lock();
            this.catalog.flushCache(info.uriPattern, info.cacheSize, info.cacheSpace, this.expiredDir);
            lock.unlock();
        }
        catch (IOException ex) {
            this.logger.log("error", "Failed to obtain lock to expire cache", new Object[0]);
        }
    }

    private String cacheBaseName(URI name) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashbytes = digest.digest(name.toASCIIString().getBytes(StandardCharsets.UTF_8));
        StringBuilder hexbuilder = new StringBuilder(hashbytes.length * 2);
        for (byte b : hashbytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() < 2) {
                hexbuilder.append("0");
            }
            hexbuilder.append(hex);
        }
        return hexbuilder.toString();
    }

    private void storeStream(InputStream resource, File localFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(localFile);
        byte[] buf = new byte[8192];
        int read = resource.read(buf);
        while (read > 0) {
            fos.write(buf, 0, read);
            read = resource.read(buf);
        }
        fos.close();
    }

    private String pickSuffix(URI uri, String contentType) {
        String suffix = uri.toASCIIString();
        int pos = suffix.lastIndexOf(".");
        if (pos > 0 && (suffix = suffix.substring(pos)).length() <= 5) {
            return suffix;
        }
        if (contentType == null) {
            return ".bin";
        }
        if ("application/xml-dtd".equals(contentType)) {
            return ".dtd";
        }
        if (contentType.contains("application/xml")) {
            return ".xml";
        }
        if (contentType.contains("text/html") || contentType.contains("application/html+xml")) {
            return ".html";
        }
        if (contentType.contains("text/plain")) {
            if (uri.toString().endsWith(".dtd")) {
                return ".dtd";
            }
            return ".txt";
        }
        return ".bin";
    }

    private class EntryHandler
    extends DefaultHandler {
        private boolean root = false;
        private URI baseURI = null;

        public EntryHandler(URI baseURI) {
            this.baseURI = baseURI;
        }

        public void setBaseURI(URI baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public void startDocument() {
            this.root = true;
        }

        @Override
        public void startElement(String nsuri, String localName, String qName, Attributes attributes) {
            if (!"urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(nsuri)) {
                this.root = false;
                return;
            }
            if ("catalog".equals(localName)) {
                return;
            }
            if (this.root) {
                URI localURI;
                this.root = false;
                String name = attributes.getValue("", "name");
                String uri = attributes.getValue("", "uri");
                long timestamp = -1L;
                String longStr = attributes.getValue("http://xmlresolver.org/ns/catalog", "time");
                if (longStr != null) {
                    try {
                        timestamp = Long.parseLong(longStr);
                    }
                    catch (NumberFormatException ex) {
                        ResourceCache.this.logger.log("error", "Bad numeric value in cache file: %s", longStr);
                        return;
                    }
                }
                try {
                    localURI = URIUtils.newURI(uri);
                }
                catch (URISyntaxException ex) {
                    ResourceCache.this.logger.log("error", "Cached URI is invalid: %s", uri);
                    return;
                }
                File local = new File(localURI.getPath());
                if (!local.exists()) {
                    ResourceCache.this.logger.log("cache", "Cached resource disappeared: %s", uri);
                    return;
                }
                EntryResource entry = null;
                switch (localName) {
                    case "uri": {
                        String nature = attributes.getValue("", "nature");
                        String purpose = attributes.getValue("", "purpose");
                        entry = ResourceCache.this.catalog.addUri(this.baseURI, name, uri, nature, purpose, timestamp);
                        break;
                    }
                    case "system": {
                        String systemId = attributes.getValue("", "systemId");
                        entry = ResourceCache.this.catalog.addSystem(this.baseURI, systemId, uri, timestamp);
                        break;
                    }
                    case "public": {
                        String publicId = attributes.getValue("", "publicId");
                        entry = ResourceCache.this.catalog.addPublic(this.baseURI, publicId, uri, timestamp);
                        break;
                    }
                    default: {
                        ResourceCache.this.logger.log("cache", "Unexpected cache entry: " + localName, new Object[0]);
                        return;
                    }
                }
                for (int pos = 0; pos < attributes.getLength(); ++pos) {
                    if (!"http://xmlresolver.org/ns/catalog".equals(attributes.getURI(pos))) continue;
                    entry.setProperty(attributes.getLocalName(pos), attributes.getValue(pos));
                }
                entry.setProperty("filesize", "" + local.length());
                entry.setProperty("filemodified", "" + local.lastModified());
            }
        }
    }

    private class CacheHandler
    extends DefaultHandler {
        private final long default_deleteWait;
        private final long default_cacheSize;
        private final long default_cacheSpace;
        private final long default_maxAge;
        private boolean isControl = false;
        private int depth = 0;

        public CacheHandler(long deleteWait, long cacheSize, long cacheSpace, long maxAge) {
            this.default_deleteWait = deleteWait;
            this.default_cacheSize = cacheSize;
            this.default_cacheSpace = cacheSpace;
            this.default_maxAge = maxAge;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            long deleteWait = this.default_deleteWait;
            long cacheSize = this.default_cacheSize;
            long cacheSpace = this.default_cacheSpace;
            long maxAge = this.default_maxAge;
            if (this.depth == 0) {
                boolean bl = this.isControl = "http://xmlresolver.org/ns/catalog".equals(uri) && "cache-control".equals(localName);
                if (this.isControl) {
                    ResourceCache.this.cacheVersion = attributes.getValue("", "version");
                    deleteWait = ResourceCache.this.cacheParser.parseTimeLong(attributes.getValue("", "delete-wait"), this.default_deleteWait);
                    cacheSize = ResourceCache.this.cacheParser.parseLong(attributes.getValue("", "size"), this.default_cacheSize);
                    cacheSpace = ResourceCache.this.cacheParser.parseSizeLong(attributes.getValue("", "space"), this.default_cacheSpace);
                    maxAge = ResourceCache.this.cacheParser.parseTimeLong(attributes.getValue("", "max-age"), this.default_maxAge);
                    ResourceCache.this.defaultCacheInfo = new CacheInfo(ResourceCache.defaultPattern, true, deleteWait, cacheSize, cacheSpace, maxAge);
                }
            }
            if (this.isControl && this.depth == 1 && "http://xmlresolver.org/ns/catalog".equals(uri)) {
                deleteWait = ResourceCache.this.cacheParser.parseTimeLong(attributes.getValue("", "delete-wait"), this.default_deleteWait);
                cacheSize = ResourceCache.this.cacheParser.parseLong(attributes.getValue("", "size"), this.default_cacheSize);
                cacheSpace = ResourceCache.this.cacheParser.parseSizeLong(attributes.getValue("", "space"), this.default_cacheSpace);
                maxAge = ResourceCache.this.cacheParser.parseTimeLong(attributes.getValue("", "max-age"), this.default_maxAge);
                String cacheRegex = attributes.getValue("", "uri");
                switch (localName) {
                    case "cache": {
                        if (cacheRegex == null) break;
                        CacheInfo info = new CacheInfo(cacheRegex, true, deleteWait, cacheSize, cacheSpace, maxAge);
                        ResourceCache.this.cacheInfo.add(info);
                        break;
                    }
                    case "no-cache": {
                        if (cacheRegex == null) break;
                        CacheInfo info = new CacheInfo(cacheRegex, false, deleteWait, cacheSize, cacheSpace, maxAge);
                        ResourceCache.this.cacheInfo.add(info);
                        break;
                    }
                    default: {
                        ResourceCache.this.logger.log("error", "Unexpected element in cache control file: %s", localName);
                    }
                }
            }
            ++this.depth;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            --this.depth;
        }
    }

    private class DirectoryLock {
        private RandomAccessFile lockFile = null;
        private FileChannel lockChannel = null;
        private FileLock lock = null;

        DirectoryLock() {
            try {
                File lockF = new File(ResourceCache.this.cacheDir.toString() + "/lock");
                this.lockFile = new RandomAccessFile(lockF, "rw");
                this.lockChannel = this.lockFile.getChannel();
                this.lock = this.lockChannel.tryLock();
            }
            catch (IOException | OverlappingFileLockException exception) {
                // empty catch block
            }
        }

        boolean locked() {
            return this.lock != null;
        }

        void lock() throws IOException {
            while (this.lock == null) {
                try {
                    this.lock = this.lockChannel.lock();
                }
                catch (OverlappingFileLockException ex) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        void unlock() {
            try {
                this.lock.release();
                this.lockFile.close();
                this.lock = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

