/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.cache.ResourceCache;
import org.xmlresolver.logging.AbstractLogger;
import org.xmlresolver.logging.DefaultLogger;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.logging.SystemLogger;
import org.xmlresolver.utils.URIUtils;

public class XMLResolverConfiguration
implements ResolverConfiguration {
    private static final ResolverFeature<?>[] knownFeatures = new ResolverFeature[]{ResolverFeature.CATALOG_FILES, ResolverFeature.PREFER_PUBLIC, ResolverFeature.PREFER_PROPERTY_FILE, ResolverFeature.ALLOW_CATALOG_PI, ResolverFeature.CATALOG_ADDITIONS, ResolverFeature.CACHE_DIRECTORY, ResolverFeature.CACHE_UNDER_HOME, ResolverFeature.CACHE_ENABLED, ResolverFeature.CACHE, ResolverFeature.MERGE_HTTPS, ResolverFeature.MASK_JAR_URIS, ResolverFeature.CATALOG_MANAGER, ResolverFeature.URI_FOR_SYSTEM, ResolverFeature.CATALOG_LOADER_CLASS, ResolverFeature.PARSE_RDDL, ResolverFeature.CLASSPATH_CATALOGS, ResolverFeature.CLASSLOADER, ResolverFeature.ARCHIVED_CATALOGS, ResolverFeature.THROW_URI_EXCEPTIONS, ResolverFeature.RESOLVER_LOGGER_CLASS, ResolverFeature.RESOLVER_LOGGER, ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL, ResolverFeature.ACCESS_EXTERNAL_ENTITY, ResolverFeature.ACCESS_EXTERNAL_DOCUMENT, ResolverFeature.SAXPARSERFACTORY_CLASS, ResolverFeature.XMLREADER_SUPPLIER};
    private static List<String> classpathCatalogList = null;
    private final List<String> catalogs;
    private final List<String> additionalCatalogs;
    private Boolean preferPublic = ResolverFeature.PREFER_PUBLIC.getDefaultValue();
    private Boolean preferPropertyFile = ResolverFeature.PREFER_PROPERTY_FILE.getDefaultValue();
    private Boolean allowCatalogPI = ResolverFeature.ALLOW_CATALOG_PI.getDefaultValue();
    private String cacheDirectory = ResolverFeature.CACHE_DIRECTORY.getDefaultValue();
    private Boolean cacheUnderHome = ResolverFeature.CACHE_UNDER_HOME.getDefaultValue();
    private Boolean cacheEnabled = ResolverFeature.CACHE_ENABLED.getDefaultValue();
    private ResourceCache cache = ResolverFeature.CACHE.getDefaultValue();
    private CatalogManager manager = ResolverFeature.CATALOG_MANAGER.getDefaultValue();
    private Boolean uriForSystem = ResolverFeature.URI_FOR_SYSTEM.getDefaultValue();
    private Boolean mergeHttps = ResolverFeature.MERGE_HTTPS.getDefaultValue();
    private Boolean maskJarUris = ResolverFeature.MASK_JAR_URIS.getDefaultValue();
    private String catalogLoader = ResolverFeature.CATALOG_LOADER_CLASS.getDefaultValue();
    private Boolean parseRddl = ResolverFeature.PARSE_RDDL.getDefaultValue();
    private Boolean classpathCatalogs = ResolverFeature.CLASSPATH_CATALOGS.getDefaultValue();
    private ClassLoader classLoader = ResolverFeature.CLASSLOADER.getDefaultValue();
    private Boolean archivedCatalogs = ResolverFeature.ARCHIVED_CATALOGS.getDefaultValue();
    private Boolean throwUriExceptions = ResolverFeature.THROW_URI_EXCEPTIONS.getDefaultValue();
    private Boolean showConfigChanges = false;
    private String resolverLoggerClass = ResolverFeature.RESOLVER_LOGGER_CLASS.getDefaultValue();
    private String defaultLoggerLogLevel = ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL.getDefaultValue();
    private String accessExternalEntity = ResolverFeature.ACCESS_EXTERNAL_ENTITY.getDefaultValue();
    private String accessExternalDocument = ResolverFeature.ACCESS_EXTERNAL_DOCUMENT.getDefaultValue();
    private String saxParserFactoryClass = ResolverFeature.SAXPARSERFACTORY_CLASS.getDefaultValue();
    private Supplier<XMLReader> xmlReaderSupplier = ResolverFeature.XMLREADER_SUPPLIER.getDefaultValue();
    private ResolverLogger resolverLogger = null;

    public XMLResolverConfiguration() {
        this(null, null);
    }

    public XMLResolverConfiguration(String catalogFiles) {
        this(null, Arrays.asList(catalogFiles.split("\\s*;\\s*")));
    }

    public XMLResolverConfiguration(List<String> catalogFiles) {
        this(null, catalogFiles);
    }

    public XMLResolverConfiguration(List<URL> propertyFiles, List<String> catalogFiles) {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        this.showConfigChanges = false;
        this.catalogs = new ArrayList<String>();
        this.additionalCatalogs = new ArrayList<String>();
        FallbackLogger fallbackLogger = new FallbackLogger();
        this.resolverLogger = fallbackLogger;
        this.loadConfiguration(propertyFiles, catalogFiles);
        this.resolverLogger = null;
        this.resolverLogger = this.getFeature(ResolverFeature.RESOLVER_LOGGER);
        fallbackLogger.forward(this.resolverLogger);
        this.showConfigChanges = true;
    }

    public XMLResolverConfiguration(XMLResolverConfiguration current) {
        this.catalogs = new ArrayList<String>(current.catalogs);
        this.additionalCatalogs = new ArrayList<String>();
        this.classLoader = current.classLoader;
        this.preferPublic = current.preferPublic;
        this.preferPropertyFile = current.preferPropertyFile;
        this.allowCatalogPI = current.allowCatalogPI;
        this.cacheDirectory = current.cacheDirectory;
        this.cacheUnderHome = current.cacheUnderHome;
        this.cache = current.cache;
        this.cacheEnabled = current.cacheEnabled;
        this.manager = current.manager == null ? null : new CatalogManager(current.manager, this);
        this.uriForSystem = current.uriForSystem;
        this.mergeHttps = current.mergeHttps;
        this.maskJarUris = current.maskJarUris;
        this.catalogLoader = current.catalogLoader;
        this.parseRddl = current.parseRddl;
        this.classpathCatalogs = current.classpathCatalogs;
        this.archivedCatalogs = current.archivedCatalogs;
        this.throwUriExceptions = current.throwUriExceptions;
        this.showConfigChanges = current.showConfigChanges;
        this.resolverLoggerClass = current.resolverLoggerClass;
        this.resolverLogger = current.resolverLogger;
        this.defaultLoggerLogLevel = current.defaultLoggerLogLevel;
        this.accessExternalEntity = current.accessExternalEntity;
        this.accessExternalDocument = current.accessExternalDocument;
        this.saxParserFactoryClass = current.saxParserFactoryClass;
        this.xmlReaderSupplier = current.xmlReaderSupplier;
    }

    private void loadConfiguration(List<URL> propertyFiles, List<String> catalogFiles) {
        this.loadSystemPropertiesConfiguration();
        ArrayList<URL> propertyFilesList = new ArrayList<URL>();
        if (propertyFiles == null) {
            String propfn = System.getProperty("xmlresolver.properties");
            if (propfn == null) {
                propfn = System.getenv("XMLRESOLVER_PROPERTIES");
            }
            if (propfn == null || "".equals(propfn)) {
                URL propurl = XMLResolverConfiguration.class.getResource("/xmlresolver.properties");
                if (propurl != null) {
                    propertyFilesList.add(propurl);
                }
            } else {
                URI baseURI = URIUtils.cwd();
                for (String fn : propfn.split("\\s*;\\s*")) {
                    try {
                        propertyFilesList.add(baseURI.resolve(fn).toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        } else {
            propertyFilesList.addAll(propertyFiles);
        }
        URL propurl = null;
        Properties properties = new Properties();
        for (URL url : propertyFilesList) {
            try {
                InputStream in = url.openStream();
                if (in == null) continue;
                properties.load(in);
                propurl = url;
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (propurl != null) {
            this.loadPropertiesConfiguration(propurl, properties);
            if (!this.preferPropertyFile.booleanValue()) {
                this.loadSystemPropertiesConfiguration();
            }
        }
        if (catalogFiles == null) {
            if (this.catalogs.isEmpty()) {
                this.catalogs.add("./catalog.xml");
            }
        } else {
            this.catalogs.clear();
            for (String fn : catalogFiles) {
                if ("".equals(fn.trim())) continue;
                this.catalogs.add(fn);
            }
        }
        if (this.saxParserFactoryClass != null) {
            this.setFeature(ResolverFeature.SAXPARSERFACTORY_CLASS, this.saxParserFactoryClass);
        }
        this.showConfig();
        this.showConfigChanges = true;
    }

    private void loadSystemPropertiesConfiguration() {
        String token;
        StringTokenizer tokens;
        String property = System.getProperty("xml.catalog.files");
        if (property != null) {
            tokens = new StringTokenizer(property, ";");
            this.showConfigChange("Catalog list cleared");
            this.catalogs.clear();
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if ("".equals(token.trim())) continue;
                this.showConfigChange("Catalog: %s", token);
                this.catalogs.add(token);
            }
        }
        if ((property = System.getProperty("xml.catalog.additions")) != null) {
            tokens = new StringTokenizer(property, ";");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if ("".equals(token.trim())) continue;
                this.showConfigChange("Catalog: %s", token);
                this.catalogs.add(token);
            }
        }
        if ((property = System.getProperty("xml.catalog.prefer")) != null) {
            this.showConfigChange("Prefer public: %s", property);
            this.preferPublic = "public".equals(property);
        }
        if ((property = System.getProperty("xml.catalog.preferPropertyFile")) != null) {
            this.showConfigChange("Prefer propertyFile: %s", property);
            this.preferPropertyFile = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.allowPI")) != null) {
            this.showConfigChange("Allow catalog PI: %s", property);
            this.allowCatalogPI = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.cache")) != null) {
            this.showConfigChange("Cache directory: %s", property);
            this.cacheDirectory = property;
        }
        if ((property = System.getProperty("xml.catalog.cacheUnderHome")) != null) {
            this.showConfigChange("Cache under home: %s", property);
            this.cacheUnderHome = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.cacheEnabled")) != null) {
            this.showConfigChange("Cache enabled: %s", property);
            this.cacheEnabled = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.uriForSystem")) != null) {
            this.showConfigChange("URI-for-system: %s", property);
            this.uriForSystem = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.mergeHttps")) != null) {
            this.showConfigChange("Merge-https: %s", property);
            this.mergeHttps = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.maskJarUris")) != null) {
            this.showConfigChange("Mask-jar-URIs: %s", property);
            this.maskJarUris = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.catalogLoaderClass")) != null) {
            this.showConfigChange("Catalog loader: %s", property);
            this.catalogLoader = property;
        }
        if ((property = System.getProperty("xml.catalog.parseRddl")) != null) {
            this.showConfigChange("Use RDDL: %s", property);
            this.parseRddl = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.classpathCatalogs")) != null) {
            this.showConfigChange("Classpath catalogs: %s", property);
            this.classpathCatalogs = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.archivedCatalogs")) != null) {
            this.showConfigChange("Archived catalogs: %s", property);
            this.archivedCatalogs = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.throwUriExceptions")) != null) {
            this.showConfigChange("Throw URI exceptions: %s", property);
            this.throwUriExceptions = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = System.getProperty("xml.catalog.resolverLoggerClass")) != null) {
            this.showConfigChange("Resolver logger class: %s", property);
            this.resolverLoggerClass = property;
        }
        if ((property = System.getProperty("xml.catalog.defaultLoggerLogLevel")) != null) {
            this.showConfigChange("Default logger log level: %s", property);
            this.defaultLoggerLogLevel = property;
        }
        if ((property = System.getProperty("xml.catalog.accessExternalEntity")) != null) {
            this.showConfigChange("Access external entity: %s", property);
            this.accessExternalEntity = property;
        }
        if ((property = System.getProperty("xml.catalog.accessExternalDocument")) != null) {
            this.showConfigChange("Access external document: %s", property);
            this.accessExternalDocument = property;
        }
        if ((property = System.getProperty("xml.catalog.saxParserFactoryClass")) != null) {
            this.showConfigChange("SAXParserFactory class: %s", property);
            this.saxParserFactoryClass = property;
        }
    }

    private void loadPropertiesConfiguration(URL propertiesURL, Properties properties) {
        String token;
        StringTokenizer tokens;
        String property = properties.getProperty("catalog-logging");
        if (property != null && System.getProperty("xml.catalog.logging") == null) {
            System.setProperty("xml.catalog.logging", property);
        }
        boolean relative = true;
        String allow = properties.getProperty("relative-catalogs");
        if (allow != null) {
            relative = XMLResolverConfiguration.isTrue(allow);
        }
        this.showConfigChange("Relative catalogs: %s", relative);
        property = properties.getProperty("catalogs");
        if (property != null) {
            tokens = new StringTokenizer(property, ";");
            this.catalogs.clear();
            this.showConfigChange("Catalog list cleared");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if ("".equals(token.trim())) continue;
                if (relative && propertiesURL != null) {
                    try {
                        token = new URL(propertiesURL, token).toString();
                    }
                    catch (MalformedURLException e) {
                        this.resolverLogger.log("error", "Cannot make absolute: " + token, new Object[0]);
                    }
                }
                this.showConfigChange("Catalog: %s", token);
                this.catalogs.add(token);
            }
        }
        if ((property = properties.getProperty("catalog-additions")) != null) {
            tokens = new StringTokenizer(property, ";");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if ("".equals(token.trim())) continue;
                if (relative && propertiesURL != null) {
                    try {
                        token = new URL(propertiesURL, token).toURI().toString();
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        this.resolverLogger.log("error", "Cannot make absolute: " + token, new Object[0]);
                    }
                }
                this.showConfigChange("Catalog: %s", token);
                this.catalogs.add(token);
            }
        }
        if ((property = properties.getProperty("prefer")) != null) {
            this.showConfigChange("Prefer public: %s", property);
            this.preferPublic = "public".equals(property);
        }
        if ((property = properties.getProperty("prefer-property-file")) != null) {
            this.showConfigChange("Prefer propertyFile: %s", property);
            this.preferPropertyFile = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("allow-oasis-xml-catalog-pi")) != null) {
            this.showConfigChange("Allow catalog PI: %s", property);
            this.allowCatalogPI = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("cache")) != null) {
            this.showConfigChange("Cache directory: %s", property);
            this.cacheDirectory = property;
        }
        if ((property = properties.getProperty("cache-under-home")) == null) {
            property = properties.getProperty("cacheUnderHome");
        }
        if (property != null) {
            this.showConfigChange("Cache under home: %s", property);
            this.cacheUnderHome = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("cache-enabled")) != null) {
            this.showConfigChange("Cache enabled: %s", property);
            this.cacheEnabled = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("uri-for-system")) != null) {
            this.showConfigChange("URI-for-system: %s", property);
            this.uriForSystem = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("merge-https")) != null) {
            this.showConfigChange("Merge-https: %s", property);
            this.mergeHttps = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("mask-jar-uris")) != null) {
            this.showConfigChange("Mask-jar-URIs: %s", property);
            this.maskJarUris = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("catalog-loader-class")) != null) {
            this.showConfigChange("Catalog loader: %s", property);
            this.catalogLoader = property;
        }
        if ((property = properties.getProperty("parse-rddl")) != null) {
            this.showConfigChange("Parse RDDL: %s", property);
            this.parseRddl = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("classpath-catalogs")) != null) {
            this.showConfigChange("Classpath catalogs: %s", property);
            this.classpathCatalogs = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("archived-catalogs")) != null) {
            this.showConfigChange("Archived catalogs: %s", property);
            this.archivedCatalogs = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("throw-uri-exceptions")) != null) {
            this.showConfigChange("Throw URI exceptions: %s", property);
            this.throwUriExceptions = XMLResolverConfiguration.isTrue(property);
        }
        if ((property = properties.getProperty("resolver-logger-class")) != null) {
            this.showConfigChange("Resolver logger class: %s", property);
            this.resolverLoggerClass = property;
        }
        if ((property = properties.getProperty("default-logger-log-level")) != null) {
            this.showConfigChange("Default logger log level: %s", property);
            this.defaultLoggerLogLevel = property;
        }
        if ((property = properties.getProperty("access-external-entity")) != null) {
            this.showConfigChange("Access external entity: %s", property);
            this.accessExternalEntity = property;
        }
        if ((property = properties.getProperty("access-external-document")) != null) {
            this.showConfigChange("Access external document: %s", property);
            this.accessExternalDocument = property;
        }
        if ((property = properties.getProperty("saxparserfactory-class")) != null) {
            this.showConfigChange("SAXParserFactory class: %s", property);
            this.saxParserFactoryClass = property;
        }
    }

    private void showConfig() {
        this.resolverLogger.log("config", "Logging: %s", System.getProperty("xml.catalog.logging"));
        this.resolverLogger.log("config", "Prefer public: %s", this.preferPublic);
        this.resolverLogger.log("config", "Prefer property file: %s", this.preferPropertyFile);
        this.resolverLogger.log("config", "Allow catalog PI: %s", this.allowCatalogPI);
        this.resolverLogger.log("config", "Parse RDDL: %s", this.parseRddl);
        this.resolverLogger.log("config", "URI for system: %s", this.uriForSystem);
        this.resolverLogger.log("config", "Merge http/https: %s", this.mergeHttps);
        this.resolverLogger.log("config", "Mask jar URIs: %s", this.maskJarUris);
        this.resolverLogger.log("config", "Cache under home: %s", this.cacheUnderHome);
        this.resolverLogger.log("config", "Cache directory: %s", this.cacheDirectory);
        this.resolverLogger.log("config", "Cache enabled: %s", this.cacheEnabled);
        this.resolverLogger.log("config", "Catalog loader: %s", this.catalogLoader);
        this.resolverLogger.log("config", "Classpath catalogs: %s", this.classpathCatalogs);
        this.resolverLogger.log("config", "Archived catalogs: %s", this.archivedCatalogs);
        this.resolverLogger.log("config", "Throw URI exceptions: %s", this.throwUriExceptions);
        this.resolverLogger.log("config", "Class loader: %s", this.classLoader);
        this.resolverLogger.log("config", "Logger class: %s", this.resolverLoggerClass);
        this.resolverLogger.log("config", "Access external entity: %s", this.accessExternalEntity);
        this.resolverLogger.log("config", "Access external document: %s", this.accessExternalDocument);
        this.resolverLogger.log("config", "SAXParserFactory class: %s", this.saxParserFactoryClass);
        this.resolverLogger.log("config", "XMLReader supplier: %s", this.xmlReaderSupplier);
        this.resolverLogger.log("config", "Default logger log level: %s", this.defaultLoggerLogLevel);
        for (String catalog : this.catalogs) {
            this.resolverLogger.log("config", "Catalog: %s", catalog);
        }
        if (this.classpathCatalogs.booleanValue()) {
            for (String catalog : this.findClasspathCatalogFiles()) {
                this.resolverLogger.log("config", "Catalog: %s", catalog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCatalog(String catalog) {
        if (catalog != null) {
            List<String> list = this.catalogs;
            synchronized (list) {
                this.catalogs.add(catalog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCatalog(URI catalog, InputSource data) {
        if (catalog == null) {
            throw new NullPointerException("null provided for catalog URI");
        }
        if (data == null) {
            throw new NullPointerException("null provided for catalog data");
        }
        URI uri = URIUtils.cwd().resolve(catalog);
        List<String> list = this.catalogs;
        synchronized (list) {
            this.catalogs.add(uri.toString());
            if (this.manager == null) {
                this.manager = this.getFeature(ResolverFeature.CATALOG_MANAGER);
            }
            this.manager.loadCatalog(uri, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCatalog(String catalog) {
        List<String> list = this.catalogs;
        synchronized (list) {
            return this.catalogs.remove(catalog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setFeature(ResolverFeature<T> feature, T value) {
        if (feature == ResolverFeature.CATALOG_FILES) {
            List<String> list = this.catalogs;
            synchronized (list) {
                this.showConfigChange("Catalog list cleared");
                this.catalogs.clear();
                if (value != null) {
                    for (String cat : (List)value) {
                        if ("".equals(cat.trim()) || this.catalogs.contains(cat.trim())) continue;
                        this.showConfigChange("Catalog: %s", cat.trim());
                        this.catalogs.add(cat.trim());
                    }
                }
            }
            return;
        }
        if (feature == ResolverFeature.CATALOG_ADDITIONS) {
            List<String> list = this.catalogs;
            synchronized (list) {
                if (value == null) {
                    this.additionalCatalogs.clear();
                } else {
                    for (String cat : (List)value) {
                        if ("".equals(cat.trim()) || this.additionalCatalogs.contains(cat.trim())) continue;
                        this.showConfigChange("Catalog: %s", cat.trim());
                        this.additionalCatalogs.add(cat.trim());
                    }
                }
            }
            return;
        }
        if (feature == ResolverFeature.CLASSLOADER) {
            this.classLoader = (ClassLoader)value;
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            this.showConfigChange("Catalog loader: %s", this.classLoader);
            return;
        }
        if (feature == ResolverFeature.CACHE_DIRECTORY) {
            this.cacheDirectory = (String)value;
            this.showConfigChange("Cache directory: %s", this.cacheDirectory);
            this.cache = null;
            return;
        }
        if (feature == ResolverFeature.CACHE) {
            this.cache = (ResourceCache)value;
            this.showConfigChange("Cache: %s", this.cache);
            return;
        }
        if (value == null) {
            throw new NullPointerException(feature.getName() + " must not be null");
        }
        if (feature == ResolverFeature.PREFER_PUBLIC) {
            this.preferPublic = (Boolean)value;
            this.showConfigChange("Prefer public: %s", this.preferPublic);
        } else if (feature == ResolverFeature.PREFER_PROPERTY_FILE) {
            this.preferPropertyFile = (Boolean)value;
            this.showConfigChange("Prefer propertyFile: %s", this.preferPropertyFile);
        } else if (feature == ResolverFeature.ALLOW_CATALOG_PI) {
            this.allowCatalogPI = (Boolean)value;
            this.showConfigChange("Allow catalog PI: %s", this.allowCatalogPI);
        } else if (feature == ResolverFeature.CACHE_UNDER_HOME) {
            this.cacheUnderHome = (Boolean)value;
            this.showConfigChange("Cache under home: %s", this.cacheUnderHome);
            this.cache = null;
        } else if (feature == ResolverFeature.CACHE_ENABLED) {
            this.cacheEnabled = (Boolean)value;
            this.showConfigChange("Cache enabled: %s", this.cacheEnabled);
            this.cache = null;
        } else if (feature == ResolverFeature.CATALOG_MANAGER) {
            this.manager = (CatalogManager)value;
            this.resolverLogger.log("config", "Catalog manager: %s", this.manager.toString());
        } else if (feature == ResolverFeature.URI_FOR_SYSTEM) {
            this.uriForSystem = (Boolean)value;
            this.showConfigChange("URI-for-system: %s", this.uriForSystem);
        } else if (feature == ResolverFeature.MERGE_HTTPS) {
            this.mergeHttps = (Boolean)value;
            this.showConfigChange("Merge-https: %s", this.mergeHttps);
        } else if (feature == ResolverFeature.MASK_JAR_URIS) {
            this.maskJarUris = (Boolean)value;
            this.showConfigChange("Mask-jar-URIs: %s", this.maskJarUris);
        } else if (feature == ResolverFeature.CATALOG_LOADER_CLASS) {
            this.catalogLoader = (String)value;
            this.showConfigChange("Catalog loader: %s", this.catalogLoader);
        } else if (feature == ResolverFeature.PARSE_RDDL) {
            this.parseRddl = (Boolean)value;
            this.showConfigChange("Use RDDL: %s", this.parseRddl);
        } else if (feature == ResolverFeature.CLASSPATH_CATALOGS) {
            this.classpathCatalogs = (Boolean)value;
            this.showConfigChange("Classpath catalogs: %s", this.classpathCatalogs);
        } else if (feature == ResolverFeature.ARCHIVED_CATALOGS) {
            this.archivedCatalogs = (Boolean)value;
            this.showConfigChange("Archived catalogs: %s", this.archivedCatalogs);
        } else if (feature == ResolverFeature.THROW_URI_EXCEPTIONS) {
            this.throwUriExceptions = (Boolean)value;
            this.showConfigChange("Throw URI exceptions: %s", this.throwUriExceptions);
        } else if (feature == ResolverFeature.RESOLVER_LOGGER_CLASS) {
            this.resolverLoggerClass = (String)value;
            this.showConfigChange("Resolver logger class: %s", this.resolverLoggerClass);
            this.resolverLogger = null;
            this.resolverLogger = this.getFeature(ResolverFeature.RESOLVER_LOGGER);
        } else if (feature == ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL) {
            this.defaultLoggerLogLevel = (String)value;
            this.showConfigChange("Default logger log level: %s", this.defaultLoggerLogLevel);
        } else if (feature == ResolverFeature.RESOLVER_LOGGER) {
            this.resolverLogger = (ResolverLogger)value;
            this.showConfigChange("Resolver logger: %s", this.resolverLogger);
        } else if (feature == ResolverFeature.ACCESS_EXTERNAL_ENTITY) {
            this.accessExternalEntity = (String)value;
            this.showConfigChange("Access external entity: %s", this.accessExternalEntity);
        } else if (feature == ResolverFeature.ACCESS_EXTERNAL_DOCUMENT) {
            this.accessExternalDocument = (String)value;
            this.showConfigChange("Access external document: %s", this.accessExternalDocument);
        } else if (feature == ResolverFeature.SAXPARSERFACTORY_CLASS) {
            try {
                Class<?> factoryClass = Class.forName((String)value);
                Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
                SAXParserFactory factory = (SAXParserFactory)constructor.newInstance(new Object[0]);
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setXIncludeAware(false);
                XMLReader reader = factory.newSAXParser().getXMLReader();
                assert (reader != null);
                this.xmlReaderSupplier = () -> {
                    try {
                        SAXParser parser = factory.newSAXParser();
                        return parser.getXMLReader();
                    }
                    catch (ParserConfigurationException | SAXException ex) {
                        return null;
                    }
                };
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.saxParserFactoryClass = (String)value;
            this.showConfigChange("SAXParserFactory class: %s", this.saxParserFactoryClass);
        } else if (feature == ResolverFeature.XMLREADER_SUPPLIER) {
            this.saxParserFactoryClass = null;
            this.xmlReaderSupplier = (Supplier)value;
            this.showConfigChange("XMLReader supplier: %s", this.xmlReaderSupplier);
        } else {
            this.resolverLogger.log("error", "Ignoring unknown feature: %s", feature.getName());
        }
    }

    private void showConfigChange(String message) {
        if (this.showConfigChanges.booleanValue()) {
            this.resolverLogger.log("config", message, new Object[0]);
        }
    }

    private void showConfigChange(String message, Object value) {
        if (this.showConfigChanges.booleanValue()) {
            if (value == null) {
                this.resolverLogger.log("config", message, "null");
            } else {
                this.resolverLogger.log("config", message, value.toString());
            }
        }
    }

    private List<String> findClasspathCatalogFiles() {
        if (classpathCatalogList == null) {
            this.resolverLogger.log("config", "Searching for catalogs on classpath:", new Object[0]);
            try {
                for (URL url : ((URLClassLoader)XMLResolverConfiguration.class.getClassLoader()).getURLs()) {
                    this.resolverLogger.log("config", "    " + url.toString(), new Object[0]);
                }
            }
            catch (ClassCastException ex) {
                this.resolverLogger.log("config", "    Unknown: cannot determine class path in JDK9+", new Object[0]);
            }
            ArrayList<String> catalogs = new ArrayList<String>();
            try {
                Enumeration<URL> resources = XMLResolverConfiguration.class.getClassLoader().getResources("org/xmlresolver/catalog.xml");
                while (resources.hasMoreElements()) {
                    URL catalog = resources.nextElement();
                    this.resolverLogger.log("config", "Catalog: " + catalog.toString(), new Object[0]);
                    catalogs.add(catalog.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            classpathCatalogList = Collections.unmodifiableList(catalogs);
        }
        return classpathCatalogList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getFeature(ResolverFeature<T> feature) {
        if (feature == ResolverFeature.CATALOG_MANAGER) {
            if (this.manager == null) {
                this.manager = new CatalogManager(this);
            }
            return (T)this.manager;
        }
        if (feature == ResolverFeature.CATALOG_FILES) {
            ArrayList<String> cats = null;
            List<String> list = this.catalogs;
            synchronized (list) {
                cats = new ArrayList<String>(this.catalogs);
                cats.addAll(this.additionalCatalogs);
            }
            if (this.classpathCatalogs.booleanValue()) {
                cats.addAll(this.findClasspathCatalogFiles());
            }
            return (T)cats;
        }
        if (feature == ResolverFeature.CATALOG_ADDITIONS) {
            ArrayList<String> cats = null;
            List<String> list = this.catalogs;
            synchronized (list) {
                cats = new ArrayList<String>(this.additionalCatalogs);
            }
            return (T)cats;
        }
        if (feature == ResolverFeature.PREFER_PUBLIC) {
            return (T)this.preferPublic;
        }
        if (feature == ResolverFeature.PREFER_PROPERTY_FILE) {
            return (T)this.preferPropertyFile;
        }
        if (feature == ResolverFeature.ALLOW_CATALOG_PI) {
            return (T)this.allowCatalogPI;
        }
        if (feature == ResolverFeature.CACHE_DIRECTORY) {
            return (T)this.cacheDirectory;
        }
        if (feature == ResolverFeature.URI_FOR_SYSTEM) {
            return (T)this.uriForSystem;
        }
        if (feature == ResolverFeature.MERGE_HTTPS) {
            return (T)this.mergeHttps;
        }
        if (feature == ResolverFeature.MASK_JAR_URIS) {
            return (T)this.maskJarUris;
        }
        if (feature == ResolverFeature.CATALOG_LOADER_CLASS) {
            return (T)this.catalogLoader;
        }
        if (feature == ResolverFeature.PARSE_RDDL) {
            return (T)this.parseRddl;
        }
        if (feature == ResolverFeature.CLASSPATH_CATALOGS) {
            return (T)this.classpathCatalogs;
        }
        if (feature == ResolverFeature.CACHE) {
            if (this.cache == null) {
                this.cache = new ResourceCache(this);
            }
            return (T)this.cache;
        }
        if (feature == ResolverFeature.CACHE_UNDER_HOME) {
            return (T)this.cacheUnderHome;
        }
        if (feature == ResolverFeature.CACHE_ENABLED) {
            return (T)this.cacheEnabled;
        }
        if (feature == ResolverFeature.CLASSLOADER) {
            return (T)this.classLoader;
        }
        if (feature == ResolverFeature.ARCHIVED_CATALOGS) {
            return (T)this.archivedCatalogs;
        }
        if (feature == ResolverFeature.THROW_URI_EXCEPTIONS) {
            return (T)this.throwUriExceptions;
        }
        if (feature == ResolverFeature.RESOLVER_LOGGER_CLASS) {
            return (T)this.resolverLoggerClass;
        }
        if (feature == ResolverFeature.DEFAULT_LOGGER_LOG_LEVEL) {
            return (T)this.defaultLoggerLogLevel;
        }
        if (feature == ResolverFeature.RESOLVER_LOGGER) {
            if (this.resolverLogger == null) {
                switch (this.resolverLoggerClass) {
                    case "org.xmlresolver.logging.DefaultLogger": {
                        this.resolverLogger = new DefaultLogger(this);
                        break;
                    }
                    case "org.xmlresolver.logging.SystemLogger": {
                        this.resolverLogger = new SystemLogger(this);
                        break;
                    }
                    default: {
                        try {
                            Class<?> loggerClass = Class.forName(this.resolverLoggerClass);
                            Constructor<?> constructor = loggerClass.getConstructor(ResolverConfiguration.class);
                            this.resolverLogger = (ResolverLogger)constructor.newInstance(this);
                            break;
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                            throw new IllegalArgumentException("Failed to instantiate logger: " + this.resolverLoggerClass + ": " + ex.getMessage());
                        }
                    }
                }
            }
            return (T)this.resolverLogger;
        }
        if (feature == ResolverFeature.ACCESS_EXTERNAL_ENTITY) {
            return (T)this.accessExternalEntity;
        }
        if (feature == ResolverFeature.ACCESS_EXTERNAL_DOCUMENT) {
            return (T)this.accessExternalDocument;
        }
        if (feature == ResolverFeature.SAXPARSERFACTORY_CLASS) {
            return (T)this.saxParserFactoryClass;
        }
        if (feature == ResolverFeature.XMLREADER_SUPPLIER) {
            return (T)this.xmlReaderSupplier;
        }
        this.resolverLogger.log("error", "Ignoring unknown feature: %s", feature.getName());
        return null;
    }

    @Override
    public Iterator<ResolverFeature<?>> getFeatures() {
        return Arrays.stream(knownFeatures).iterator();
    }

    private static boolean isTrue(String aString) {
        if (aString == null) {
            return false;
        }
        return "true".equalsIgnoreCase(aString) || "yes".equalsIgnoreCase(aString) || "1".equalsIgnoreCase(aString);
    }

    private static class FallbackLogger
    extends AbstractLogger {
        private ArrayList<Message> messages = new ArrayList();
        private String fallbackLogging = System.getProperty("xml.catalog.FallbackLoggerLogLevel");

        private FallbackLogger() {
        }

        @Override
        public void log(String cat, String message, Object ... params) {
            this.messages.add(new Message(cat, message, params));
            if (this.fallbackLogging != null) {
                System.err.println(this.logMessage(cat, message, params));
            }
        }

        @Override
        public void warn(String message) {
        }

        @Override
        public void info(String message) {
        }

        @Override
        public void debug(String message) {
        }

        public void forward(ResolverLogger logger) {
            for (Message message : this.messages) {
                logger.log(message.category, message.message, message.params);
            }
            this.messages.clear();
        }

        private static class Message {
            public final String category;
            public final String message;
            public final Object[] params;

            public Message(String level, String message, Object ... params) {
                this.category = level;
                this.message = message;
                this.params = params;
            }
        }
    }
}

