/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.ResolvedResourceImpl;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceResolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.cache.CacheEntry;
import org.xmlresolver.cache.ResourceCache;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.URIUtils;

public class CatalogResolver
implements ResourceResolver {
    private final ResolverLogger logger;
    private XMLResolverConfiguration config = null;
    private ResourceCache cache = null;

    public CatalogResolver() {
        this(new XMLResolverConfiguration());
    }

    public CatalogResolver(XMLResolverConfiguration conf) {
        this.config = conf;
        this.cache = conf.getFeature(ResolverFeature.CACHE);
        this.logger = conf.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    @Override
    public XMLResolverConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public ResolvedResource resolveURI(String href, String baseURI) {
        block23: {
            this.logger.log("request", "resolveURI: %s (base URI: %s)", href, baseURI);
            boolean throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            if (href == null || "".equals(href)) {
                href = baseURI;
                baseURI = null;
                if (href == null || "".equals(href)) {
                    this.logger.log("response", "resolveURI: null", new Object[0]);
                    return null;
                }
            }
            try {
                URI uri = new URI(href);
                if (uri.isAbsolute() && this.forbidAccess(this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT), href)) {
                    this.logger.log("request", "resolveURI (access denied): null", new Object[0]);
                    return null;
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
            CatalogManager catalog = this.config.getFeature(ResolverFeature.CATALOG_MANAGER);
            URI resolved = catalog.lookupURI(href);
            if (resolved != null) {
                this.logger.log("response", "resolveURI: %s", resolved);
                return this.resource(href, resolved, this.cache.cachedUri(resolved));
            }
            String absolute = href;
            if (baseURI != null) {
                try {
                    absolute = new URI(baseURI).resolve(href).toString();
                    if (!href.equals(absolute)) {
                        if (this.forbidAccess(this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT), absolute)) {
                            this.logger.log("request", "resolveURI (access denied): null", new Object[0]);
                            return null;
                        }
                        resolved = catalog.lookupURI(absolute);
                        if (resolved != null) {
                            this.logger.log("response", "resolveURI: %s", resolved);
                            return this.resource(absolute, resolved, this.cache.cachedUri(resolved));
                        }
                    }
                }
                catch (URISyntaxException ex) {
                    this.logger.log("error", "URI syntax exception: %s (base URI: %s)", href, baseURI);
                    if (throwExceptions) {
                        throw new IllegalArgumentException(ex);
                    }
                    this.logger.log("response", "resolveURI: null", new Object[0]);
                    return null;
                }
                catch (IllegalArgumentException ex) {
                    this.logger.log("error", "URI argument exception: %s (base URI: %s)", href, baseURI);
                    if (throwExceptions) {
                        throw ex;
                    }
                    this.logger.log("response", "resolveURI: null", new Object[0]);
                    return null;
                }
            }
            try {
                if (absolute.startsWith("data:")) {
                    URI absuri = new URI(absolute);
                    return this.uncachedResource(absuri, absuri);
                }
                if (this.cache.cacheURI(absolute)) {
                    URI absuri = new URI(absolute);
                    this.logger.log("response", "resolveURI: cached %s", absolute);
                    return this.resource(absolute, absuri, this.cache.cachedUri(absuri));
                }
                this.logger.log("response", "resolveURI: null", new Object[0]);
                return null;
            }
            catch (URISyntaxException use) {
                this.logger.log("error", "URI syntax exception: %s", absolute);
                if (throwExceptions) {
                    throw new IllegalArgumentException(use);
                }
            }
            catch (IllegalArgumentException ex) {
                this.logger.log("error", "URI argument exception: %s", absolute);
                if (throwExceptions) {
                    throw ex;
                }
            }
            catch (IOException ex) {
                this.logger.log("error", "I/O exception: %s", absolute);
                if (!throwExceptions) break block23;
                throw new IllegalArgumentException(ex);
            }
        }
        this.logger.log("response", "resolveURI: null", new Object[0]);
        return null;
    }

    @Override
    public ResolvedResource resolveEntity(String name, String publicId, String systemId, String baseURI) {
        block32: {
            boolean throwExceptions;
            if (name == null && publicId == null && systemId == null && baseURI == null) {
                this.logger.log("request", "resolveEntity: null", new Object[0]);
                return null;
            }
            if (systemId != null) {
                try {
                    URI uri = new URI(systemId);
                    if (uri.isAbsolute() && this.forbidAccess(this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY), systemId)) {
                        this.logger.log("request", "resolveEntity (access denied): null", new Object[0]);
                        return null;
                    }
                }
                catch (URISyntaxException uri) {
                    // empty catch block
                }
            }
            if (name != null && publicId == null && systemId == null) {
                this.logger.log("request", "resolveEntity: name: %s (%s)", name, baseURI);
                return this.resolveDoctype(name, baseURI);
            }
            if (name != null) {
                this.logger.log("request", "resolveEntity: %s %s (baseURI: %s, publicId: %s)", name, systemId, baseURI, publicId);
            } else {
                this.logger.log("request", "resolveEntity: %s (baseURI: %s, publicId: %s)", systemId, baseURI, publicId);
            }
            URI absSystem = null;
            CatalogManager catalog = this.config.getFeature(ResolverFeature.CATALOG_MANAGER);
            ResolvedResourceImpl result = null;
            URI resolved = catalog.lookupEntity(name, systemId, publicId);
            if (resolved == null && systemId != null && this.config.getFeature(ResolverFeature.URI_FOR_SYSTEM).booleanValue()) {
                resolved = catalog.lookupURI(systemId);
            }
            if (resolved != null) {
                result = this.resource(systemId, resolved, this.cache.cachedSystem(resolved, publicId));
            } else {
                throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
                try {
                    if (systemId != null) {
                        absSystem = new URI(systemId);
                    }
                    if (baseURI != null) {
                        absSystem = new URI(baseURI);
                        if (systemId != null) {
                            absSystem = absSystem.resolve(systemId);
                        }
                        if (this.forbidAccess(this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY), absSystem.toString())) {
                            this.logger.log("request", "resolveEntity (access denied): null", new Object[0]);
                            return null;
                        }
                        resolved = catalog.lookupEntity(name, absSystem.toString(), publicId);
                        if (resolved == null && this.config.getFeature(ResolverFeature.URI_FOR_SYSTEM).booleanValue()) {
                            resolved = catalog.lookupURI(absSystem.toString());
                        }
                        if (resolved != null) {
                            result = this.resource(absSystem.toString(), resolved, this.cache.cachedSystem(resolved, publicId));
                        }
                    }
                }
                catch (URISyntaxException ex) {
                    this.logger.log("error", "URI exception: %s (base: %s)", systemId, baseURI);
                    if (throwExceptions) {
                        throw new IllegalArgumentException(ex);
                    }
                    this.logger.log("response", "resolveURI: null", new Object[0]);
                    return null;
                }
                catch (IllegalArgumentException ex) {
                    this.logger.log("error", "URI exception: %s (base: %s)", systemId, baseURI);
                    if (throwExceptions) {
                        throw ex;
                    }
                    this.logger.log("response", "resolveURI: null", new Object[0]);
                    return null;
                }
            }
            if (result != null) {
                this.logger.log("response", "resolveEntity: %s", resolved);
                return result;
            }
            if (absSystem == null) {
                this.logger.log("response", "resolveEntity: null", new Object[0]);
                return null;
            }
            throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            try {
                if ("data".equals(absSystem.getScheme())) {
                    return this.uncachedResource(absSystem, absSystem);
                }
                if (this.cache.cacheURI(absSystem.toString())) {
                    this.logger.log("response", "resolveEntity: cached %s", absSystem);
                    return this.resource(absSystem.toString(), absSystem, this.cache.cachedSystem(absSystem, publicId));
                }
            }
            catch (URISyntaxException use) {
                this.logger.log("error", "URI syntax exception: %s", absSystem);
                if (throwExceptions) {
                    throw new IllegalArgumentException(use);
                }
            }
            catch (IllegalArgumentException ex) {
                this.logger.log("error", "URI argument exception: %s", absSystem);
                if (throwExceptions) {
                    throw ex;
                }
            }
            catch (IOException ex) {
                this.logger.log("error", "I/O exception: %s", absSystem);
                if (!throwExceptions) break block32;
                throw new IllegalArgumentException(ex);
            }
        }
        this.logger.log("response", "resolveEntity: null", new Object[0]);
        return null;
    }

    private ResolvedResource resolveDoctype(String name, String baseURI) {
        if (baseURI == null) {
            this.logger.log("request", "resolveDoctype: %s", name);
        } else {
            this.logger.log("request", "resolveDoctype: %s (%s)", name, baseURI);
            try {
                URI uri = new URI(baseURI);
                if (uri.isAbsolute() && this.forbidAccess(this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY), baseURI)) {
                    this.logger.log("request", "resolveEntity (access denied): null", new Object[0]);
                    return null;
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        CatalogManager catalog = this.config.getFeature(ResolverFeature.CATALOG_MANAGER);
        URI resolved = catalog.lookupDoctype(name, null, null);
        if (resolved == null) {
            this.logger.log("response", "resolveDoctype: null", new Object[0]);
            return null;
        }
        this.logger.log("response", "resolveDoctype: %s", resolved);
        ResolvedResourceImpl result = this.resource(null, resolved, this.cache.cachedSystem(resolved, null));
        return result;
    }

    @Override
    public ResolvedResource resolveNamespace(String uri, String baseURI, String nature, String purpose) {
        CacheEntry cached;
        URI resolved;
        URI absolute;
        boolean throwExceptions;
        block24: {
            CatalogManager catalog;
            block23: {
                this.logger.log("request", "resolveNamespace: %s (base: %s, nature: %s, purpose: %s)", uri, baseURI, nature, purpose);
                catalog = this.config.getFeature(ResolverFeature.CATALOG_MANAGER);
                throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
                absolute = null;
                try {
                    absolute = new URI(uri);
                    if (absolute.isAbsolute() && this.forbidAccess(this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT), uri)) {
                        this.logger.log("request", "resolveNamespace (access denied): null", new Object[0]);
                        return null;
                    }
                }
                catch (URISyntaxException ex) {
                    if (throwExceptions) {
                        throw new IllegalArgumentException(ex);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (!throwExceptions) break block23;
                    throw ex;
                }
            }
            if ((resolved = catalog.lookupNamespaceURI(uri, nature, purpose)) == null && baseURI != null) {
                try {
                    absolute = new URI(baseURI).resolve(uri);
                    uri = absolute.toString();
                    if (absolute.isAbsolute() && this.forbidAccess(this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT), uri)) {
                        this.logger.log("request", "resolveNamespace (access denied): null", new Object[0]);
                        return null;
                    }
                    resolved = catalog.lookupNamespaceURI(uri, nature, purpose);
                }
                catch (URISyntaxException ex) {
                    if (throwExceptions) {
                        throw new IllegalArgumentException(ex);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (!throwExceptions) break block24;
                    throw ex;
                }
            }
        }
        CacheEntry cacheEntry = cached = resolved == null ? null : this.cache.cachedNamespaceUri(resolved, nature, purpose);
        if (this.config.getFeature(ResolverFeature.PARSE_RDDL).booleanValue() && nature != null && purpose != null) {
            URI rddl = null;
            if (cached != null) {
                rddl = this.checkRddl(cached.file.toURI(), nature, purpose, cached.contentType());
                if (rddl != null) {
                    cached = this.cache.cachedUri(rddl);
                }
            } else {
                try {
                    rddl = resolved != null ? this.checkRddl(resolved, nature, purpose, null) : this.checkRddl(URIUtils.newURI(uri), nature, purpose, null);
                }
                catch (URISyntaxException ex) {
                    this.logger.log("error", "URI syntax exception: " + uri, new Object[0]);
                    if (throwExceptions) {
                        throw new IllegalArgumentException(ex);
                    }
                    this.logger.log("response", "resolveNamespace: null", new Object[0]);
                    return null;
                }
                catch (IllegalArgumentException ex) {
                    this.logger.log("error", "URI argument exception: " + uri, new Object[0]);
                    if (throwExceptions) {
                        throw ex;
                    }
                    this.logger.log("response", "resolveNamespace: null", new Object[0]);
                    return null;
                }
            }
            if (rddl != null) {
                ResolvedResource local = this.resolveURI(rddl.toString(), uri);
                if (local != null) {
                    this.logger.log("response", "resolveNamespace: %s", local.getLocalURI());
                    return local;
                }
                this.logger.log("response", "resolveNamespace: %s", rddl);
                return this.resource(uri, rddl, cached);
            }
        }
        if (resolved != null) {
            this.logger.log("response", "resolveNamespace: %s", resolved);
            return this.resource(absolute == null ? null : absolute.toString(), resolved, this.cache.cachedNamespaceUri(resolved, nature, purpose));
        }
        this.logger.log("response", "resolveNamespace: null", new Object[0]);
        return null;
    }

    private boolean forbidAccess(String allowed, String uri) {
        if (allowed == null || "".equals(allowed.trim())) {
            return true;
        }
        if ("all".equals(allowed.trim())) {
            return false;
        }
        boolean sawHttp = false;
        boolean sawHttps = false;
        uri = uri.toLowerCase();
        for (String value : allowed.split(",")) {
            String protocol = value.trim().toLowerCase();
            if ("all".equals(protocol)) {
                return false;
            }
            if (!protocol.endsWith(":")) {
                protocol = protocol + ":";
            }
            sawHttp = sawHttp || "http:".equals(protocol);
            boolean bl = sawHttps = sawHttps || "https:".equals(protocol);
            if (!uri.startsWith(protocol)) continue;
            return false;
        }
        if (this.config.getFeature(ResolverFeature.MERGE_HTTPS).booleanValue()) {
            if (sawHttp && !sawHttps && uri.startsWith("https:")) {
                return false;
            }
            if (sawHttps && !sawHttp && uri.startsWith("http:")) {
                return false;
            }
        }
        return true;
    }

    private ResolvedResourceImpl resource(String requestURI, URI responseURI, CacheEntry cached) {
        boolean throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
        try {
            if (cached == null) {
                return this.uncachedResource(URIUtils.newURI(requestURI), responseURI);
            }
            FileInputStream fs = new FileInputStream(cached.file);
            return new ResolvedResourceImpl(responseURI, cached.file.toURI(), fs, cached.contentType());
        }
        catch (IOException | URISyntaxException ex) {
            this.logger.log("error", "Resolution failed: %s: %s", responseURI, ex.getMessage());
            if (throwExceptions) {
                throw new IllegalArgumentException(ex);
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            this.logger.log("error", "Resolution failed: %s: %s", responseURI, ex.getMessage());
            if (throwExceptions) {
                throw ex;
            }
            return null;
        }
    }

    private ResolvedResourceImpl uncachedResource(URI req, URI res) throws IOException, URISyntaxException {
        boolean mask = this.config.getFeature(ResolverFeature.MASK_JAR_URIS);
        URI showResolvedURI = res;
        if (mask && ("jar".equals(showResolvedURI.getScheme()) || "classpath".equals(showResolvedURI.getScheme()))) {
            showResolvedURI = req;
        }
        InputStream inputStream = null;
        if ("data".equals(res.getScheme())) {
            String contentType = null;
            String path = res.toString().substring(5);
            int pos = path.indexOf(",");
            if (pos >= 0) {
                String mediatype = path.substring(0, pos);
                String data = path.substring(pos + 1);
                if (mediatype.endsWith(";base64")) {
                    inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                    contentType = mediatype.substring(0, mediatype.length() - 7);
                } else {
                    String charset = "UTF-8";
                    pos = mediatype.indexOf(";charset=");
                    if (pos > 0 && (pos = (charset = mediatype.substring(pos + 9)).indexOf(";")) >= 0) {
                        charset = charset.substring(0, pos);
                    }
                    data = URLDecoder.decode(data, charset);
                    inputStream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
                    contentType = "".equals(mediatype) ? null : mediatype;
                }
                return new ResolvedResourceImpl(showResolvedURI, res, inputStream, contentType);
            }
            throw new URISyntaxException(res.toString(), "Comma separator missing");
        }
        if ("classpath".equals(res.getScheme())) {
            URL rsrc;
            String path = res.getSchemeSpecificPart();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((rsrc = this.config.getFeature(ResolverFeature.CLASSLOADER).getResource(path)) == null) {
                throw new IOException("Not found: " + res);
            }
            inputStream = rsrc.openStream();
            return new ResolvedResourceImpl(showResolvedURI, res, inputStream, null);
        }
        URLConnection conn = res.toURL().openConnection();
        return new ResolvedResourceImpl(showResolvedURI, res, conn.getInputStream(), conn.getContentType());
    }

    private URI checkRddl(URI uri, String nature, String purpose, String contentType) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            spf.setXIncludeAware(false);
            URLConnection conn = uri.toURL().openConnection();
            if (contentType == null) {
                contentType = conn.getContentType();
            }
            if (contentType != null && (contentType.startsWith("text/html") || contentType.startsWith("application/html+xml"))) {
                InputSource source = new InputSource(conn.getInputStream());
                RddlQuery handler = new RddlQuery(conn.getURL().toURI(), nature, purpose);
                SAXParser parser = spf.newSAXParser();
                parser.parse(source, (DefaultHandler)handler);
                return handler.href();
            }
            return null;
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | ParserConfigurationException | SAXException ex) {
            this.logger.log("error", "RDDL parse failed: %s: %s", uri, ex.getMessage());
            return null;
        }
    }

    private static class RddlQuery
    extends DefaultHandler {
        private final String nature;
        private final String purpose;
        private URI found = null;
        private final Stack<URI> baseUriStack = new Stack();

        public RddlQuery(URI baseURI, String nature, String purpose) {
            this.nature = nature;
            this.purpose = purpose;
            this.baseUriStack.push(baseURI);
        }

        public URI href() {
            return this.found;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("http://www.w3.org/1999/xhtml".equals(uri) && attributes.getValue("", "base") != null) {
                this.baseUriStack.push(this.baseUriStack.peek().resolve(attributes.getValue("", "base")));
            } else if (attributes.getValue("http://www.w3.org/XML/1998/namespace", "base") != null) {
                this.baseUriStack.push(this.baseUriStack.peek().resolve(attributes.getValue("http://www.w3.org/XML/1998/namespace", "base")));
            } else {
                this.baseUriStack.push(this.baseUriStack.peek());
            }
            if (this.found == null && "http://www.rddl.org/".equals(uri) && "resource".equals(localName)) {
                String rnature = attributes.getValue("http://www.w3.org/1999/xlink", "role");
                String rpurpose = attributes.getValue("http://www.w3.org/1999/xlink", "arcrole");
                String href = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                if (this.nature.equals(rnature) && this.purpose.equals(rpurpose) && href != null) {
                    this.found = this.baseUriStack.peek().resolve(href);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.baseUriStack.pop();
        }
    }
}

