/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasTexts;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDir
implements IPSClonableElement<PSDir>,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasTexts {
    private EDirValue m_eValue;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<dir> has no content");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aContent.isEmpty()) {
            iPSErrorHandler.error(this, "<dir> has no content");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(IMicroElement.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    public void setValue(@Nullable EDirValue eDirValue) {
        this.m_eValue = eDirValue;
    }

    @Nullable
    public EDirValue getValue() {
        return this.m_eValue;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add((Object)string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(String.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    @Nullable
    public String getAsText() {
        return StringHelper.getImploded(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "dir");
        if (this.m_eValue != null) {
            microElement.setAttribute("value", this.m_eValue.getID());
        }
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild((IMicroNode)((IMicroElement)object).getClone());
                continue;
            }
            microElement.appendText((CharSequence)((String)object));
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSDir getClone() {
        PSDir pSDir = new PSDir();
        pSDir.setValue(this.m_eValue);
        for (Object e : this.m_aContent) {
            if (e instanceof IMicroElement) {
                pSDir.addForeignElement(((IMicroElement)e).getClone());
                continue;
            }
            pSDir.addText((String)e);
        }
        if (this.hasForeignAttributes()) {
            pSDir.addForeignAttributes((Map)this.m_aForeignAttrs);
        }
        return pSDir;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("value", (Object)this.m_eValue).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }

    public static enum EDirValue implements IHasID<String>
    {
        LTR("ltr"),
        RTL("rtl");

        private final String m_sID;

        private EDirValue(String string2) {
            this.m_sID = string2;
        }

        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        @Nullable
        public static EDirValue getFromIDOrNull(@Nullable String string) {
            return (EDirValue)EnumHelper.getFromIDOrNull(EDirValue.class, (Object)string);
        }
    }
}

