/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.error.structure;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.StyledLabelConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.StringFunctions;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.MailEncryption;
import com.inet.mail.api.MailServerProbe;
import com.inet.mail.api.profiles.MailProfile;
import com.inet.oauth.connection.api.config.OAuthConnectionTokenConfigProperty;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.plugin.ApplicationDescription;
import com.inet.report.error.ErrorHandlerServerPlugin;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends AbstractStructureProvider {
    public static final ConfigKey O = new ConfigKey("fallback.mail.activated", "false", Boolean.class);
    @Nonnull
    public static final ConfigKey P = new ConfigKey("fallback.mail.smtp.provider", "", String.class);
    public static final ConfigKey Q = new ConfigKey("fallback.mail.smtp.refresh.token", "", String.class);
    public static final ConfigKey R = new ConfigKey("fallback.mail.smtphost", "", String.class);
    public static final ConfigKey S = new ConfigKey("fallback.mail.smtpport", "25", Integer.class);
    public static final ConfigKey T = new ConfigKey("fallback.mail.pop3host", "", String.class);
    public static final ConfigKey U = new ConfigKey("fallback.mail.pop3port", "110", Integer.class);
    public static final ConfigKey V = new ConfigKey("fallback.mail.user", "", String.class);
    public static final ConfigKey W = new ConfigKey("fallback.mail.password", "", String.class);
    public static final ConfigKey X = new ConfigKey("fallback.mail.sender", "", String.class);
    public static final ConfigKey Y = new ConfigKey("fallback.mail.authentication", "0", Integer.class);
    public static final ConfigKey Z = new ConfigKey("fallback.mail.encryption", "NONE", String.class);
    public static final ConfigKey aa = new ConfigKey("fallback.mail.publicehlo", "false", Boolean.class);
    protected static final ConfigValue<String> ab = new ConfigValue<String>(ConfigKey.SERVER_URL){

        protected String e(@Nonnull String string) throws IllegalArgumentException {
            try {
                return new URL(string).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                return "";
            }
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.e(string);
        }
    };

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.errorhandler": {
                propertyGroups.add(new ConfigPropertyGroup(150, "fallback.mail.propgroup.general"));
                propertyGroups.add(new ConfigPropertyGroup(300, "fallback.mail.propgroup.settings", this.translate(settings, "fallback.mail.propgroup.settings", new Object[0])));
                propertyGroups.add(new ConfigPropertyGroup(400, "fallback.mail.propgroup.security", this.translate(settings, "fallback.mail.propgroup.security", new Object[0])));
                if (advanced) {
                    propertyGroups.add(new ConfigPropertyGroup(500, "fallback.mail.propgroup.additional", this.translate(settings, "fallback.mail.propgroup.additional", new Object[0])));
                }
                propertyGroups.add(new ConfigPropertyGroup(600, "fallback.mail.propgroup.sender", this.translate(settings, "fallback.mail.propgroup.sender", new Object[0]), new ConfigAction("fallback.mail.action.testemail", this.translate(settings, "fallback.mail.action.testemail", new Object[0]))));
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.errorhandler": {
                ConfigCondition configCondition;
                ConfigCondition configCondition2;
                ConditionGenerator conditionGenerator = new ConditionGenerator();
                ConfigCondition configCondition3 = conditionGenerator.createCondition().property(ErrorHandlerServerPlugin.KEY_ACTIVATED).equals().value((Object)Boolean.TRUE);
                actions.add(conditionGenerator.enableActionFor(configCondition3, "fallback.mail.propgroup.general"));
                actions.add(conditionGenerator.enableActionFor(configCondition3, "fallback.mail.propgroup.security"));
                actions.add(conditionGenerator.enableActionFor(configCondition3, "fallback.mail.propgroup.sender"));
                actions.add(conditionGenerator.enableActionFor(configCondition3, "fallback.mail.propgroup.settings"));
                actions.add(conditionGenerator.enableActionFor(configCondition3, "fallback.mail.propgroup.additional"));
                ConfigCondition configCondition4 = conditionGenerator.createCondition().property(O).equals().value((Object)Boolean.TRUE);
                actions.add(conditionGenerator.visibleActionFor(configCondition4, "fallback.mail.propgroup.security"));
                actions.add(conditionGenerator.visibleActionFor(configCondition4, "fallback.mail.propgroup.sender"));
                actions.add(conditionGenerator.visibleActionFor(configCondition4, "fallback.mail.propgroup.settings"));
                actions.add(conditionGenerator.visibleActionFor(configCondition4, "fallback.mail.propgroup.additional"));
                List list = MailProfile.getAvailableProfiles();
                if (list.size() > 0) {
                    configCondition2 = conditionGenerator.createCondition().property(P).equals().value((Object)"");
                    actions.add(conditionGenerator.visibleActionFor(configCondition2, R));
                    actions.add(conditionGenerator.visibleActionFor(configCondition2, S));
                    actions.add(conditionGenerator.visibleActionFor(configCondition2.and(configCondition4), "fallback.mail.propgroup.security"));
                    configCondition = conditionGenerator.createCondition().not(configCondition2);
                    actions.add(conditionGenerator.visibleActionFor(configCondition, Q));
                    actions.add(conditionGenerator.visibleActionFor(configCondition, "fallback.mail.error.badPublicUrl"));
                    for (MailProfile mailProfile : list) {
                        ConfigCondition configCondition5 = conditionGenerator.createCondition().property(P).equals().value((Object)mailProfile.getName());
                        actions.add(conditionGenerator.setValueActionFor(configCondition5, "fallback.mail.profile.scope", mailProfile.getSmtpScopes()));
                        actions.add(conditionGenerator.setValueActionFor(configCondition5, "fallback.mail.profile.provider", mailProfile.getOauthProvider()));
                    }
                    actions.add(conditionGenerator.setValueActionFor(configCondition2, "fallback.mail.profile.scope", ""));
                    actions.add(conditionGenerator.setValueActionFor(configCondition2, "fallback.mail.profile.provider", ""));
                }
                configCondition2 = conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(Y).equals().value((Object)"2"), conditionGenerator.createCondition().property(Y).equals().value((Object)"3")});
                actions.add(conditionGenerator.visibleActionFor(configCondition2, T));
                actions.add(conditionGenerator.visibleActionFor(configCondition2, U));
                configCondition = conditionGenerator.createCondition().not(conditionGenerator.createCondition().property(Y).equals().value((Object)"0"));
                actions.add(conditionGenerator.visibleActionFor(configCondition, V));
                actions.add(conditionGenerator.visibleActionFor(configCondition, W));
                actions.add(conditionGenerator.setValueActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property(Z).equals().value((Object)MailEncryption.SSL.name()), conditionGenerator.createCondition().property(S).equals().value((Object)"25")}), S, "465"));
                actions.add(conditionGenerator.setValueActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(Z).equals().value((Object)MailEncryption.STARTTLS.name()), conditionGenerator.createCondition().property(Z).equals().value((Object)MailEncryption.NONE.name())}), conditionGenerator.createCondition().property(S).equals().value((Object)"465")}), S, "25"));
                break;
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "fallback.mail.propgroup.general": {
                this.addTo(configProperties, O, settings);
                break;
            }
            case "fallback.mail.propgroup.settings": {
                List list;
                if (MailProfile.XOAUTH2 && (list = MailProfile.getAvailableProfiles()).size() > 0) {
                    MailProfile mailProfile;
                    Object object2;
                    this.addTo(configProperties, "fallback.mail.profile.scope", "Hidden", settings);
                    this.addTo(configProperties, "fallback.mail.profile.provider", "Hidden", settings);
                    ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                    arrayList.add(new LocalizedKey("", this.translate(settings, "fallback.mail.customMailServer", new Object[0])));
                    for (Object object2 : list) {
                        arrayList.add(new LocalizedKey(object2.getName(), object2.getDisplayName()));
                    }
                    this.addSelectTo(configProperties, P, settings, arrayList);
                    HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
                    Objects.requireNonNull(httpServletRequest);
                    object2 = ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)httpServletRequest).toString();
                    String string2 = OauthAccessTokenManager.getRedirectUrl();
                    int n = string2.indexOf("://") + 3;
                    n = string2.indexOf(47, n);
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    }
                    if (!((String)object2).equalsIgnoreCase(string2)) {
                        configProperties.add((ConfigProperty)new StyledLabelConfigProperty(Set.of(StyledLabelConfigProperty.Style.danger), 204, "fallback.mail.error.badPublicUrl", "", this.translate(settings, "fallback.mail.error.badPublicUrl", new Object[]{string2})));
                    } else {
                        this.addTo(configProperties, "fallback.mail.error.badPublicUrl", "Hidden", settings);
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("provider", "fallback.mail.profile.provider");
                    hashMap.put("scope", "fallback.mail.profile.scope");
                    String string3 = settings.getValue(Q);
                    configProperties.add((ConfigProperty)new OAuthConnectionTokenConfigProperty(205, Q.getKey(), StringFunctions.isEmpty((String)string3) ? "" : "xxxxxx", hashMap));
                    String string4 = settings.getValue(P);
                    String string5 = settings.getValue(Q);
                    if (!StringFunctions.isEmpty((String)string4) && !StringFunctions.isEmpty((String)string5) && (mailProfile = MailProfile.getProfile((String)string4)) != null) {
                        try {
                            Consumer<String> consumer = string -> ConfigurationManager.getInstance().getCurrent().put(Q, string);
                            OauthAccessTokenManager.getAccessToken((String)mailProfile.getOauthProvider(), (String)string5, (int)450, consumer);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                this.addTo(configProperties, R, settings);
                this.addTo(configProperties, S, settings, "25");
                this.addTo(configProperties, X, settings);
                break;
            }
            case "fallback.mail.propgroup.security": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                String string6 = Z.getKey() + ".";
                arrayList.add(new LocalizedKey(MailEncryption.NONE.name(), this.translate(settings, string6 + "none", new Object[0])));
                arrayList.add(new LocalizedKey(MailEncryption.STARTTLS.name(), this.translate(settings, string6 + "starttls", new Object[0])));
                arrayList.add(new LocalizedKey(MailEncryption.SSL.name(), this.translate(settings, string6 + "ssl", new Object[0])));
                this.addSelectTo(configProperties, Z, settings, arrayList);
                arrayList = new ArrayList();
                arrayList.add(new LocalizedKey("0", this.translate(settings, string6 + "none", new Object[0])));
                arrayList.add(new LocalizedKey("1", "SMTP"));
                arrayList.add(new LocalizedKey("2", "POP3"));
                arrayList.add(new LocalizedKey("3", "POP3 & SMTP"));
                this.addSelectTo(configProperties, Y, settings, arrayList);
                this.addTo(configProperties, T, settings);
                this.addTo(configProperties, U, settings);
                this.addTo(configProperties, V, settings);
                this.addTo(configProperties, W.getKey(), "Password", Encryption.decrypt((String)settings.getValue(W)), settings);
                break;
            }
            case "fallback.mail.propgroup.sender": {
                this.addTo(configProperties, "fallback.mail.sendTestEmailTo", "SimpleText", "", settings, this.translate(settings, "fallback.mail.sendTestEmailTo.placeholder", new Object[0]));
                break;
            }
            case "fallback.mail.propgroup.additional": {
                Function<String, String> function = string -> {
                    if (StringFunctions.isEmpty((String)string)) {
                        return this.translate(settings, "fallback.mail.publicehlo.notAvailable", new Object[0]);
                    }
                    return string;
                };
                this.addTo(configProperties, "fallback.mail.publicehlo.description", "Label", settings);
                String string7 = (String)ab.get();
                if (!settings.isFilter()) {
                    string7 = CoreSystemStructureProvider.getPublicDomain();
                }
                List<LocalizedKey> list = List.of(new LocalizedKey("false", this.translate(settings, "fallback.mail.publicehlo.server", new Object[]{function.apply((String)ab.get())})), new LocalizedKey("true", this.translate(settings, "fallback.mail.publicehlo.public", new Object[]{function.apply(string7)})));
                this.addSelectTo(configProperties, aa, settings, list);
                break;
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        if (categoryKey == null || categoryKey.equals("category.errorhandler")) {
            ConfigValidator configValidator = new ConfigValidator(messages, settings);
            configValidator.validateEmails(X);
            String string = settings.getValue(P.getKey());
            String string2 = settings.getValue(Q.getKey());
            if (!StringFunctions.isEmpty((String)string) && StringFunctions.isEmpty((String)string2)) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "fallback.mail.error.missing.refreshtoken", new Object[0]), Q));
            }
        }
    }

    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        block3 : switch (actionKey) {
            case "fallback.mail.action.testemail": {
                String string;
                String string2 = settings.getChangedValue("fallback.mail.sendTestEmailTo");
                if (string2 == null || string2.length() == 0) {
                    string2 = settings.getValue(X);
                }
                new ConfigValidator(messages, settings).validateEmails(string2, "fallback.mail.sendTestEmailTo");
                new ConfigValidator(messages, settings).validateEmails(X);
                if (!messages.isEmpty()) {
                    return;
                }
                List list = this.getConditions("category.errorhandler", settings);
                ApplicationDescription applicationDescription = ApplicationDescription.get();
                String string3 = applicationDescription.getRemoteGuiInformation().getProductTitle();
                MailServerProbe mailServerProbe = new MailServerProbe(this.translate(settings, "fallback.mail.action.testemail.subject", new Object[]{string3}), this.translate(settings, "fallback.mail.action.testemail.message", new Object[]{string3}));
                String string4 = settings.getValue(S);
                if (string4 == null || string4.isEmpty()) {
                    string4 = "25";
                }
                mailServerProbe.setSmtpHost(settings.getValue(R)).setSmtpPort(Integer.parseInt(string4)).setSender(settings.getValue(X)).setAuthenticationMethod(MailAuthenticationMethod.fromID((int)Integer.parseInt(settings.getValue(Y)))).setEncryption(MailEncryption.valueOf((String)settings.getValue(Z)));
                if (settings.isValidatable(V, list)) {
                    mailServerProbe.setUser(settings.getValue(V));
                    string = settings.getOriginalValue(W);
                    String string5 = settings.getValue(W);
                    if (string.equals(string5)) {
                        string5 = Encryption.decrypt((String)string);
                    }
                    mailServerProbe.setPassword(string5);
                }
                if (settings.isValidatable(T, list)) {
                    mailServerProbe.setPop3Host(settings.getValue(T));
                    mailServerProbe.setPop3Port(Integer.parseInt(settings.getValue(U)));
                }
                mailServerProbe.setEmailRecipient(string2);
                mailServerProbe.setSmtpProvider(settings.getValue(P)).setSmtpRefreshToken(settings.getValue(Q));
                string = mailServerProbe.probe();
                switch (string.getStatus()) {
                    case OK: {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "fallback.mail.validateMailOK", new Object[0]), (String)null));
                        break block3;
                    }
                    case INVALID_SENDER: {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "fallback.mail.validateMailInvalidSender", new Object[0]), (String)null));
                        break block3;
                    }
                    case STARTTLS_REQUIRED: {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "fallback.mail.startTlsRequired", new Object[0]), (String)null));
                        break block3;
                    }
                    case LOGIN_FAILURE_POP3: 
                    case LOGIN_FAILURE_SMTP: {
                        if (settings.getValue(V).contains("@")) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "fallback.mail.validateMailFailureTryNoAt", new Object[]{string.getMessage()}), (String)null));
                            break block3;
                        }
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "fallback.mail.validateMailFailure", new Object[]{string.getMessage()}), (String)null));
                        break block3;
                    }
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "fallback.mail.validateMailFailure", new Object[]{string.getMessage()}), (String)null));
                break;
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "fallback.mail.profile.scope": 
            case "fallback.mail.profile.provider": 
            case "fallback.mail.sendTestEmailTo": {
                return ConfigStructure.SaveState.SAVE;
            }
            case "fallback.mail.smtp.refresh.token": 
            case "fallback.mail.smtp.provider": {
                if (StringFunctions.isEmpty((String)settings.getValue("fallback.mail.smtp.provider"))) {
                    settings.save(P, "");
                    settings.save(Q, "");
                    return ConfigStructure.SaveState.SAVE;
                }
                return ConfigStructure.SaveState.NONE;
            }
            case "fallback.mail.password": {
                settings.save(key, Encryption.encrypt((String)value));
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }
}

