/*
 * Decompiled with CFR 0.152.
 */
package com.inet.embeddedwebsites.server.backup.task;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.embeddedwebsites.EmbeddedWebsitesServerPlugin;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.maintenance.api.backup.tasks.BackupConfigurationKey;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

public class a
implements BackupTask,
BackupConfigurationKey {
    public String getKey() {
        return "embeddedwebsites.general.configuration";
    }

    public String getTitle() {
        return EmbeddedWebsitesServerPlugin.MSG.getMsg("embeddedwebsites.backup.configuration.title", new Object[0]);
    }

    public String getDescription() {
        return EmbeddedWebsitesServerPlugin.MSG.getMsg("embeddedwebsites.backup.configuration.description", new Object[0]);
    }

    public URL getIconURL() {
        return a.class.getResource("/com/inet/embeddedwebsites/structure/embeddedwebsites_32.png");
    }

    public Set<String> getKeysToBackup() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY.getKey());
        return hashSet;
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        progressUpdater.updateProgress(0);
        Configuration configuration = MaintenanceHelper.getCurrentConfiguration();
        String string = configuration.get(EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY.getKey());
        progressUpdater.updateProgress(15);
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty(ConfigKey.BACKUP_DEFINITIONS.getKey(), string);
        }
        progressUpdater.updateProgress(70);
        try (FileOutputStream fileOutputStream = new FileOutputStream(taskPath.resolve("embeddedwebsites.properties").toFile());){
            properties.store(fileOutputStream, null);
        }
        contentInformation.addTaskDetails(this.getKey(), EmbeddedWebsitesServerPlugin.MSG.getMsg("embeddedwebsites.backup.configuration", new Object[0]));
        fileOutputStream = new BackupHelper();
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        fileOutputStream.createZipFromFolderContent(persistence.resolve("images").resolve("embeddedwebsites"), taskPath.resolve("embeddedwebsitesimages.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                progressUpdater.updateProgress(95);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        progressUpdater.updateProgress(0);
        File file = taskPath.resolve("embeddedwebsites.properties").toFile();
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            properties.load(fileInputStream);
        }
        fileInputStream = MaintenanceHelper.getCurrentConfiguration();
        String string = properties.getProperty(ConfigKey.BACKUP_DEFINITIONS.getKey());
        fileInputStream.put(EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY.getKey(), string);
        progressUpdater.updateProgress(60);
        BackupHelper backupHelper = new BackupHelper();
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        Path path = taskPath.resolve("embeddedwebsitesimages.zip");
        PersistenceEntry persistenceEntry = persistence.resolve("images").resolve("embeddedwebsites");
        backupHelper.extractZipIntoFolder(path, persistenceEntry, true, (n, n2) -> progressUpdater.updateProgress(95));
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

