/*
 * Decompiled with CFR 0.152.
 */
package com.inet.embeddedwebsites.structure;

import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.embeddedwebsites.EmbeddedWebsitesModule;
import com.inet.embeddedwebsites.EmbeddedWebsitesServerPlugin;
import com.inet.embeddedwebsites.structure.EmbeddedWebsitesIconConfigProperty;
import com.inet.embeddedwebsites.structure.EmbeddedWebsitesListConfigProperty;
import com.inet.http.PluginServlet;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.DynamicExtensionManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class a
extends AbstractStructureProvider {
    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.system": {
                categories.add(new ConfigCategory(250, "category.embeddedwebsites", this.translate(settings, "category.embeddedwebsites", new Object[0]), "components-embeddedwebsites"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.embeddedwebsites": {
                return ((Object)((Object)this)).getClass().getResource("embeddedwebsites_48.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(Set<ConfigPropertyGroup> configPropertyGroups, String categoryKey, boolean advanced, ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.embeddedwebsites": {
                if (a.isDesigner()) break;
                configPropertyGroups.add(new ConfigPropertyGroup(100, "embeddedwebsites.add"));
            }
        }
    }

    public void addPropertiesTo(Set<ConfigProperty> configProperties, String propertyGroupKey, boolean advanced, ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "embeddedwebsites.add": {
                configProperties.add((ConfigProperty)new EmbeddedWebsitesListConfigProperty(this, settings));
            }
        }
    }

    public void validate(String categoryKey, ArrayList<ConfigValidationMsg> messages, ArrayList<ConfigConditionAction> conditions, ConfigStructureSettings settings) {
        if ("embeddedwebsites.add".equals(categoryKey)) {
            Properties properties = settings.getValues();
            if (properties == null) {
                return;
            }
            Set<Object> set = properties.keySet();
            Pattern pattern = Pattern.compile("[a-zA-Z0-9-_.]*");
            for (Object object : set) {
                String string = (String)object;
                String string2 = (String)properties.get(object);
                switch (string) {
                    case "name": {
                        if (string2.length() != 0) break;
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.noemptyname", new Object[0]), "name"));
                        break;
                    }
                    case "description": {
                        break;
                    }
                    case "path": {
                        List list;
                        Matcher matcher;
                        boolean bl;
                        if (string2.length() == 0) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.noemptypath", new Object[0]), "path"));
                        }
                        if (string2.length() == 1 && string2.lastIndexOf("/") == 0) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.noemptypath", new Object[0]), "path"));
                        }
                        if (string2.lastIndexOf("/") > 0) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.noslashpath", new Object[0]), "path"));
                        }
                        if (!(bl = (matcher = pattern.matcher(string2.startsWith("/") ? string2.substring(1) : string2)).matches())) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.novalidchar", new Object[0]), "path"));
                        }
                        if (!(list = DynamicExtensionManager.getInstance().get(PluginServlet.class)).stream().anyMatch(pluginServlet -> !(pluginServlet instanceof com.inet.embeddedwebsites.a) && pluginServlet.getPathSpec().equalsIgnoreCase(string2))) break;
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.duplicatepath", new Object[0]), "path"));
                        break;
                    }
                    case "color": {
                        if (string2.length() != 0) break;
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.noemptycolor", new Object[0]), "color"));
                        break;
                    }
                    case "targetUrl": {
                        if (string2.length() == 0) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.noemptytarget", new Object[0]), "targetUrl"));
                        }
                        boolean bl = false;
                        bl = Boolean.valueOf((String)properties.get("openTargetUrl"));
                        this.a(messages, settings, string2, 0, bl);
                        break;
                    }
                }
            }
        } else if ("category.embeddedwebsites".equals(categoryKey)) {
            String string = settings.getValue(EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY);
            List list = (List)new Json().fromJson(string, (Type)new JsonParameterizedType(List.class, new Type[]{EmbeddedWebsitesModule.class}), new HashMap());
            HashSet<String> hashSet = new HashSet<String>();
            for (EmbeddedWebsitesModule embeddedWebsitesModule : list) {
                hashSet.add(embeddedWebsitesModule.getPath().toLowerCase());
            }
            if (hashSet.size() != list.size()) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "embeddedwebsites.duplicatepathlocal", new Object[0]), EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY));
            }
        }
    }

    public ConfigStructure.SaveState save(String propKey, String propValue, ConfigStructureSettings settings) {
        if (EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY.getKey().equals(propKey)) {
            List list = (List)new Json().fromJson(propValue, (Type)new JsonParameterizedType(List.class, new Type[]{EmbeddedWebsitesModule.class}), new HashMap());
            PersistenceEntry persistenceEntry2 = Persistence.getInstance().resolve("images/embeddedwebsites");
            if (list.isEmpty()) {
                persistenceEntry2.deleteTree();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (EmbeddedWebsitesModule embeddedWebsitesModule : list) {
                Object object;
                Object object2;
                Object object3;
                if (!StringFunctions.isEmpty((String)embeddedWebsitesModule.getIconPath()) && persistenceEntry2.resolve(embeddedWebsitesModule.getIconPath().substring(1)).exists() && !embeddedWebsitesModule.getIconPath().equalsIgnoreCase(embeddedWebsitesModule.getPath())) {
                    object3 = persistenceEntry2.resolve(embeddedWebsitesModule.getPath().substring(1));
                    object2 = persistenceEntry2.resolve(embeddedWebsitesModule.getIconPath().substring(1));
                    List list2 = object2.getChildren();
                    for (Object object4 : list2) {
                        try {
                            object = object4.getInputStream();
                            try {
                                OutputStream outputStream = object3.resolve(object4.getName()).getOutputStream();
                                try {
                                    ((InputStream)object).transferTo(outputStream);
                                }
                                finally {
                                    if (outputStream == null) continue;
                                    outputStream.close();
                                }
                            }
                            finally {
                                if (object == null) continue;
                                ((InputStream)object).close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    object2.deleteTree();
                }
                if (embeddedWebsitesModule.getPath().lastIndexOf("/") == -1) {
                    embeddedWebsitesModule.setPath("/" + embeddedWebsitesModule.getPath());
                }
                if (!StringFunctions.isEmpty((String)embeddedWebsitesModule.getEmbeddedWebsitesIcons()) && !"{}".equalsIgnoreCase(embeddedWebsitesModule.getEmbeddedWebsitesIcons())) {
                    EmbeddedWebsitesIconConfigProperty.storeIcons(embeddedWebsitesModule.getEmbeddedWebsitesIcons(), embeddedWebsitesModule.getPath(), propValue);
                }
                if (!StringFunctions.isEmpty((String)embeddedWebsitesModule.getEmbeddedWebsitesIcons()) && !"{}".equalsIgnoreCase(embeddedWebsitesModule.getEmbeddedWebsitesIcons())) {
                    object3 = embeddedWebsitesModule.getEmbeddedWebsitesIcons();
                    object2 = (HashMap)new Json().fromJson((String)object3, new HashMap().getClass());
                    boolean bl = false;
                    for (Object object4 : ((HashMap)object2).keySet()) {
                        object = (Map)((HashMap)object2).get(object4);
                        if (object.get("data") == null) continue;
                        bl = true;
                    }
                    if (bl) {
                        embeddedWebsitesModule.setIconURL(null);
                    }
                }
                if (!embeddedWebsitesModule.getIconPath().equalsIgnoreCase(embeddedWebsitesModule.getPath())) {
                    embeddedWebsitesModule.setIconPath(embeddedWebsitesModule.getPath());
                }
                arrayList.add(((String)(object3 = embeddedWebsitesModule.getPath())).startsWith("/") ? ((String)object3).substring(1) : object3);
            }
            propValue = new Json().toJson((Object)list);
            settings.save(EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY, propValue);
            persistenceEntry2.getChildren().stream().filter(persistenceEntry -> !arrayList.contains(persistenceEntry.getName())).forEach(persistenceEntry -> persistenceEntry.deleteTree());
            return ConfigStructure.SaveState.SAVE;
        }
        return ConfigStructure.SaveState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The URL is defined by an administrator and checked for its response right here.")
    private void a(ArrayList<ConfigValidationMsg> arrayList, ConfigStructureSettings configStructureSettings, String string, int n, boolean bl) {
        if (n > 10) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "embeddedwebsites.noembeddingtomanyredirects", new Object[0]), "targetUrl"));
            return;
        }
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.connect();
                if (bl) return;
                String string2 = httpURLConnection.getHeaderField("x-frame-options");
                if (string2 != null) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "embeddedwebsites.noembeddingtargetallowed", new Object[0]), "targetUrl"));
                    return;
                }
                int n2 = httpURLConnection.getResponseCode();
                switch (n2) {
                    case 301: 
                    case 302: 
                    case 307: {
                        String string3 = httpURLConnection.getHeaderField("location");
                        if (string3 == null || string3.isEmpty()) return;
                        this.a(arrayList, configStructureSettings, string3, ++n, bl);
                        return;
                    }
                    case 200: 
                    case 401: 
                    case 403: 
                    case 404: 
                    case 405: {
                        return;
                    }
                    default: {
                        arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "embeddedwebsites.noembeddingtargeturlerror", new Object[]{n2}), "targetUrl"));
                        return;
                    }
                }
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(configStructureSettings, "embeddedwebsites.novalidtarget", new Object[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)exception)}), "targetUrl"));
        }
    }
}

