/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.details;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.feature.ShareData;
import com.inet.drive.api.feature.c;
import com.inet.drive.webgui.server.a;
import com.inet.drive.webgui.server.details.DetailsPanelExtension;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ShareDetailsExtension
implements DetailsPanelExtension {
    @Nonnull
    public String getExtensionName() {
        return "detailspanel.share";
    }

    @Override
    public String getDisplayName() {
        return DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.share.displayname", new Object[0]);
    }

    @Override
    public String getDescription() {
        return DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.share.description", new Object[0]);
    }

    @Override
    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/drive/webgui/client/details/shareextension.html");
    }

    @Override
    public boolean appliesTo(@Nonnull DriveEntry entry) {
        try {
            if (!entry.hasFeature(c.class) || !a.du().getPermissionChecker().hasPermission(entry.getID(), false, "EDITOR")) {
                return false;
            }
            @Nullable c c2 = entry.getFeature(c.class);
            if (c2 == null) {
                return false;
            }
            ShareData shareData = c2.w();
            if (shareData != null && shareData.hasPermissions()) {
                return true;
            }
            return SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_SHARE_LINK_PERMISSION) && !c2.y().isEmpty();
        }
        catch (RuntimeException runtimeException) {
            DrivePlugin.LOGGER.debug((Object)runtimeException);
            return false;
        }
    }

    public List<ShareListEntry> a(@Nonnull DriveEntry driveEntry, @Nonnull List<String> list, @Nonnull DetailsPanelExtension.a a2) {
        int n2;
        Object object;
        ArrayList<ShareListEntry> arrayList = new ArrayList<ShareListEntry>();
        if (!driveEntry.hasFeature(c.class) || !a.du().getPermissionChecker().hasPermission(driveEntry.getID(), false, "EDITOR")) {
            return arrayList;
        }
        @Nullable c c2 = driveEntry.getFeature(c.class);
        @Nullable GUID gUID2 = UserManager.getInstance().getCurrentUserAccountID();
        if (c2 == null || gUID2 == null) {
            return arrayList;
        }
        ShareData shareData = c2.w();
        Object object2 = "";
        Object object3 = "";
        boolean bl = false;
        if (shareData != null) {
            Map<@Nonnull GUID, Set<String>> map = shareData.getPermissions(true);
            object = shareData.getPermissions(false);
            String string = DrivePlugin.MSG_SERVER.getMsg("permissions.custom.groups", new Object[]{map.size()});
            String string2 = DrivePlugin.MSG_SERVER.getMsg("permissions.custom.users", new Object[]{object.size()});
            object3 = !map.isEmpty() && !object.isEmpty() ? DrivePlugin.MSG_SERVER.getMsg("share.label.dual", new Object[]{string, string2}) : DrivePlugin.MSG_SERVER.getMsg("share.label.single", new Object[]{map.isEmpty() ? string2 : string});
            if (SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!map.isEmpty()) {
                    stringBuilder.append(DrivePlugin.MSG_SERVER.getMsg("share.label.groups", new Object[0])).append(": ");
                    stringBuilder.append(map.keySet().stream().map(gUID -> {
                        UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
                        return userGroupInfo != null ? UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)userGroupInfo) : gUID.toString();
                    }).collect(Collectors.joining(", ")));
                    bl = true;
                }
                if (!object.isEmpty()) {
                    if (!map.isEmpty()) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(DrivePlugin.MSG_SERVER.getMsg("share.label.users", new Object[0])).append(": ");
                    stringBuilder.append(object.keySet().stream().map(gUID -> {
                        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
                        return userAccount != null ? userAccount.getDisplayName() : gUID.toString();
                    }).collect(Collectors.joining(", ")));
                    bl = true;
                }
                object2 = stringBuilder.toString();
            } else {
                object2 = object3;
            }
        }
        if (SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_SHARE_LINK_PERMISSION) && (n2 = c2.y().size()) > 0) {
            object = DrivePlugin.MSG_SERVER.getMsg("share.label.links", new Object[]{n2});
            object3 = (String)object3 + (((String)object3).isBlank() ? "" : ", ") + (String)object;
            object2 = (String)object2 + (((String)object2).isBlank() ? "" : ", ") + (String)object;
            bl = true;
        }
        arrayList.add(new ShareListEntry(driveEntry.getID(), (String)object3, (String)object2, bl));
        return arrayList;
    }

    public /* synthetic */ Object getEntryData(@Nonnull DriveEntry driveEntry, @Nonnull List list, @Nonnull DetailsPanelExtension.a a2) {
        return this.a(driveEntry, list, a2);
    }

    @JsonData
    public static class ShareListEntry {
        @Nonnull
        private String key;
        @Nonnull
        private String label;
        @Nonnull
        private String value;
        private boolean canEdit = false;

        public ShareListEntry(@Nonnull String key, @Nonnull String label, @Nonnull String value, boolean canEdit) {
            this.key = key;
            this.label = label;
            this.value = value;
            this.canEdit = canEdit;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        @Nonnull
        public String getLabel() {
            return this.label;
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }
    }
}

