/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.data;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.Collator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class MountDescriptionData
implements Comparable<MountDescriptionData> {
    private static Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
    private GUID id;
    private String name;
    private String provider;
    private String providerName;
    private boolean isUserMount;
    private String token;
    private boolean isOAuth;
    private String details;
    private boolean isValid = true;
    private int mounts;
    private Map<String, String> config = new HashMap<String, String>();
    private String configDirective;

    private MountDescriptionData() {
    }

    private MountDescriptionData(GUID id, String name, String details, String provider, String providerName, boolean isUserMount, boolean isOAuth) {
        this.details = details;
        this.isOAuth = isOAuth;
        this.id = id;
        if (name == null || name.isBlank()) {
            name = DrivePlugin.MSG_CLIENT.getMsg("drive.gui.mount.name.none", new Object[0]);
        }
        this.name = name;
        this.provider = provider;
        this.providerName = providerName;
        this.isUserMount = isUserMount;
    }

    public MountDescriptionData(String name, String details, String provider, String providerName, boolean isUserMount, boolean isOAuth) {
        this(null, name, details, provider, providerName, isUserMount, isOAuth);
    }

    public MountDescriptionData(MountDescription source, boolean isOAuth) {
        this(source.getID(), source.getName(), source.getName(), source.getProvider(), source.getProviderName(), Objects.equals(source.getUserID(), UserManager.getInstance().getCurrentUserAccountID()), isOAuth);
        this.mounts = MountManager.getInstance().getMountsIDForDescriptionID(source.getID()).size();
    }

    public GUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    public boolean isOAuth() {
        return this.isOAuth;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setInvalid(String reason) {
        this.isValid = false;
        this.details = reason;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean isUserMount() {
        return this.isUserMount;
    }

    public Map<String, String> getMountConfig() {
        String string = this.getToken();
        if (this.isOAuth() && string != null && !string.isBlank()) {
            this.config.put("refreshToken", string);
        }
        return this.config;
    }

    public void setMountConfig(@Nonnull Map<String, String> config) {
        this.config = new HashMap<String, String>(config);
    }

    public void setConfigDirective(@Nullable String configDirective) {
        this.configDirective = configDirective;
    }

    @Override
    public int compareTo(@Nonnull MountDescriptionData o2) {
        int n2 = collator.compare(this.getName(), o2.getName());
        if (n2 != 0) {
            return n2;
        }
        n2 = this.getName().compareTo(o2.getName());
        if (n2 != 0) {
            return n2;
        }
        return this.getId().compareTo(o2.getId());
    }

    static {
        collator.setStrength(0);
    }
}

