/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.drive.api.feature.Capabilities;
import com.inet.drive.server.utils.b;
import com.inet.drive.webgui.server.data.CapabilitiesData;
import com.inet.drive.webgui.server.data.DriveGuiEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ListFolderResponse {
    @Nonnull
    private List<DriveGuiEntry> entries;
    private boolean hasMore;
    private boolean replace;
    @Nonnull
    private CapabilitiesData capabilities;
    private boolean canLink;
    private boolean canReload;
    @JsonExcludeNull
    private String passwordRequired;
    private String parentID;
    private String actualParentID;
    private int total = -1;
    private boolean totalTruncated = false;
    private List<Integer> activeExtensions;
    private String errorMessage;

    public ListFolderResponse(@Nonnull List<DriveGuiEntry> entries, String requestedID, String actualParentID, boolean hasMore, int totalEntries, @Nullable Capabilities capabilities, boolean canLink, boolean canReload, boolean replace, List<Integer> activeExtensions) {
        this.entries = entries;
        this.parentID = requestedID;
        this.actualParentID = actualParentID;
        this.hasMore = hasMore;
        this.total = totalEntries;
        this.capabilities = new CapabilitiesData(capabilities != null ? capabilities : new b(false));
        this.canLink = canLink;
        this.canReload = canReload;
        this.replace = replace;
        this.activeExtensions = activeExtensions;
    }

    public ListFolderResponse(String errorMessage, String parentID, boolean passwordException) {
        this.errorMessage = errorMessage;
        this.parentID = parentID;
        this.entries = new ArrayList<DriveGuiEntry>();
        this.activeExtensions = new ArrayList<Integer>();
        this.replace = true;
        this.capabilities = new CapabilitiesData(new b(false));
        if (passwordException) {
            this.passwordRequired = "true";
        }
    }

    public ListFolderResponse(String errorMessage, String parentID) {
        this.errorMessage = errorMessage;
        this.parentID = parentID;
        this.entries = new ArrayList<DriveGuiEntry>();
        this.activeExtensions = new ArrayList<Integer>();
        this.replace = true;
        this.capabilities = new CapabilitiesData(new b(false));
    }

    public void setTotalTruncated(boolean totalTruncated) {
        this.totalTruncated = totalTruncated;
    }

    public List<DriveGuiEntry> getEntries() {
        return this.entries;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isCanLink() {
        return this.canLink;
    }

    public boolean isCanReload() {
        return this.canReload;
    }

    @Nonnull
    public String toString() {
        return "ParentID: " + this.parentID + ", entries: " + this.entries.size() + (this.replace ? " replace" : "") + (this.hasMore ? " hasMore" : "") + ", extensions: " + this.activeExtensions.size();
    }
}

