/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.permissions;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.drive.api.DrivePermissionType;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class PermissionsData {
    private String id;
    private boolean inherit;
    private List<String> publicPermissions;
    private List<PermissionsEntry> groups;
    private List<PermissionsEntry> users;
    private boolean ignoreWarnings = false;

    protected PermissionsData() {
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public List<PermissionsEntry> getUserPermissions() {
        return this.users;
    }

    @Nullable
    public List<PermissionsEntry> getGroupPermissions() {
        return this.groups;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public List<String> getPublicPermissions() {
        return this.publicPermissions;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public PermissionsData setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
        return this;
    }

    public PermissionsData(@Nonnull String entryID, @Nonnull List<PermissionsEntry> groups, @Nonnull List<PermissionsEntry> users, boolean inherited) {
        this.id = entryID;
        this.groups = groups;
        this.users = users;
        this.inherit = inherited;
    }

    public PermissionsData(@Nonnull String entryID, List<String> publicPermissions, boolean inherited) {
        this(entryID, new ArrayList<PermissionsEntry>(), new ArrayList<PermissionsEntry>(), inherited);
        this.publicPermissions = publicPermissions;
    }

    @JsonData
    public static class PermissionsEntry
    extends LocalizedKey {
        @Nullable
        private List<String> permissions;
        private boolean owner = false;
        private boolean editable = true;

        private PermissionsEntry() {
            super("", "");
        }

        public static PermissionsEntry forOwner(@Nonnull GUID id, @Nonnull String displayName) {
            return new PermissionsEntry(id, displayName, null, true);
        }

        public static PermissionsEntry forOwnerInLink(@Nonnull GUID id, @Nonnull String displayName, @Nonnull List<String> permissions) {
            return new PermissionsEntry(id, displayName, permissions, true);
        }

        public static PermissionsEntry forUserOrGroup(@Nonnull GUID id, @Nonnull String displayName, @Nonnull List<String> permissions) {
            return new PermissionsEntry(id, displayName, permissions, false);
        }

        private PermissionsEntry(@Nonnull GUID id, @Nonnull String displayName, @Nullable List<String> permissions, boolean isOwner) {
            super(id.toString(), displayName);
            this.permissions = permissions != null ? permissions : ServerPluginManager.getInstance().get(DrivePermissionType.class).stream().map(dpt -> dpt.getPermissionTypeName()).collect(Collectors.toList());
            this.owner = isOwner;
        }

        @Nonnull
        public List<String> getPermissions() {
            ArrayList arrayList = this.permissions;
            return arrayList != null ? arrayList : new ArrayList();
        }

        public boolean isOwner() {
            return this.owner;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }
    }
}

