/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.cache.MemoryStoreMap;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.LockException;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.ShareAnonymLink;
import com.inet.drive.api.feature.ShareData;
import com.inet.drive.api.permission.PermissionChecker;
import com.inet.drive.server.persistence.r;
import com.inet.drive.server.sharing.ShareManager;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class m
implements DriveObserver,
PermissionChecker {
    private final Drive as;
    private static final ThreadLocal<String> eV = new ThreadLocal();
    private MemoryStoreMap<String, a> eW = new MemoryStoreMap(30000, true);

    public static void C(@Nullable String string) {
        if (string == null) {
            eV.remove();
        } else {
            if (eV.get() != null) {
                DrivePlugin.LOGGER.debug((Object)("Thread contain already a share id " + eV.get()));
            }
            eV.set(string);
        }
    }

    @Nullable
    public static String bq() {
        return eV.get();
    }

    public m(Drive drive) {
        this.as = drive;
    }

    @Override
    public boolean hasPermission(@Nonnull String driveEntryID, boolean throwException, String ... permissionTyps) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            return this.a((String)driveEntryID, throwException, permissionTyps);
        }
        if (m.a(userAccount)) {
            return true;
        }
        Boolean bl = this.a(userAccount, (String)driveEntryID, throwException, permissionTyps);
        if (bl != null) {
            return bl;
        }
        if ("SharedWithMe".equals(driveEntryID)) {
            for (String string : permissionTyps) {
                if (!"EDITOR".equals(string)) continue;
                return this.a((String)driveEntryID, throwException, permissionTyps);
            }
            for (String string : permissionTyps) {
                if (!"VIEWER".equals(string)) continue;
                return true;
            }
            return this.a((String)driveEntryID, throwException, permissionTyps);
        }
        String string = eV.get();
        if (string != null && !DriveIDUtils.isShareID((String)driveEntryID)) {
            driveEntryID = !((String)driveEntryID).equals(ShareManager.bU().I(string)) ? string + "_" + (String)driveEntryID : string;
        }
        if (DriveIDUtils.getSharedRootID((String)driveEntryID) != null) {
            Map<String, List<String>> map;
            String string2 = "s_" + DriveIDUtils.getSharedRootID((String)driveEntryID);
            String string3 = ShareManager.bU().I(string2);
            if (string3 == null) {
                return this.a((String)driveEntryID, throwException, permissionTyps);
            }
            a a2 = this.D(string3);
            String string4 = DriveIDUtils.getProviderID((String)driveEntryID);
            if (this.b(userAccount, string4 == null ? string3 : string4, false, permissionTyps)) {
                return true;
            }
            if (string4 != null) {
                map = this.D(string4);
                while (((a)((Object)map)).bu() != null) {
                    if (((a)((Object)map)).br()) {
                        return this.a((String)driveEntryID, throwException, permissionTyps);
                    }
                    string4 = ((a)((Object)map)).bu();
                    if (string3.equals(string4)) break;
                    map = this.D(string4);
                }
                if (((a)((Object)map)).bu() == null) {
                    return this.a((String)driveEntryID, throwException, permissionTyps);
                }
            }
            if (a2.w() != null && a2.w().getId().equals(string2)) {
                map = a2.w().getPermissions(false);
                for (String string5 : permissionTyps) {
                    if (!this.b(userAccount.getID(), (Map<GUID, Set<String>>)map, string5)) continue;
                    return true;
                }
                Map<GUID, Set<String>> list = a2.w().getPermissions(true);
                Set set = UserGroupManager.getInstance().getGroupsForUser(userAccount.getID());
                for (String string6 : permissionTyps) {
                    for (UserGroupInfo userGroupInfo : set) {
                        if (!this.b(userGroupInfo.getID(), list, string6)) continue;
                        return true;
                    }
                }
            } else {
                map = a2.bz();
                List string9 = (List)map.get(string2);
                if (string9 == null || string9.isEmpty()) {
                    return this.a((String)driveEntryID, throwException, permissionTyps);
                }
                for (String string7 : permissionTyps) {
                    if (!string9.contains(string7)) continue;
                    return true;
                }
            }
            return this.a((String)driveEntryID, throwException, permissionTyps);
        }
        a a3 = this.D((String)driveEntryID);
        String string8 = a3.getLinkID();
        if (string8 == null) {
            if (!this.b(userAccount, (String)driveEntryID, throwException, permissionTyps)) {
                return this.a((String)driveEntryID, throwException, permissionTyps);
            }
        } else {
            if (!this.b(userAccount, string8, throwException, permissionTyps)) {
                return this.a((String)driveEntryID, throwException, permissionTyps);
            }
            GUID gUID = a3.bt();
            try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)gUID);){
                UserAccount userAccount2 = UserManager.getInstance().getCurrentUserAccount();
                String string9 = a3.bv();
                if (!(string9 == null || userAccount2 != null && this.b(userAccount2, string9, throwException, permissionTyps))) {
                    boolean bl2 = this.a(string9, throwException, permissionTyps);
                    return bl2;
                }
            }
        }
        return true;
    }

    private Boolean a(UserAccount userAccount, String string, boolean bl, String ... stringArray) {
        a a2 = this.D(string);
        if (a2.bw()) {
            if (userAccount.getID().equals((Object)a2.getOwner())) {
                return true;
            }
            return this.a(string, bl, stringArray);
        }
        if (a2.bs() && userAccount.getAccountType() == UserAccountType.Guest && !((Boolean)r.fA.get()).booleanValue()) {
            return this.a(string, bl, stringArray);
        }
        return !a2.bs() && SystemPermissionChecker.isAdministrator() ? Boolean.TRUE : null;
    }

    public static boolean a(@Nullable UserAccount userAccount) {
        if (userAccount == null) {
            return false;
        }
        return userAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID);
    }

    public boolean b(UserAccount userAccount, String string, boolean bl, String ... stringArray) {
        if (m.a(userAccount)) {
            return true;
        }
        Boolean bl2 = this.a(userAccount, string, bl, stringArray);
        if (bl2 != null) {
            return bl2;
        }
        if (stringArray != null) {
            boolean bl3 = true;
            for (String string2 : stringArray) {
                if (string2.equals("VIEWER") || string2.equals("EDITOR")) continue;
                bl3 = false;
                break;
            }
            a a2 = this.D(string);
            if (bl3 && userAccount.getID().equals((Object)a2.getOwner())) {
                return true;
            }
            Set set = UserGroupManager.getInstance().getGroupsForUser(userAccount.getID());
            for (String string3 : stringArray) {
                Boolean bl4 = this.b(string, userAccount.getID(), string3);
                if (bl4 == Boolean.TRUE) {
                    return true;
                }
                for (UserGroupInfo userGroupInfo : set) {
                    Boolean bl5 = this.a(string, userGroupInfo.getID(), string3);
                    if (bl5 != Boolean.TRUE) continue;
                    return true;
                }
            }
        }
        return this.a(string, bl, stringArray);
    }

    public boolean a(String string, boolean bl, String ... stringArray) {
        if (bl) {
            Object object = "";
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            object = userAccount == null ? (String)object + DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.nouser", new Object[0]) : (String)object + DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.user", new Object[]{userAccount.getDisplayName(), userAccount.getID()});
            String string2 = eV.get();
            if (string2 != null) {
                object = (String)object + "\nAccess over " + string2 + "\n";
            }
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                DriveEntry driveEntry = this.as.resolve(string);
                object = driveEntry == null ? (String)object + " " + DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.id", new Object[]{string}) : (String)object + " " + DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.path", new Object[]{driveEntry.getPath()});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied", new Object[]{Arrays.toString(stringArray) + (String)object}));
        }
        return false;
    }

    private Boolean a(String string, GUID gUID, String string2) {
        return this.a(string, gUID, true, string2);
    }

    private Boolean b(String string, GUID gUID, String string2) {
        return this.a(string, gUID, false, string2);
    }

    private Boolean a(String string, GUID gUID, boolean bl, String string2) {
        a a2 = this.D(string);
        if (!a2.br()) {
            String string3 = a2.bu();
            if (string3 == null) {
                return null;
            }
            return this.a(string3, gUID, bl, string2);
        }
        return this.a(gUID, bl ? a2.by() : a2.bx(), string2);
    }

    private boolean a(GUID gUID, Map<GUID, Map<String, Boolean>> map, String string) {
        Map<String, Boolean> map2 = map.get(gUID);
        if (map2 == null) {
            return Boolean.FALSE;
        }
        Boolean bl = map2.get(string);
        return bl != null && bl != false;
    }

    private boolean b(GUID gUID, Map<GUID, Set<String>> map, String string) {
        Set<String> set = map.get(gUID);
        if (set != null && set.contains(string)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Nonnull
    private synchronized a D(String string) {
        a a2 = (a)this.eW.get((Object)string);
        if (a2 == null) {
            a2 = new a(string);
            this.eW.put((Object)string, (Object)a2);
        }
        return a2;
    }

    private synchronized void E(String string) {
        this.eW.remove((Object)string);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean synchronizedEvent() {
        return true;
    }

    @Override
    public <T> void changed(@Nonnull DriveObserver.EventType<T> type, @Nonnull T eventData) {
        if (type == DriveObserver.EventType.PERMISSION) {
            this.E(((DriveEntry)eventData).getID());
        } else if (type == DriveObserver.EventType.MODIFIED) {
            DriveObserver.EventType.MetaDataChange metaDataChange = (DriveObserver.EventType.MetaDataChange)eventData;
            if (metaDataChange.getMetaKey() == MetaData.CREATOR_ID || metaDataChange.getMetaKey() == MetaData.HOMEFOLDER) {
                this.E(metaDataChange.getID());
            }
        } else if (type == DriveObserver.EventType.SHARE) {
            DriveObserver.EventType.a a2 = (DriveObserver.EventType.a)eventData;
            this.E(a2.getEntry().getID());
        }
    }

    private class a {
        private AtomicBoolean eX = new AtomicBoolean(true);
        private String eY;
        private final String driveEntryID;
        private GUID owner;
        private boolean eZ = true;
        private String cv;
        private GUID fa;
        private String fb;
        private Map<GUID, Map<String, Boolean>> fc = new HashMap<GUID, Map<String, Boolean>>();
        private Map<GUID, Map<String, Boolean>> fd = new HashMap<GUID, Map<String, Boolean>>();
        private Map<String, List<String>> fe = new HashMap<String, List<String>>();
        private ShareData ff;
        private volatile boolean fg;

        private a(String string) {
            this.driveEntryID = string;
        }

        public boolean br() {
            return this.fg;
        }

        public boolean isExpired() {
            return this.eX.get();
        }

        public boolean bs() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.eZ;
        }

        @Nullable
        public String getLinkID() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.cv;
        }

        public GUID bt() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.fa;
        }

        public String bu() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.eY;
        }

        public String bv() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.fb;
        }

        public GUID getOwner() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.owner;
        }

        public boolean bw() {
            if (this.bu() != null) {
                return m.this.D(this.bu()).bw();
            }
            return DriveIDUtils.getMountRootID(this.driveEntryID) != null;
        }

        public Map<GUID, Map<String, Boolean>> bx() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.fc;
        }

        public Map<GUID, Map<String, Boolean>> by() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.fd;
        }

        @Nonnull
        public Map<String, List<String>> bz() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.fe;
        }

        @Nullable
        public ShareData w() {
            if (this.isExpired()) {
                this.bA();
            }
            return this.ff;
        }

        private void bA() {
            if (this.isExpired()) {
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    DriveEntry driveEntry = m.this.as.resolve(this.driveEntryID);
                    if (driveEntry == null) {
                        this.bB();
                        return;
                    }
                    driveEntry.runFeature(DriveEntry.META_DATA, metaData -> {
                        this.owner = metaData.getMetaData(MetaData.CREATOR_ID);
                        this.eY = metaData.getMetaData(MetaData.PARENT_ID);
                        this.eZ = metaData.getMetaData(MetaData.HOMEFOLDER) != null;
                    }, this::bB);
                    driveEntry.runFeature(DriveEntry.PERMISSIONS, permissions -> {
                        this.fc = permissions.getPermissions(false);
                        this.fd = permissions.getPermissions(true);
                        this.fg = !this.fc.isEmpty() || !this.fd.isEmpty();
                    }, this::bB);
                    driveEntry.runFeature(DriveEntry.SHARE, c2 -> {
                        this.ff = c2.w();
                        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                        List<ShareAnonymLink> list = c2.y();
                        for (ShareAnonymLink shareAnonymLink : list) {
                            if (shareAnonymLink.isExpired()) continue;
                            hashMap.put(shareAnonymLink.getId(), shareAnonymLink.getPermissions());
                        }
                        this.fe = hashMap;
                    });
                    driveEntry.runFeature(DriveEntry.MOUNT, mount -> {
                        this.cv = mount.getLinkID();
                        this.fa = mount.getDescription().getUserID();
                        this.fb = "PERSISTENCE_PROVIDER".equals(mount.getDescription().getProvider()) && !mount.isLinkRoot() ? mount.getOriginID() : null;
                    });
                    this.eX.set(false);
                }
                catch (LockException lockException) {
                    this.bB();
                }
                catch (Throwable throwable) {
                    DrivePlugin.LOGGER.warn("Couldn't not read the permission data for " + this.driveEntryID, (Object)throwable);
                    this.bB();
                }
            }
        }

        private void bB() {
            this.fg = false;
            this.eZ = true;
            this.fc = new HashMap<GUID, Map<String, Boolean>>();
            this.fd = new HashMap<GUID, Map<String, Boolean>>();
        }

        public String toString() {
            return "PermissionDriveEntry{isExpired=" + String.valueOf(this.eX) + ", parentDriveEntryID='" + this.eY + "', driveEntryID='" + this.driveEntryID + "', owner=" + String.valueOf(this.owner) + ", isHome=" + this.eZ + ", userIDToPermissions=" + this.fc.size() + ", groupIDToPermissions=" + this.fd.size() + ", hasPermisson=" + this.fg + "}";
        }
    }
}

