/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.handler;

import com.inet.cache.internal.MemoryObserver;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.api.metadata.NumberMetaKey;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.image.PreviewGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class a
implements DriveFileTypeHandler {
    public static final MetaKey<Number> cn = new NumberMetaKey("WIDTH", "px", true, true, false);
    public static final MetaKey<Number> co = new NumberMetaKey("HEIGHT", "px", true, true, false);
    private static final Set<String> cp = new HashSet<String>(Arrays.asList("ico", "webp", "jpg", "bmp", "webp", "jpx", "png", "gif", "jpeg"));
    private static final Set<String> cq = new HashSet<String>();
    private static final List<MetaKey<?>> cr = new ArrayList();

    @Override
    @Nonnull
    public List<MetaKey<?>> getAdditionalMetaKeyForFiletype() {
        return cr;
    }

    @Nonnull
    public String getExtensionName() {
        return "handler.images";
    }

    @Override
    public boolean acceptFileTyp(@Nonnull DriveEntry entry) {
        String string = DriveFileTypeHandler.getSuffix(entry);
        if (!cp.contains(string)) {
            return false;
        }
        if (!cq.contains(string)) {
            return true;
        }
        Number number = entry.getFeature(DriveEntry.META_DATA).getMetaData(MetaData.SIZE);
        if (number == null) {
            return true;
        }
        return number.longValue() <= 100000L;
    }

    @Override
    @Nonnull
    public DriveFileTypeHandler.FileTypeDriveEntryHandler getFileTypeHandler(final @Nonnull PersistenceEntry contentEntry, final @Nonnull DriveEntry entry) {
        return new DriveFileTypeHandler.FileTypeDriveEntryHandler(){

            @Override
            @Nullable
            public String getTextForSearch() {
                return null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Map<MetaKey<?>, Object> getMetaData() {
                if (!a.this.acceptFileTyp(entry, DriveFileTypeHandler.FEATURE.metaData)) {
                    return null;
                }
                try (InputStream inputStream = contentEntry.getInputStream();){
                    MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(memoryCacheImageInputStream);
                    if (!iterator.hasNext()) return null;
                    ImageReader imageReader = iterator.next();
                    imageReader.setInput(memoryCacheImageInputStream);
                    HashMap hashMap2 = new HashMap();
                    hashMap2.put(MetaData.FILETYPE, imageReader.getFormatName().toLowerCase());
                    hashMap2.put(cn, imageReader.getWidth(0));
                    hashMap2.put(co, imageReader.getHeight(0));
                    HashMap hashMap = hashMap2;
                    return hashMap;
                }
                catch (DriveIOException | IOException exception) {
                    DrivePlugin.LOGGER.debug((Object)exception);
                }
                return null;
            }
        };
    }

    @Override
    public boolean thumbnailNeedCache(@Nonnull DriveEntry entry) {
        String string = DriveFileTypeHandler.getSuffix(entry);
        if (cq.contains(string)) {
            return false;
        }
        Number number = entry.getFeature(DriveEntry.META_DATA).getMetaData(MetaData.SIZE);
        if (number == null) {
            return true;
        }
        return number.longValue() > 100000L;
    }

    @Override
    public PreviewGenerator.ImagePreview getThumbnail(@Nonnull DriveEntry entry, @Nonnull Thumbnail.Size size, boolean requireExactSize) throws IOException {
        String string = DriveFileTypeHandler.getSuffix(entry);
        if (!cp.contains(string) || cq.contains(string)) {
            return null;
        }
        if (!entry.hasFeature(Content.class)) {
            return null;
        }
        Content content = entry.getFeature(Content.class);
        if (content.getSize() == 0L) {
            return null;
        }
        MemoryObserver.checkMemory();
        return PreviewGenerator.generatePreviewImage(() -> content.getInputStream(), (String)string, (int)size.getSize());
    }

    @Override
    public InputStream getAdhocThumbnail(@Nonnull DriveEntry entry, @Nonnull Thumbnail.Size size, boolean requireExactSize) {
        if (!this.thumbnailNeedCache(entry) && entry.hasFeature(Content.class)) {
            return entry.getFeature(Content.class).getInputStream();
        }
        return null;
    }

    @Override
    @Nullable
    public Object getFileSpecificDiff(@Nonnull DriveEntry previous, @Nonnull DriveEntry after) {
        return null;
    }

    static {
        cr.add(cn);
        cr.add(co);
        for (String string : cp) {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
            if (iterator != null && iterator.hasNext()) continue;
            cq.add(string);
        }
        cp.addAll(Arrays.asList(ImageIO.getReaderFileSuffixes()));
    }
}

