/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.mount;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.mount.MountDescription;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.NamedExtension;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface MountProvider<T extends DriveEntry>
extends NamedExtension {
    public T resolve(@Nonnull DriveEntry var1, @Nonnull MountDescription var2, @Nonnull String var3, @Nonnull String var4);

    @Nullable
    default public String getConfigurationUIDirective() {
        return null;
    }

    @Nonnull
    public String getDisplayName();

    @Nullable
    public URL getIconUrl();

    public void clearCache(@Nonnull MountDescription var1);

    @Nullable
    default public Permission[] getRequiredPermissions() {
        return null;
    }

    default public boolean userHasPermission(@Nonnull GUID userID) {
        @Nullable Permission[] permissionArray = this.getRequiredPermissions();
        if (permissionArray == null || permissionArray.length == 0) {
            return true;
        }
        return SystemPermissionChecker.hasAnyPermission((GUID)userID, (Permission[])permissionArray);
    }
}

