'use strict';clearreportsApp.service("actionservice",function($rootScope,driveModel){this.SHOW_FOR={SINGLE_ENTRY:"single",MULTI_SELECTION:"multi",ANY:"any"};this.ACTION_TYPE={FIXED:"fixed",MIME:"mime",GENERIC:"generic",MISC:"misc"};var $this=this;var actionsMap=new Map;var actionGroupsSingle={};actionGroupsSingle[this.ACTION_TYPE.FIXED]=[];actionGroupsSingle[this.ACTION_TYPE.MIME]=[];actionGroupsSingle[this.ACTION_TYPE.GENERIC]=[];actionGroupsSingle[this.ACTION_TYPE.MISC]=[];var actionGroupsMulti=
{};actionGroupsMulti[this.ACTION_TYPE.FIXED]=[];actionGroupsMulti[this.ACTION_TYPE.MIME]=[];actionGroupsMulti[this.ACTION_TYPE.GENERIC]=[];actionGroupsMulti[this.ACTION_TYPE.MISC]=[];this.getActionMap=function(){return actionsMap};this.registerAction=function(actionModel,actionType){actionModel.type=actionType;actionsMap.set(actionModel.key,actionModel);if(actionType==undefined)actionType=this.ACTION_TYPE.FIXED;if(actionModel.single){actionGroupsSingle[actionType].push(actionModel);if(actionModel.single.drilldown!=
undefined)for(let i=0;i<actionModel.single.drilldown.length;i++){let ddAction=actionModel.single.drilldown[i];actionsMap.set(ddAction.key,ddAction)}}if(actionModel.multi){actionGroupsMulti[actionType].push(actionModel);if(actionModel.multi.drilldown!=undefined)for(let i=0;i<actionModel.multi.drilldown.length;i++){let ddAction=actionModel.multi.drilldown[i];actionsMap.set(ddAction.key,ddAction)}}};this.getAction=function(actionKey){return actionsMap.get(actionKey)};this.execute=function(actionKey,
entry,multiSelection,event){var action=actionsMap.get(actionKey);if(action){if(entry&&entry.passwordRequired){driveModel.password.required=true;driveModel.password.refID=entry.id;driveModel.password.message="Password required for "+entry.name;return}if(event)event.preventDefault();var actionType=action.single;if(multiSelection){let entries=driveModel.getSelectedEntries();for(let i=0;i<entries.length;i++){let singleEntry=entries[i];if(singleEntry.passwordRequired){driveModel.password.required=true;
driveModel.password.refID=entry.id;driveModel.password.message="Password required for "+entry.name;return}}actionType=action.multi}if(!actionType||actionType.checkEnabled!=undefined&&!actionType.checkEnabled(entry))return;actionType.action(entry)}};this.getActions=function(entry,actionType){if(!actionType)return[];var availableActions=actionGroupsSingle[actionType];var activeKeys=new Set;var defaultKey=entry.type=="CONTENT"?"drive.download":undefined;for(let i=0;i<entry.activeExtensions.length;i++){let isDefault=
entry.activeExtensions[i]==entry.defaultAction;let key=driveModel.actionIndexToKey.get(entry.activeExtensions[i]);activeKeys.add(key);if(isDefault)defaultKey=key}var resultActions=[];for(let i=0;i<availableActions.length;i++){let action=availableActions[i];if(activeKeys.has(action.key))resultActions.push($this.createWrapper(action,entry,defaultKey==action.key))}return resultActions};this.createWrapper=function(action,entry,isDefault){var isDisabled=action.single.checkEnabled!=undefined&&!action.single.checkEnabled(entry);
var wrapper={key:action.key,name:action.name,tooltip:action.single.tooltip,icon:action.icon,action:action.single.action,disabled:isDisabled,isDefault:isDefault,hasDrilldown:action.single.drilldown!=undefined&&action.single.drilldown.length>0};return wrapper};this.setActionsToEntry=function(entry){if(entry.actions)return;var actionsFixed=$this.getActions(entry,"fixed");var actionsMime=$this.getActions(entry,"mime");var actionsGeneric=$this.getActions(entry,"generic");var actionsMisc=$this.getActions(entry,
"misc");entry.actions={fixed:actionsFixed,mime:actionsMime,generic:actionsGeneric,misc:actionsMisc}};this.selectionHasAction=function(actionKey){var index=0;for(var i=0;i<driveModel.contextMenuExtensions.length;i++)if(driveModel.contextMenuExtensions[i].actionKey==actionKey){index=i;break}var selected=driveModel.getSelectedEntries();var enabled=selected.length>0;var action=actionsMap.get(actionKey);ENTRY_LOOP:for(var e=0;e<selected.length;e++){var entry=selected[e];if(entry.activeExtensions.indexOf(index)<
0){enabled=false;break}var category=entry.actions[action.type];for(var j=0;j<category.length;j++){var wrapper=category[j];if(wrapper.key==actionKey){if(wrapper.disabled)enabled=false;break ENTRY_LOOP}}}return enabled};this.getActionsMulti=function(actionType){if(!actionType)return[];var availableActions=actionGroupsMulti[actionType];var activeKeys=new Set;for(let i=0;i<driveModel.multiSelectExtensions.length;i++)activeKeys.add(driveModel.actionIndexToKey.get(driveModel.multiSelectExtensions[i]));
var resultActions=[];for(let i=0;i<availableActions.length;i++){let action=availableActions[i];if(activeKeys.has(action.key)&&action.multi.checkEnabled())resultActions.push(action)}return resultActions};this.updateMultiSelectActions=function(){driveModel.actionsMulti.fixed=$this.getActionsMulti("fixed");driveModel.actionsMulti.mime=$this.getActionsMulti("mime");driveModel.actionsMulti.generic=$this.getActionsMulti("generic");driveModel.actionsMulti.misc=$this.getActionsMulti("misc")}});
clearreportsApp.run(function($rootScope,driveModel,driveFactory,dataservice,dialogservice,locationservice,actionservice,errorservice,websocketdataservice,progressService){var downloadFile=function(id){$(".drivedownloadframe").remove();var hiddenIframe=document.createElement("iframe");hiddenIframe.setAttribute("src","?method\x3ddrive.download\x26entry\x3d"+id);hiddenIframe.setAttribute("class","drivedownloadframe");hiddenIframe.setAttribute("style","visibility:hidden;display:none;");$(".driveapp .entrylist").append(hiddenIframe)};
var actionDownload={key:"drive.download",icon:"icon-download-drive",name:$rootScope.getMsg("drive.gui.download.item"),single:{tooltip:"",action:function(entry){downloadFile(entry.id)},checkEnabled:function(entry){return entry.capabilities.canReadContent}},multi:{tooltip:function(){return getMsg("drive.gui.download."+driveFactory.counterSuffix())},action:function(){if(driveModel.selectedIDs.size==1){var entry=driveModel.getSelectedEntries()[0];if(entry){downloadFile(entry.id);return}}var idsToDownload=
Array.from(driveModel.selectedIDs);dataservice.execute("drive.downloadmulti",{data:JSON.stringify({parentID:driveModel.selectedFolderID,ids:idsToDownload}),handleSuccess:function(response){downloadFile(response.id)}})},checkEnabled:function(){return driveModel.hasSelection()}}};actionservice.registerAction(actionDownload,actionservice.ACTION_TYPE.GENERIC);var actionRename={key:"drive.rename",icon:"icon-rename",name:$rootScope.getMsg("drive.gui.rename.item"),single:{tooltip:"",action:function(entry){driveFactory.renameEntry(entry.id)},
checkEnabled:function(entry){return entry.writable&&entry.capabilities.canRename}}};actionservice.registerAction(actionRename,actionservice.ACTION_TYPE.GENERIC);var actionMove={key:"drive.move",icon:"icon-move",name:$rootScope.getMsg("drive.gui.move.item"),single:{tooltip:"",action:function(entry){locationservice.addPath("action/move/"+entry.id)},checkEnabled:function(entry){return entry.writable&&entry.capabilities.canMove}},multi:{tooltip:function(){return getMsg("drive.gui.move.item")},action:function(){locationservice.addPath("actionselected/move")},
checkEnabled:function(){return driveModel.viewCapabilities.canDeleteChildren&&actionservice.selectionHasAction("drive.move")}}};actionservice.registerAction(actionMove,actionservice.ACTION_TYPE.GENERIC);var actionCopy={key:"drive.copy",icon:"icon-copy",name:$rootScope.getMsg("drive.gui.copy.item"),single:{tooltip:"",action:function(entry){locationservice.addPath("action/copy/"+entry.id)},checkEnabled:function(entry){return entry.capabilities.canCopy}},multi:{tooltip:function(){return getMsg("drive.gui.copy.item")},
action:function(){locationservice.addPath("actionselected/copy")},checkEnabled:function(){return actionservice.selectionHasAction("drive.copy")}}};actionservice.registerAction(actionCopy,actionservice.ACTION_TYPE.GENERIC);var actionDelete={key:"drive.delete",icon:"icon-delete",name:$rootScope.getMsg("drive.gui.delete.item"),single:{tooltip:"",action:function(entry){driveFactory.deleteSingleEntry(entry.id)},checkEnabled:function(entry){return entry.writable&&entry.capabilities.canDelete}},multi:{tooltip:function(){return getMsg("drive.gui.delete."+
driveFactory.counterSuffix())},action:function(){if(!driveModel.viewCapabilities.canDeleteChildren)return;var newScope=$rootScope.$new(true);var callback=function(answer){if(answer==DIALOGSERVICE.YES){var requestData={parentID:driveModel.selectedFolderID,pollingID:websocketdataservice.getPollingID(),ids:Array.from(driveModel.selectedIDs)};var startCallback=function(){driveModel.selectedIDs.clear()};var progressCallback=function(progress){if(progress.state=="finished")if(progress.fraction>0)errorservice.shownotificationcontent(getMsg("drive.gui.delete.success",
progress.fraction),errorservice.type.SUCCESS);else errorservice.shownotificationcontent(getMsg("drive.gui.delete.success.empty"),errorservice.type.DEFAULT);else if(progress.state=="canceled")errorservice.shownotificationcontent(getMsg("drive.gui.delete.canceled",progress.fraction),errorservice.type.DEFAULT);else if(progress.state=="error")errorservice.shownotificationcontent(getMsg("drive.gui.delete.error",progress.progressLabel),errorservice.type.WARNING)};progressService.startTask("drive.deleteentry",
requestData,undefined,startCallback,progressCallback)}newScope.$destroy()};var message;if(driveModel.selectedIDs.size==1){var entry=driveModel.getSelectedEntries()[0];if(entry)message=$rootScope.getMsg("drive.gui.delete.message",entry.name)}if(!message)message=$rootScope.getMsg("drive.gui.delete.message."+driveFactory.counterSuffix(),driveModel.selectedIDs.size);dialogservice.showMessageBox(undefined,$rootScope.getMsg("drive.gui.delete.title"),message,DIALOGSERVICE.QUESTION_MESSAGE,DIALOGSERVICE.YES_NO_OPTION,
callback,newScope,undefined)},checkEnabled:function(){return driveModel.viewCapabilities.canDeleteChildren&&actionservice.selectionHasAction("drive.delete")}}};actionservice.registerAction(actionDelete,actionservice.ACTION_TYPE.GENERIC);var actionCopyDriveURL={key:"drive.copypath",icon:"icon-copypath",name:$rootScope.getMsg("drive.gui.copyurl.item"),single:{tooltip:$rootScope.getMsg("drive.gui.copyurl.tooltip"),action:function(entry){event.preventDefault();let url=$rootScope.rootPath+"drive/entry/"+
entry.id;var name=entry.name;if(navigator.clipboard){navigator.clipboard.writeText(""+url);errorservice.shownotificationcontent(getMsg("drive.gui.copyurl.success",name),errorservice.type.SUCCESS)}else errorservice.shownotificationcontent(getMsg("drive.gui.copyurl.failed",name),errorservice.type.WARNING)}}};actionservice.registerAction(actionCopyDriveURL,actionservice.ACTION_TYPE.MISC);var actionShareGoto={key:"drive.goto",icon:"svgicon-goto",name:$rootScope.getMsg("drive.gui.context.goto"),single:{tooltip:getMsg("drive.gui.context.goto.tip"),
action:function(entry){websocketdataservice.sendEvent("drive.share.goto",{id:entry.id})},checkEnabled:function(entry){return true}},multi:{tooltip:function(){return getMsg("drive.gui.context.goto.tip")},action:function(){websocketdataservice.sendEvent("drive.share.goto",{id:driveModel.selectedFolderID})},checkEnabled:function(){return driveModel.selectedIDs.size==0&&!driveModel.searchResult},showInToolbar:false}};actionservice.registerAction(actionShareGoto,actionservice.ACTION_TYPE.FIXED)});