/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.data;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.mount.BrokenMountDriveEntry;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.webgui.server.data.DriveGuiEntry;
import com.inet.drive.webgui.server.model.b;
import com.inet.drive.webgui.server.utils.c;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class FolderListData {
    private static final ConcurrentHashMap<Locale, a> NAME_SORTERS = new ConcurrentHashMap();
    private String parentID;
    private List<DriveGuiEntry> path;
    private List<DriveGuiEntry> folders;
    private List<DriveGuiEntry> roots;
    private String errorMessage;

    public FolderListData(String parentID, List<DriveGuiEntry> path, List<DriveGuiEntry> folders) {
        this.parentID = parentID;
        this.path = path;
        this.folders = folders;
    }

    public FolderListData(String errorMessage, String parentID) {
        this.parentID = parentID;
        this.errorMessage = errorMessage;
        this.path = new ArrayList<DriveGuiEntry>();
        this.folders = new ArrayList<DriveGuiEntry>();
    }

    public void setRoots(@Nullable List<DriveGuiEntry> roots) {
        this.roots = roots;
    }

    @Nonnull
    public String toString() {
        if (this.errorMessage != null) {
            return "ERROR: " + this.errorMessage;
        }
        return "Folder " + this.parentID + ": " + this.folders.size() + " children" + (String)(this.roots != null ? this.roots.size() + " roots" : "");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static FolderListData buildFromFolder(DriveEntry parent, String parentID, boolean addRootsData, boolean listShares) {
        Object object;
        Object object2;
        Object object32;
        if (parent instanceof BrokenMountDriveEntry) {
            return new FolderListData(DrivePlugin.MSG_SERVER.getMsg("drive.error.notaccessible", new Object[0]), parentID);
        }
        if (parent == null || !parent.exists()) {
            return new FolderListData(DrivePlugin.MSG_SERVER.getMsg("drive.error.notaccessible", new Object[0]), parentID);
        }
        if (!parent.hasFeature(Folder.class)) {
            return new FolderListData(DrivePlugin.MSG_SERVER.getMsg("drive.error.notAFolder", new Object[0]), parentID);
        }
        List list = ServerPluginManager.getInstance().get(b.class);
        LinkedList<DriveGuiEntry> linkedList = new LinkedList<DriveGuiEntry>();
        linkedList.add(FolderListData.toGuiEntry(parent, true, list));
        for (DriveEntry driveEntry = parent.getParent(); driveEntry != null; driveEntry = driveEntry.getParent()) {
            linkedList.addFirst(FolderListData.toGuiEntry(driveEntry, true, list));
        }
        @Nonnull ArrayList<@Nonnull DriveGuiEntry> arrayList = new ArrayList<DriveGuiEntry>();
        for (Object object32 : parent.executeFeatureNN(Folder.class, f2 -> f2.getChildren(), () -> new ArrayList())) {
            if (!listShares && object32.getID().startsWith("s_")) continue;
            object2 = c.Q((DriveEntry)object32);
            try {
                String string;
                if (!object32.hasFeature(Folder.class)) continue;
                object = DriveGuiEntry.a.w((DriveEntry)object32);
                Drive.ROOT_TYPES[] rOOT_TYPESArray = new DriveGuiEntry((String)object2, object32.getID(), "", (DriveGuiEntry.a)((Object)object), -1L, -1L);
                if (object == DriveGuiEntry.a.iN && (string = com.inet.drive.webgui.server.utils.a.N((DriveEntry)object32)) != null) {
                    rOOT_TYPESArray.setMimeKey(string);
                }
                rOOT_TYPESArray.setWritable(com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(object32.getID(), false, "EDITOR"));
                arrayList.add((DriveGuiEntry)rOOT_TYPESArray);
            }
            catch (MountManager.a a2) {
                arrayList.add(new DriveGuiEntry((String)object2, object32.getID(), "", DriveGuiEntry.a.iO, -1L, -1L));
            }
        }
        a a3 = NAME_SORTERS.computeIfAbsent(ClientLocale.getThreadLocale(), a::new);
        Collections.sort(arrayList, a3);
        object32 = new FolderListData(parent.getID(), linkedList, arrayList);
        if (addRootsData) {
            object2 = new ArrayList();
            object = Drive.getInstance().getRoots();
            for (Drive.ROOT_TYPES rOOT_TYPES : Drive.ROOT_TYPES.values()) {
                @Nonnull List list2 = (List)object.get((Object)rOOT_TYPES);
                if (list2 == null || list2.isEmpty() || !listShares && rOOT_TYPES == Drive.ROOT_TYPES.SHARED) continue;
                for (DriveEntry driveEntry : list2) {
                    object2.add(FolderListData.toGuiEntry(driveEntry, false, list));
                }
            }
            Collections.sort(object2, a3);
            ((FolderListData)object32).setRoots((List<DriveGuiEntry>)object2);
        }
        return object32;
    }

    @Nonnull
    private static DriveGuiEntry toGuiEntry(@Nonnull DriveEntry e2, boolean isInPath, @Nullable List<b> fields) {
        boolean bl;
        boolean bl2 = bl = e2.getMetaData(MetaData.PARENT_ID) != null;
        if (!bl && isInPath) {
            e2 = FolderListData.replaceRoot(e2);
        }
        com.inet.drive.webgui.server.model.a a2 = new com.inet.drive.webgui.server.model.a(e2, fields, false);
        @Nonnull DriveGuiEntry driveGuiEntry = a2.dW();
        if (a2.getType() == DriveGuiEntry.a.iN) {
            String string = com.inet.drive.webgui.server.utils.a.N(e2);
            if (string != null) {
                driveGuiEntry.setMimeKey(string);
            } else {
                driveGuiEntry.setMimeKey(DriveGuiEntry.a.iN.name());
            }
        }
        return driveGuiEntry;
    }

    @Nullable
    private static DriveEntry replaceRoot(@Nonnull DriveEntry e2) {
        String string = e2.getMetaData(MetaData.PARENT_ID);
        if (string != null) {
            return null;
        }
        String string2 = e2.getID();
        for (Map.Entry<Drive.ROOT_TYPES, List<DriveEntry>> entry : com.inet.drive.webgui.server.a.du().getRoots().entrySet()) {
            for (DriveEntry driveEntry : entry.getValue()) {
                if (!string2.startsWith(driveEntry.getID())) continue;
                return driveEntry;
            }
        }
        return e2;
    }

    private static class a
    implements Comparator<DriveGuiEntry> {
        private Collator collator;

        public a(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(0);
        }

        public int a(@Nonnull DriveGuiEntry driveGuiEntry, @Nonnull DriveGuiEntry driveGuiEntry2) {
            int n2 = Integer.compare(driveGuiEntry.getType().dE(), driveGuiEntry2.getType().dE());
            if (n2 != 0) {
                return n2;
            }
            n2 = this.collator.compare(driveGuiEntry.getName(), driveGuiEntry2.getName());
            if (n2 != 0) {
                return n2;
            }
            return driveGuiEntry.getId().compareTo(driveGuiEntry2.getId());
        }

        @Override
        public /* synthetic */ int compare(@Nonnull Object object, @Nonnull Object object2) {
            return this.a((DriveGuiEntry)object, (DriveGuiEntry)object2);
        }
    }
}

