/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.linked;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.Capabilities;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Permission;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.api.mount.BrokenMountDriveEntry;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.server.linked.c;
import com.inet.drive.server.linked.d;
import com.inet.drive.server.linked.e;
import com.inet.drive.server.persistence.l;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
implements DriveEntry {
    private final String cv;
    private DriveEntry al;
    private DriveEntry y;
    private Boolean cw;
    private final Drive as;
    private final MountDescription ax;
    private final String cx;
    @Nonnull
    private String cy = "/";
    DriveEntry cz;

    public a(@Nonnull MountDescription mountDescription, String string, DriveEntry driveEntry, DriveEntry driveEntry2, @Nonnull DriveEntry driveEntry3, Drive drive, @Nonnull String string2) {
        this.ax = mountDescription;
        this.cx = string2;
        this.cv = string;
        this.cz = driveEntry;
        this.y = driveEntry3;
        this.as = drive;
        if (driveEntry2 == driveEntry3) {
            throw new IllegalStateException(DrivePlugin.MSG_SERVER.getMsg("drive.mount.error.endless", new Object[0]));
        }
    }

    public a(DriveEntry driveEntry, @Nonnull MountDescription mountDescription, Drive drive, @Nonnull String string, @Nonnull String string2) {
        if (!string2.isBlank() && !string2.equals("/")) {
            this.cy = string2;
        }
        this.cx = string;
        this.cz = driveEntry;
        this.as = drive;
        this.ax = mountDescription;
        this.cv = driveEntry == null ? null : driveEntry.getID();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.ag().getName();
    }

    @Override
    @Nonnull
    public String getPath() {
        Object object = this.ag().getPath();
        if (this.cz != null) {
            Mount mount = (Mount)this.cz.getFeature(MOUNT);
            if (mount != null) {
                String string = mount.getOriginID();
                try {
                    DriveEntry driveEntry = this.ax.resolve(this.cz, "/", string);
                    if (driveEntry != null && ((String)object).startsWith(driveEntry.getPath())) {
                        object = ((String)object).replaceFirst(driveEntry.getPath(), "");
                    }
                    if (!((String)object).startsWith("/")) {
                        object = "/" + (String)object;
                    }
                }
                catch (Exception exception) {
                    DrivePlugin.LOGGER.warn(exception.getMessage(), (Object)exception);
                }
            }
            if (!this.cz.getPath().isEmpty()) {
                object = this.cz.getPath() + ((String)object).substring(1);
            }
            if (this.hasFeature(FOLDER) && !((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
        }
        return object;
    }

    @Override
    @Nonnull
    public String getID() {
        String string = this.ag().getID();
        if (this.cv.equals(string)) {
            return this.cv;
        }
        return DriveIDUtils.mergeID(this.cv, string);
    }

    @Override
    public long getLastModified() {
        this.aj();
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)this.ax.getUserID());){
            long l2 = this.ag().getLastModified();
            return l2;
        }
    }

    @Override
    public boolean exists() {
        try {
            return this.ag().exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean hasFeature(@Nonnull Class<? extends DriveFeature> type) {
        if (!this.exists() || type == SHARE) {
            return false;
        }
        if (type == Mount.class) {
            return true;
        }
        try {
            return this.ag().hasFeature(type);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    @Nullable
    public <T extends DriveFeature> T getFeature(@Nonnull Class<T> type) {
        if (!this.exists() || type == SHARE) {
            return null;
        }
        if (type == META_DATA) {
            return (T)new a((MetaData)this.ag().getFeature(META_DATA));
        }
        if (type == FOLDER && this.hasFeature(type)) {
            final Folder folder = (Folder)this.ag().getFeature(FOLDER);
            if (folder != null) {
                return (T)new c(this.cz, this.ax, this, this.cx){

                    @Override
                    protected Folder G() {
                        return folder;
                    }
                };
            }
        } else if (type == CONTENT) {
            Content content = (Content)this.ag().getFeature(CONTENT);
            if (content != null) {
                return (T)new com.inet.drive.server.linked.b(this, this.ax, content);
            }
        } else {
            if (type == MOUNT) {
                DriveEntry driveEntry = this.ag();
                String string = driveEntry.getID();
                boolean bl = string.equals(this.cv);
                Mount mount = (Mount)driveEntry.getFeature(MOUNT);
                return (T)new l(this, this.ax, string, this.cv, bl, mount);
            }
            if (type == PERMISSIONS) {
                Permissions permissions = (Permissions)this.ag().getFeature(PERMISSIONS);
                if (permissions != null) {
                    return (T)new b(permissions);
                }
            } else if (type == THUMBNAIL) {
                Thumbnail thumbnail = (Thumbnail)this.ag().getFeature(THUMBNAIL);
                if (thumbnail != null) {
                    return (T)new d(thumbnail, this);
                }
            } else if (type == Capabilities.class) {
                @Nullable Capabilities capabilities = this.ag().getFeature(Capabilities.class);
                if (capabilities != null) {
                    com.inet.drive.server.utils.b b2 = new com.inet.drive.server.utils.b(this.b(false));
                    return (T)new com.inet.drive.server.utils.a(b2, capabilities);
                }
                return null;
            }
        }
        return this.ag().getFeature(type);
    }

    DriveEntry e(DriveEntry driveEntry) {
        String string = driveEntry.getID();
        MountDescription mountDescription = this.ax;
        for (Mount mount = (Mount)driveEntry.getFeature(MOUNT); mount != null; mount = mount.getChild()) {
            if (mount.getChild() != null) continue;
            string = mount.getOriginID();
            mountDescription = mount.getDescription();
            break;
        }
        return com.inet.drive.webgui.server.a.du().resolve(DriveIDUtils.getMountRootID(mountDescription.getID(), string));
    }

    @Nonnull
    DriveEntry ag() {
        if (this.y == null) {
            DriveEntry driveEntry;
            String string = this.cx;
            try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)this.ax.getUserID());){
                driveEntry = this.ax.resolve(this.cz, this.cx, this.cy);
            }
            if (driveEntry == null && "PERSISTENCE_PROVIDER".equals(this.ax.getProvider())) {
                userAccountScope = UserAccountScope.createPrivileged();
                try {
                    driveEntry = this.as.resolve(string);
                }
                finally {
                    if (userAccountScope != null) {
                        userAccountScope.close();
                    }
                }
            }
            if (driveEntry == null) {
                driveEntry = new BrokenMountDriveEntry(new MountManager.b(DrivePlugin.MSG_SERVER.getMsg("drive.mount.error.cannotresolvedescription", new Object[]{string})));
            }
            this.y = driveEntry;
        }
        return this.y;
    }

    private DriveEntry ah() {
        if (this.al == null) {
            String string;
            DriveEntry driveEntry;
            DriveEntry driveEntry2;
            this.al = this.ai() ? this.cz : ((driveEntry2 = (driveEntry = this.ag()).getParent()) == null ? null : ((string = driveEntry2.getID()).equals(this.cz.getID()) || DriveIDUtils.isMountID(string) || string.equals(this.cz.getMetaData(MetaData.LINK_INDESCRIPTIONID)) ? this.cz : new a(this.cz, this.ax, this.as, this.cx, string)));
        }
        return this.al;
    }

    public boolean ai() {
        if (this.cw == null) {
            DriveEntry driveEntry = this.ax.resolve(this.cz, this.cx, "/");
            DriveEntry driveEntry2 = this.ag();
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                this.cw = driveEntry == null || driveEntry2.getParent() == null ? Boolean.valueOf(true) : Boolean.valueOf(driveEntry.getID().equals(driveEntry2.getParent().getID()));
            }
        }
        return this.cw;
    }

    @Override
    @Nullable
    public DriveEntry getParent() {
        this.aj();
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)this.ax.getUserID());){
            DriveEntry driveEntry = this.ah();
            return driveEntry;
        }
    }

    @Override
    public void delete(OperationProgressListener listener) throws DriveOperationConflictException {
        if (!this.b(false)) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.y.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
        }
        e.a(this.getID(), this.ax, () -> {
            String string = null;
            String string2 = this.getName();
            int n2 = com.inet.drive.server.eventlog.a.d(this);
            String string3 = "";
            String string4 = com.inet.drive.server.eventlog.a.Z();
            String string5 = this.getMetaData(MetaData.PARENT_ID);
            Mount mount = (Mount)this.getFeature(MOUNT);
            boolean bl = false;
            if (mount != null) {
                string = DriveIDUtils.getMountRootID(this.ax.getID(), mount.getOriginID());
                string3 = mount.getEntry().getPath();
                bl = "PERSISTENCE_PROVIDER".equals(mount.getDescription().getProvider());
            }
            com.inet.drive.server.utils.c c2 = listener instanceof com.inet.drive.server.utils.c ? (com.inet.drive.server.utils.c)listener : new com.inet.drive.server.utils.c(listener);
            c2.startOperationFor(this.getID());
            this.ag().delete(bl ? listener : c2);
            c2.W(string3);
            if (mount != null && mount.getChild() == null && !bl) {
                com.inet.drive.server.eventlog.a.bz.a(mount.getOriginID(), string3, n2, c2.cg(), string4);
            }
            if (string != null) {
                e.a(this.ax, DriveObserver.EventType.REMOVED, new DriveObserver.EventType.RemoveEvent(string, string5, string2));
            }
            return null;
        });
    }

    @Override
    @Nonnull
    public String getExtensionName() {
        return this.ag().getExtensionName();
    }

    boolean aj() {
        return this.a(true);
    }

    boolean a(boolean bl) {
        return this.a(bl, Permissions.READ_ACCESS);
    }

    boolean b(boolean bl) {
        return this.a(bl, "EDITOR");
    }

    boolean a(boolean bl, String ... stringArray) {
        String string = this.cv;
        if (string == null) {
            string = this.getID();
        }
        boolean bl2 = com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(string, false, stringArray);
        if (bl && !bl2) {
            throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.mount", new Object[]{string, Arrays.toString(stringArray)}));
        }
        return bl2;
    }

    <T> void notifyObservers(DriveObserver.EventType<T> type, T eventData) {
        if (!this.ax.getProvider().equals("PERSISTENCE_PROVIDER")) {
            this.as.notifyObservers(type, eventData);
        }
    }

    private class a
    implements MetaData {
        private final MetaData au;

        public MetaData D() {
            return this.au;
        }

        public a(MetaData metaData) {
            this.au = metaData;
        }

        @Override
        public <T> void setMetaData(@Nonnull MetaKey<T> key, @Nullable T value) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
            if (!a.this.b(false)) {
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(a.this.y.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
            }
            try {
                e.a(a.this.getID(), a.this.ax, () -> {
                    Object t2;
                    MetaData metaData = this.D();
                    if (metaData != null && ((t2 = metaData.getMetaData(key)) == null && value != null || t2 != null && value == null || t2 != value && !t2.equals(value))) {
                        String string;
                        String string2 = this.ak();
                        metaData.setMetaData(key, value);
                        if (key == NAME && e.g(a.this.y)) {
                            com.inet.drive.server.eventlog.a.bA.a(a.this.y, t2);
                        }
                        if (string2.equals(string = this.ak())) {
                            e.a(a.this.ax, DriveObserver.EventType.MODIFIED, new DriveObserver.EventType.MetaDataChange(string, key, t2, value));
                        } else {
                            e.a(a.this.ax, DriveObserver.EventType.REMOVED, new DriveObserver.EventType.RemoveEvent(string2, null, a.this.getName()));
                            e.a(a.this.ax, DriveObserver.EventType.CREATED, a.this);
                        }
                    }
                    return null;
                });
            }
            catch (DriveOperationConflictException driveOperationConflictException) {
                if (!"PERSISTENCE_PROVIDER".equals(a.this.ax.getProvider())) {
                    for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : driveOperationConflictException.getConflicts()) {
                        if (singleEntryConflict.getExistingEntryID() != null) {
                            singleEntryConflict.setExistingEntryID(DriveIDUtils.getMountRootID(a.this.ax.getID(), singleEntryConflict.getExistingEntryID()));
                        }
                        if (singleEntryConflict.getReplacementEntryID() == null) continue;
                        singleEntryConflict.setReplacementEntryID(DriveIDUtils.getMountRootID(a.this.ax.getID(), singleEntryConflict.getReplacementEntryID()));
                    }
                }
                throw driveOperationConflictException;
            }
        }

        private String ak() {
            String string;
            Mount mount = a.this.getFeature(DriveEntry.MOUNT);
            if (mount != null) {
                string = DriveIDUtils.getMountRootID(mount.getDescription().getID(), mount.getOriginID());
            } else {
                DrivePlugin.LOGGER.warn((Object)"Internal Linked Entry has not Mount Feature!");
                string = a.this.getID();
            }
            return string;
        }

        @Override
        @Nullable
        public <T> T getMetaData(@Nonnull MetaKey<T> key) {
            if (key != MetaData.ID && key != MetaData.NAME && key != MetaData.CREATOR_ID && key != MetaData.PARENT_ID && key != MetaData.HOMEFOLDER) {
                a.this.aj();
            }
            try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)a.this.ax.getUserID());){
                if (key == ID) {
                    String string = a.this.getID();
                    return (T)string;
                }
                if (key == PATH) {
                    String string = a.this.getPath();
                    return (T)string;
                }
                if (key == PARENT_ID) {
                    DriveEntry driveEntry = a.this.getParent();
                    if (driveEntry != null) {
                        String string = driveEntry.getID();
                        return (T)string;
                    }
                    T t2 = null;
                    return t2;
                }
                if (key == CREATOR_ID) {
                    GUID gUID = a.this.ax.getUserID();
                    return (T)gUID;
                }
                if (this.D() == null) {
                    T t3 = null;
                    return t3;
                }
                T t4 = this.D().getMetaData(key);
                return t4;
            }
        }
    }

    private class b
    implements Permissions {
        @Nonnull
        private final Permissions bl;

        @Nonnull
        public Permissions al() {
            return this.bl;
        }

        public b(Permissions permissions) {
            this.bl = permissions;
        }

        @Override
        public boolean hasPermission(@Nonnull String permissionType) {
            return this.al().hasPermission(permissionType);
        }

        @Override
        public void addPermissions(@Nonnull GUID userOrGroupId, boolean isGroup, Permission ... permissions) {
            if (!"PERSISTENCE_PROVIDER".equals(a.this.ax.getProvider()) && !a.this.y.executeFeature(Mount.class, mount -> mount.isLinkRoot(), false)) {
                throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.linkpermission", new Object[0]));
            }
            this.al().addPermissions(userOrGroupId, isGroup, permissions);
        }

        @Override
        public void removePermission(@Nonnull GUID userOrGroupId, boolean isGroup, String ... permissionTypes) {
            if (!"PERSISTENCE_PROVIDER".equals(a.this.ax.getProvider()) && !a.this.y.executeFeature(Mount.class, mount -> mount.isLinkRoot(), false)) {
                throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.linkpermission", new Object[0]));
            }
            this.al().removePermission(userOrGroupId, isGroup, permissionTypes);
        }

        @Override
        public void setPermissions(boolean isGroup, @Nonnull Map<GUID, Map<String, Boolean>> permissions) {
            if (!"PERSISTENCE_PROVIDER".equals(a.this.ax.getProvider()) && !a.this.y.executeFeature(Mount.class, mount -> mount.isLinkRoot(), false)) {
                throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.linkpermission", new Object[0]));
            }
            this.al().setPermissions(isGroup, permissions);
        }

        @Override
        public void clearPermission() {
            if (!"PERSISTENCE_PROVIDER".equals(a.this.ax.getProvider()) && !a.this.y.executeFeature(Mount.class, mount -> mount.isLinkRoot(), false)) {
                throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.linkpermission", new Object[0]));
            }
            this.al().clearPermission();
        }

        @Override
        @Nonnull
        public Map<GUID, Map<String, Boolean>> getPermissions(boolean isGroup) {
            return this.al().getPermissions(isGroup);
        }

        @Override
        @Nonnull
        public List<String> getAvailablePermissions() {
            return this.al().getAvailablePermissions();
        }
    }
}

