/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.protocol.drive;

import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Content;
import com.inet.lib.io.DiskBufferedOutputStream;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class c
extends URLConnection {
    private String aA;
    private boolean aB;
    private String aC;
    private OutputStream aD;
    private Set<InputStream> aE = new HashSet<InputStream>();

    protected c(URL uRL, boolean bl) {
        super(uRL);
        this.aB = bl;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (UserManager.getInstance().getCurrentUserAccountID() == null) {
            throw new AccessDeniedException(this.url);
        }
        if (!SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_PERMISSION)) {
            throw new AccessDeniedException(DrivePermission.DRIVE_PERMISSION);
        }
        this.aC = this.url.getPath();
        this.aC = EncodingFunctions.decodeUrlPath((String)this.aC);
        if (this.aB && this.aC.startsWith("~/")) {
            this.aC = "/Home/" + this.aC.substring(2);
        }
        this.connected = true;
    }

    @Override
    public long getContentLengthLong() {
        try {
            this.connect();
            DriveEntry driveEntry = Drive.getInstance().resolve(this.aC);
            if (driveEntry == null) {
                return -1L;
            }
            return driveEntry.executeFeature(Content.class, content -> content.getSize(), -1L);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.aD != null) {
            throw new IllegalStateException("The output stream has to be closed before requesting a new one");
        }
        if (!this.aE.isEmpty()) {
            throw new IllegalStateException("The active input stream has to be closed before writing to the output");
        }
        this.connect();
        if (this.aC == null) {
            return null;
        }
        try {
            DriveEntry driveEntry = Drive.getInstance().resolve(this.aC);
            if (driveEntry == null) {
                if (this.aC.endsWith("/")) {
                    throw new IOException("URLs cannot be used to create folders in Drive. Path: " + this.aC);
                }
                if (DriveIDUtils.isID(this.aC) || DriveIDUtils.isMountID(this.aC)) {
                    throw new IOException("New files cannot be created based on an ID. Path: " + this.aC);
                }
                int n2 = this.aC.lastIndexOf(47);
                final String string = n2 >= 0 ? this.aC.substring(0, n2 + 1) : "/";
                final String string2 = n2 >= 0 ? this.aC.substring(n2 + 1) : this.aC;
                DiskBufferedOutputStream diskBufferedOutputStream = new DiskBufferedOutputStream(){

                    public void close() throws IOException {
                        try {
                            DriveEntry driveEntry = DriveUtils.getOrCreateChild(Drive.getInstance(), string, new DataEntry(string2, this.getInputStream()));
                            if (driveEntry == null) {
                                throw new IOException("Could not create file: " + c.this.aC);
                            }
                        }
                        finally {
                            super.close();
                            c.this.aD = null;
                        }
                    }
                };
                this.aD = diskBufferedOutputStream;
                return diskBufferedOutputStream;
            }
            if (!driveEntry.hasFeature(Content.class)) {
                throw new IOException("Cannot write content since the URL is a folder: " + this.aC);
            }
            @Nullable OutputStream outputStream = driveEntry.getFeature(Content.class).getOutputStream();
            if (outputStream == null) {
                throw new UnknownServiceException(this.url.toString() + " does not support output streams");
            }
            this.aD = new FastBufferedOutputStream(outputStream){

                public void close() throws IOException {
                    super.close();
                    c.this.aD = null;
                }
            };
            return this.aD;
        }
        catch (AccessDeniedException accessDeniedException) {
            accessDeniedException.setUrl(this.url);
            throw accessDeniedException;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        FastBufferedInputStream fastBufferedInputStream;
        if (this.aD != null) {
            throw new IllegalStateException("The active output stream has to be closed before writing to the output");
        }
        this.connect();
        try {
            DriveEntry driveEntry = Drive.getInstance().resolve(this.aC);
            if (driveEntry == null || !driveEntry.hasFeature(Content.class)) {
                throw new FileNotFoundException(this.aC);
            }
            InputStream inputStream = driveEntry.getFeature(Content.class).getInputStream();
            fastBufferedInputStream = new FastBufferedInputStream(inputStream){

                public void close() throws IOException {
                    super.close();
                    c.this.aE.remove((Object)this);
                }
            };
            this.aE.add((InputStream)fastBufferedInputStream);
            this.aA = IOFunctions.isZipFile((FastBufferedInputStream)fastBufferedInputStream) ? "application/zip" : "text/xml";
            this.connected = true;
        }
        catch (AccessDeniedException accessDeniedException) {
            accessDeniedException.setUrl(this.url);
            throw accessDeniedException;
        }
        return fastBufferedInputStream;
    }

    @Override
    public long getLastModified() {
        try {
            this.connect();
            @Nullable DriveEntry driveEntry = Drive.getInstance().resolve(this.aC);
            return driveEntry != null ? driveEntry.getLastModified() : 0L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ("content-type".equalsIgnoreCase(name)) {
            return this.aA;
        }
        return super.getHeaderField(name);
    }
}

