/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.mount;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.lib.util.IOFunctions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;

@InternalApi
public class MountUtils {
    @Nonnull
    public static String getPathFromID(@Nonnull String entryID) {
        String string;
        byte[] byArray = Base64.getUrlDecoder().decode(entryID);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        try {
            string = new String(IOFunctions.readBytes((InputStream)gZIPInputStream), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    gZIPInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw (RuntimeException)ErrorCode.throwAny((Throwable)iOException);
            }
        }
        gZIPInputStream.close();
        return string;
    }

    @Nonnull
    public static String getIDForPath(@Nonnull String entryPath) {
        if (entryPath.endsWith("/")) {
            entryPath = entryPath.substring(0, entryPath.length() - "/".length());
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gZIPOutputStream.write(entryPath.getBytes(StandardCharsets.UTF_8));
            }
            return Base64.getUrlEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)iOException);
        }
    }

    @Nonnull
    public static String toAbsolutePath(@Nonnull String mountPointPath, @Nonnull String pathInMount) {
        boolean bl = mountPointPath.endsWith("/");
        boolean bl2 = pathInMount.startsWith("/");
        if (bl && bl2) {
            return mountPointPath + pathInMount.substring(1, pathInMount.length());
        }
        if (!bl && !bl2) {
            return mountPointPath + "/" + pathInMount;
        }
        return mountPointPath + pathInMount;
    }
}

