/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.mount;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.authentication.AccessForbiddenException;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Synchronization;
import com.inet.drive.api.mount.BrokenMountDriveEntry;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.api.mount.MountProvider;
import com.inet.drive.api.mount.b;
import com.inet.drive.server.oauth.c;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.i;
import com.inet.drive.server.persistence.m;
import com.inet.drive.webgui.server.a;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class MountDescription {
    public static final String REFRESH_TOKEN = "refreshToken";
    private transient MountProvider<?> mountProvider;
    private String name;
    private String id;
    private GUID userID;
    @Nonnull
    private String provider;
    private long modified;
    private Map<String, String> providerConfig;

    private MountDescription() {
    }

    protected MountDescription(@Nonnull String provider, Map<String, String> providerConfig, @Nonnull GUID userID, String name) {
        this.provider = provider;
        this.providerConfig = providerConfig;
        this.userID = userID;
        this.id = GUID.generateNew().toString();
        this.name = name;
    }

    @Nonnull
    public Map<String, String> getProviderConfig() {
        this.checkAccess();
        this.load();
        if (this.providerConfig == null) {
            this.providerConfig = new HashMap<String, String>();
        }
        return this.providerConfig;
    }

    public long getModified() {
        return this.modified;
    }

    private void checkAccess() {
        if (!m.a(UserManager.getInstance().getCurrentUserAccount()) && !this.userID.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
            throw new AccessForbiddenException("Only the owner can access to the connection information.");
        }
    }

    @Nonnull
    private MountProvider<?> getProviderInstance() {
        if (this.mountProvider == null) {
            MountProvider<?> mountProvider = MountManager.getProvider(this.provider);
            if (mountProvider == null) {
                throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("drive.mount.missingplugin", new Object[]{this.provider}), true);
            }
            this.mountProvider = mountProvider;
        }
        return this.mountProvider;
    }

    @Nonnull
    public DriveEntry getRoot() {
        return new b(this);
    }

    @Nonnull
    public String getProvider() {
        return this.provider;
    }

    @Nonnull
    public com.inet.drive.server.oauth.b getOAuthConfig(c<?> provider) {
        Map<String, String> map = this.getProviderConfig();
        Consumer<com.inet.drive.server.oauth.b> consumer = oauthConfig -> {
            String string = oauthConfig.aI();
            map.put(REFRESH_TOKEN, string);
            this.save();
        };
        String string = map.get(REFRESH_TOKEN);
        return new com.inet.drive.server.oauth.b(provider, string, consumer);
    }

    @Nullable
    public DriveEntry resolve(@Nullable i parent) {
        return this.resolve(parent, "/");
    }

    @Nullable
    public DriveEntry resolve(@Nullable DriveEntry parent, @Nonnull String pathOrID) {
        return this.resolve(parent, "/", pathOrID);
    }

    @Nullable
    public DriveEntry resolve(@Nullable DriveEntry parent, @Nonnull String firstPathOrID, @Nonnull String pathOrID) {
        Permission[] permissionArray;
        Object object;
        if (parent != null) {
            object = UserAccountScope.createPrivileged();
            try {
                permissionArray = parent.getFeature(DriveEntry.MOUNT);
                if (permissionArray == null || !permissionArray.getDescription().getID().equals((Object)this.getID())) {
                    DriveEntry driveEntry = null;
                    return driveEntry;
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        try {
            object = this.getProviderInstance();
            if (!("PERSISTENCE_PROVIDER".equals(object.getExtensionName()) || "sharing".equals(object.getExtensionName()) || SystemPermissionChecker.hasAnyPermission((GUID)this.getUserID(), (Permission[])new Permission[]{DrivePermission.DRIVE_MOUNT_PERMISSION}) && object.userHasPermission(this.getUserID()))) {
                permissionArray = object.getRequiredPermissions();
                String string = object.getDisplayName();
                if (permissionArray != null && permissionArray.length > 0 && permissionArray[0] != null) {
                    String string2 = permissionArray[0].getDisplayName();
                    throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.mount.permission.mount", new Object[]{string2, string}));
                }
                throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.mount.permission.general", new Object[]{string}));
            }
            return object.resolve(parent, this, firstPathOrID, pathOrID);
        }
        catch (Throwable throwable) {
            if (this.getProvider().equals("PERSISTENCE_PROVIDER") || this.getProvider().equals("sharing")) {
                throw throwable;
            }
            return new BrokenMountDriveEntry(throwable);
        }
    }

    @Nonnull
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Nonnull
    public String getProviderName() {
        try {
            @Nonnull MountProvider<?> mountProvider = this.getProviderInstance();
            return mountProvider.getDisplayName();
        }
        catch (Exception exception) {
            return this.provider;
        }
    }

    @Nonnull
    public GUID getID() {
        GUID gUID = GUID.valueOf((String)this.id);
        return gUID == null ? new GUID("invalid") : gUID;
    }

    @Nonnull
    public GUID getUserID() {
        return this.userID;
    }

    public void setName(String name) throws DriveOperationConflictException {
        if (this.name.equals(name)) {
            return;
        }
        this.checkAccess();
        String string = this.name;
        if (!this.provider.equals("PERSISTENCE_PROVIDER")) {
            e.aZ().a(name, true, null, false);
        }
        this.name = name;
        this.modified = System.currentTimeMillis();
        this.save();
        a.du().notifyObservers(DriveObserver.EventType.MODIFIED, new DriveObserver.EventType.MetaDataChange(this.getRoot().getID(), MetaData.NAME, string, name));
    }

    public void setNameSilent(String name) {
        this.name = name;
        this.save();
    }

    public void setProviderConfig(Map<String, String> providerConfig) {
        this.checkAccess();
        this.providerConfig = providerConfig;
        this.modified = System.currentTimeMillis();
        this.save();
        this.getProviderInstance().clearCache(this);
        try {
            Synchronization synchronization = this.getRoot().getFeature(DriveEntry.SYNCHRO);
            if (synchronization != null) {
                synchronization.synchronize();
            }
        }
        catch (Throwable throwable) {
            DrivePlugin.LOGGER.debug((Object)("Could not clear the cache for the connection setting " + String.valueOf(this.getID())));
        }
        a.du().notifyObservers(DriveObserver.EventType.REFRESH, this.getID());
    }

    @Nonnull
    public String toString() {
        return "MountDescription{name='" + this.name + "', id=" + this.id + ", userID=" + String.valueOf(this.userID) + ", provider='" + String.valueOf(this.getProviderConfig()) + "'}";
    }

    void save() {
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve(this.getLockKey());
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getWriteLock(this.getLockKey(), 200L);){
            PersistenceEntry persistenceEntry2 = persistenceEntry.getCryptoInstance(this.id.toCharArray(), this.id.getBytes(StandardCharsets.UTF_8));
            String string = new Json().toJson((Object)this);
            persistenceEntry2.setString(string);
        }
    }

    void load() {
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve(this.getLockKey());
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getReadLock(this.getLockKey(), 200L);){
            PersistenceEntry persistenceEntry2 = persistenceEntry.getCryptoInstance(this.id.toCharArray(), this.id.getBytes(StandardCharsets.UTF_8));
            String string = persistenceEntry2.getString();
            if (string != null) {
                this.providerConfig = ((MountDescription)new Json().fromJson((String)string, MountDescription.class)).providerConfig;
            }
        }
    }

    void delete() {
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve(this.getLockKey());
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getWriteLock(this.getLockKey(), 200L);){
            persistenceEntry.deleteValue();
        }
    }

    @Nonnull
    private String getLockKey() {
        return "/drive/mountmanager/" + this.id;
    }
}

