/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.metadata;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.feature.MetaKey;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DefaultMetaKey<T>
extends MetaKey<T> {
    private SearchTokenizer ai;

    public DefaultMetaKey(@Nonnull String key, boolean useInSearch, boolean displayInDetails, boolean appendForEachUIEntry) {
        super(key, useInSearch, displayInDetails, appendForEachUIEntry);
    }

    public DefaultMetaKey(@Nonnull String key, boolean useInSearch, boolean displayInDetails, boolean appendForEachUIEntry, @Nonnull SearchTokenizer tokenizer) {
        this(key, useInSearch, displayInDetails, appendForEachUIEntry);
        this.ai = tokenizer;
    }

    @Override
    @Nonnull
    public String getLabel() {
        return DrivePlugin.MSG_SERVER.getMsg("meta.key." + this.getKey(), new Object[0]);
    }

    @Override
    @Nonnull
    public String formatValue(@Nullable T value) {
        return value != null ? value.toString() : "";
    }

    @Override
    @Nullable
    public SearchTag getSearchTag() {
        if (this.ai == null) {
            return super.getSearchTag();
        }
        if (!this.isUseInSearch()) {
            return null;
        }
        if (this.searchTag == null) {
            this.searchTag = new SearchTag(this.getKey(), this.ai, 0, (Supplier)new MetaKey.a(this));
        }
        return this.searchTag;
    }
}

