'use strict';clearreportsApp.service("driveFactory",function($rootScope,$timeout,websocketdataservice,dataservice,driveModel,errorservice,resolveService,dialogservice,locationservice,actionservice,progressService){var $this=this;this.SEARCH_RESULT="SEARCH_RESULT";this.connect=function(){websocketdataservice.sendEvent("drive.connect")};this.loadNode=function(id){if(driveModel.selectedFolderID!=id)driveModel.clearFolderCache(id);if(driveModel.treeData)websocketdataservice.sendEvent("drive.selectEntry",
id);else driveModel.selectedFolderID==id};this.loadEntriesDetails=function(entryId){if(driveModel.details.id==entryId&&driveModel.selectedIDs.size==1)return;if(driveModel.searchResult&&driveModel.selectedIDs.size==0){driveModel.details.id=undefined;driveModel.details.extensions=undefined;driveModel.details.data=undefined;return}driveModel.details.id=entryId;websocketdataservice.sendEvent("drive.getentrydetails",{parentID:driveModel.selectedFolderID,ids:Array.from(driveModel.selectedIDs)})};this.loadFolderContent=
function(refresh){var loadID;var key;var reload=refresh?refresh:false;if(driveModel.searchResult&&$rootScope.search.term){loadID=$rootScope.search.term;key="drive.search"}else{loadID=driveModel.selectedFolderID;key="drive.listFolder"}if(!loadID)return;var sortBy=driveModel.listsorting.sortBy;if(sortBy=="name"&&driveModel.viewSettings.showTitle)sortBy="title";errorservice.clearErrorContent("#driveerrors");websocketdataservice.sendEvent(key,{id:loadID,windowSize:driveModel.windowSize,sortBy:sortBy,
ascending:driveModel.listsorting.ascending,reload:reload})};this.reloadFolder=function(){this.loadFolderContent(true)};this.sendListLayout=function(){websocketdataservice.sendEvent("drive.store.layout",driveModel.listlayout)};this.sendViewSettings=function(){websocketdataservice.sendEvent("drive.store.viewsettings",driveModel.viewSettings)};this.uploadToFolder=function(files,folderID,conflictData){var attachmentQueue=[];var totalSize=0;var keyToPathMap={};var counterPrefix="Item_";if(Array.isArray(files)||
files instanceof FileList)for(let f=0;f<files.length;f++){let att=files[f];let name=counterPrefix+(f+1)+"_"+att.file.name;keyToPathMap[name]=att.path;totalSize+=att.file.size;attachmentQueue.push({name:name,file:att.file,path:att.path,attachmentType:"Attachment"})}else{keyToPathMap=undefined;totalSize=files.size;attachmentQueue.push({name:files.name,file:files,attachmentType:"Attachment"})}if(totalSize>5E5&&conflictData==undefined){var attachmentData=[];for(let f=0;f<attachmentQueue.length;f++){let att=
files[f];attachmentData.push({name:att.name,size:att.size,attachmentType:"Attachment"})}var requestData={parentId:folderID,attachments:attachmentData,isCheckRequest:true,keyToPathMap:keyToPathMap,pollingID:websocketdataservice.getPollingID()};var uploadToFolderCall=this.uploadToFolder;var idToIndexMap=undefined;var restartCallback=function(request){var conflictData={overwriteIDs:request.overwriteIDs,skipIDs:request.skipIDs,renameIDs:request.renameIDs,conflicts:[]};files=dropSkippedItems(files,request.skipIDs,
idToIndexMap);uploadToFolderCall(files,folderID,conflictData)};dataservice.execute("drive.upload",{data:JSON.stringify(requestData),timeout:6E4*5,handleSuccess:function(response){if(response!=undefined&&response.conflicts!=undefined&&response.conflicts.length>0){idToIndexMap=response.idToIndexMap;dataservice.updateProgressState(undefined);resolveService.openDialog($rootScope.getMsg("drive.gui.upload.conflicts"),undefined,requestData,response,undefined,restartCallback,progressService)}else uploadStep(attachmentQueue,
keyToPathMap,0,0,totalSize,folderID,conflictData)}});return}uploadStep(attachmentQueue,keyToPathMap,0,0,totalSize,folderID,conflictData)};var dropSkippedItems=function(attachments,skipIDs,idToIndexMap){if(skipIDs==undefined||skipIDs.lengh==0)return attachments;var skipIndex=new Set;for(let i=0;i<skipIDs.length;i++){var index=idToIndexMap[skipIDs[i]];if(index!=undefined)skipIndex.add(index)}if(skipIndex.size==0)return attachments;var attachmentsFiltered=[];for(let i=0;i<attachments.length;i++){if(skipIndex.has(i))continue;
attachmentsFiltered.push(attachments[i])}return attachmentsFiltered};var uploadStep=function(attachmentQueue,keyToPathMap,index,sumSize,totalSize,folderID,conflictData){if(index>=attachmentQueue.length){dataservice.updateProgressState(undefined);return}var progressValue=undefined;var message=undefined;var canceled=false;var cancelFunction=undefined;if(attachmentQueue.length==1)message=$rootScope.getMsg("drive.gui.upload.progress.single");else{progressValue=100*sumSize/totalSize;message=$rootScope.getMsg("drive.gui.upload.progress.multi",
index+1,attachmentQueue.length);cancelFunction=function(){canceled=true;progress.cancelFunction=undefined}}var progress={progress:progressValue,mainMessage:message,subMessage:attachmentQueue[index].path,cancelFunction:cancelFunction};dataservice.updateProgressState(progress);var current=attachmentQueue[index];var attachments=[current];var requestData={parentId:folderID,keyToPathMap:keyToPathMap,pollingID:websocketdataservice.getPollingID()};if(conflictData!=undefined&&(conflictData.overwriteIDs.length>
0||conflictData.skipIDs.length>0||conflictData.renameIDs.length>0)){requestData.overwriteIDs=conflictData.overwriteIDs;requestData.skipIDs=conflictData.skipIDs;requestData.renameIDs=conflictData.renameIDs}var jsonData=JSON.stringify(requestData);dataservice.execute("drive.upload",{data:jsonData,attachments:attachments,handleSuccess:function(response){if(canceled){dataservice.updateProgressState(undefined);return}if(response!=undefined&&response.conflicts!=undefined&&response.conflicts.length>0){if(conflictData==
undefined)conflictData={conflicts:[],files:[],overwriteIDs:[],skipIDs:[],renameIDs:[],idToIndexMap:{}};conflictData.idToIndexMap[response.conflicts[0].existing.id]=conflictData.conflicts.length;conflictData.conflicts=conflictData.conflicts.concat(response.conflicts);conflictData.files.push(current)}if(attachmentQueue.length==index+1&&conflictData!=undefined&&conflictData.conflicts.length>0){var successCallback=function(request){conflictData.overwriteIDs=request.overwriteIDs;conflictData.skipIDs=request.skipIDs;
conflictData.renameIDs=request.renameIDs;conflictData.conflicts=[];conflictData.files=dropSkippedItems(conflictData.files,request.skipIDs,conflictData.idToIndexMap);totalSize=0;for(var i=0;i<conflictData.conflicts.length;i++)totalSize+=conflictData.conflicts[i].size;uploadStep(conflictData.files,keyToPathMap,0,0,totalSize,folderID,conflictData)};dataservice.updateProgressState(undefined);resolveService.openDialog($rootScope.getMsg("drive.gui.upload.conflicts"),undefined,requestData,conflictData,undefined,
successCallback,progressService)}else{sumSize+=current.file.size;uploadStep(attachmentQueue,keyToPathMap,index+1,sumSize,totalSize,folderID,conflictData)}},afterError:function(){dataservice.updateProgressState(undefined)}});progress.cancelFunction=function(){canceled=true;progress.cancelFunction=undefined;dataservice.updateProgressState(progress)};dataservice.updateProgressState(progress)};this.uploadToCurrentFolder=function(files){var wrapped=[];for(var i=0;i<files.length;i++){var file=files[i];
if(file.path)wrapped.push(file);else wrapped.push({file:file,path:file.name})}this.uploadToFolder(wrapped,driveModel.selectedFolderID)};this.sendSearchTerm=function(searchTerm){websocketdataservice.sendEvent("drive.search",{id:searchTerm,windowSize:driveModel.windowSize,sortBy:driveModel.listsorting.sortBy,ascending:driveModel.listsorting.ascending})};var checkCapabilities=function(entry){if(!entry.capabilities)entry.capabilities={canReadContent:true,canModifyContent:entry.writable,canCopy:true,canMove:entry.writable,
canRename:entry.writable,canShare:true,canDelete:entry.writable&&driveModel.viewCapabilities.canDeleteChildren,canAddChildren:entry.writable,canListChildren:true,canDeleteChildren:entry.writable}};websocketdataservice.onEvent("drive.connect",function(connectData){driveModel.connected=true;driveModel.treeModCounter++;driveModel.fields=connectData.fields;driveModel.listlayout=connectData.listlayout;driveModel.searchresultlayout=connectData.searchresultlayout;driveModel.listsorting=connectData.listsorting;
driveModel.viewSettings=connectData.viewSettings;driveModel.mountsActive=connectData.mountsActive;driveModel.contextMenuExtensions=connectData.extensions;for(var i=0;i<driveModel.contextMenuExtensions.length;i++)driveModel.actionIndexToKey.set(i,driveModel.contextMenuExtensions[i].actionKey);if(!driveModel.mountsActive)locationservice.unregisterLocationAction("mounts")});var deleteNode=function(idToDelete){let rootId="Drive";if(driveModel.treeData)rootId=driveModel.treeData[0].id;var deleted=deleteNodeInternal(rootId,
driveModel.treeData,idToDelete,true);if(deleted)driveModel.treeModCounter+=1};var deleteNodeInternal=function(parentID,children,idToDelete,doNotify){if(children==undefined)return undefined;for(var i=0;i<children.length;i++){var child=children[i];if(child.id==idToDelete){if(idToDelete!=driveModel.selectedFolderID){if(deleteNodeInternal(child.id,child.children,driveModel.selectedFolderID,false))if(doNotify){errorservice.shownotificationcontent($rootScope.getMsg("drive.gui.warning.folderremoved"),errorservice.type.WARNING);
if(driveModel.treeData)$this.goToFolder(parentID)}else driveModel.selectedFolderID=parentID}else if(doNotify){errorservice.shownotificationcontent($rootScope.getMsg("drive.gui.warning.folderremoved"),errorservice.type.WARNING);if(driveModel.treeData)$this.goToFolder(parentID)}else driveModel.selectedFolderID=parentID;driveModel.deselectAllChildren(child);children.splice(i,1);if(children.length==0&&parentID!=driveModel.selectedFolderID)driveModel.deselectIDs.push(parentID);return true}var found=deleteNodeInternal(child.id,
child.children,idToDelete,doNotify);if(found)return true}return false};websocketdataservice.onEvent("drive.redirect",function(redirectData){if(redirectData.message)errorservice.shownotificationcontent(redirectData.message,errorservice.type.WARNING);$this.goToFolder(redirectData.redirectTo)});websocketdataservice.onEvent("drive.reload",function(reloadData){if(reloadData.message){let callback=function(){location.reload()};dialogservice.showMessageBox(undefined,$rootScope.getMsg("drive.gui.warning.reload"),
reloadData.message,dialogservice.WARNING_MESSAGE,dialogservice.OK_OPTION,callback,$rootScope.$new(true))}else location.reload()});websocketdataservice.onEvent("drive.tree.deleted",function(deleteData){var id=deleteData.deleted;deleteNode(id)});websocketdataservice.onEvent("drive.tree.created",function(createData){driveModel.addNode(createData.created,createData.parent,createData.insertAfter)});websocketdataservice.onEvent("drive.tree.modify",function(modifiedData){driveModel.modifiedNode(modifiedData.entry,
modifiedData.parentID,modifiedData.insertAfter)});websocketdataservice.onEvent("drive.list.updateentry",function(updateData){if(updateData.parentID!=driveModel.selectedFolderID)return;var id=updateData.deleted;driveModel.deleteListEntry(id);if(updateData.append){checkCapabilities(updateData.append);for(var i=0;i<driveModel.entries.length;i++){var entry=driveModel.entries[i];if(entry.id==updateData.append.id){driveModel.entries.splice(i,1);if(i<=updateData.insertPosition)updateData.insertPosition--;
break}}if(updateData.append.id!=id){driveModel.selectedIDs.delete(id);if(driveModel.details.id==id)driveModel.details.id=driveModel.selectedFolderID}}else{driveModel.selectedIDs.delete(id);if(driveModel.details.id==id)driveModel.details.id=driveModel.selectedFolderID}if(updateData.append!=undefined){updateData.append.key=updateData.append.id+(new Date).getTime();driveModel.entries.splice(updateData.insertPosition,0,updateData.append);actionservice.setActionsToEntry(updateData.append);if(updateData.append.id==
driveModel.details.id){driveModel.details.id=undefined;$this.loadEntriesDetails(id);actionservice.updateMultiSelectActions()}}if(id==driveModel.selectedFolderID)driveModel.setIdInvalid()});websocketdataservice.onEvent("drive.tree",function(treeData){if(!driveModel.selectedFolderID)driveModel.selectedFolderID="Drive";if(treeData.rootId==undefined){driveModel.treeData=treeData.tree;if(driveModel.treeData&&driveModel.selectedFolderID&&driveModel.selectedFolderID!="Drive")websocketdataservice.sendEvent("drive.selectEntry",
driveModel.selectedFolderID)}else{var targetNode=driveModel.findNode(treeData.rootId);if(targetNode!=undefined){if(targetNode.children.length!=1||targetNode.children[0].id!="LOADING_ID")driveModel.deselectAllChildren(targetNode);targetNode.children=treeData.tree}}driveModel.treeModCounter+=1;if(driveModel.selectedFolderID!=undefined)if(driveModel.findNode(driveModel.selectedFolderID)!=undefined){var folder=driveModel.findNode(driveModel.selectedFolderID,driveModel.path);if(folder)driveModel.selectedFolderName=
folder.name}});websocketdataservice.onEvent("drive.folderContents",function(data){if(!driveModel.searchResult&&driveModel.selectedFolderID!=data.parentID)return;if(driveModel.searchResult&&(!$rootScope.search.term||$rootScope.search.term.trim()!=data.parentID))return;if(driveModel.selectedFolderID!=data.actualParentID&&!data.errorMessage&&!driveModel.searchResult){$this.goToFolder(data.actualParentID,data.parentID);return}driveModel.password.required=data.passwordRequired;if(driveModel.password.required){driveModel.password.message=
data.errorMessage;driveModel.password.refID=data.parentID}else{driveModel.password.message=undefined;driveModel.password.refID=undefined}driveModel.loading=false;if(data.actualParentID&&!driveModel.searchResult){driveModel.selectedFolderID=data.actualParentID;driveModel.loadedID=data.actualParentID}else driveModel.loadedID=data.parentID;driveModel.totalEntries=data.total;driveModel.totalIsTruncated=data.totalTruncated;driveModel.hasMore=data.hasMore;driveModel.viewCapabilities=data.capabilities;driveModel.canLink=
data.canLink;driveModel.canReload=data.canReload;driveModel.multiSelectExtensions=data.activeExtensions;actionservice.updateMultiSelectActions();let timestamp=(new Date).getTime();for(var i=0;i<data.entries.length;i++){var entry=data.entries[i];checkCapabilities(entry);actionservice.setActionsToEntry(entry);entry.key=entry.id+timestamp}driveModel.folderError=data.errorMessage;if(data.replace)driveModel.entries=data.entries;else driveModel.entries=driveModel.entries.concat(data.entries);if(driveModel.selectedFolderID!=
undefined){driveModel.path=[];var folder=driveModel.findNode(driveModel.selectedFolderID,driveModel.path);if(folder)driveModel.selectedFolderName=folder.name;else driveModel.selectedFolderName=""}if(driveModel.preselectID!=undefined){if(!driveModel.searchResult){driveModel.selectedIDs.clear();driveModel.selectedIDs.add(driveModel.preselectID);$this.loadEntriesDetails(driveModel.preselectID)}driveModel.preselectID=undefined}});websocketdataservice.onEvent("drive.sendentrydetails",function(data){if((driveModel.selectedIDs.size!=
1||!driveModel.selectedIDs.has(data.id))&&data.id!=driveModel.selectedFolderID)return;driveModel.details.extensions=data.extensions;driveModel.details.data=data.data;driveModel.details.entry=data.entry;driveModel.details.lastmodified=data.lastmodified;driveModel.selectedEntry=data.entry});websocketdataservice.onEvent("drive.sendeselectiondetails",function(data){driveModel.details.extensions=data.extensions;driveModel.details.data=data.data;driveModel.details.lastmodified=data.lastmodified});websocketdataservice.onEvent("drive.error",
function(error){errorservice.showerrorcontent(error.content,"#driveerrors")});this.counterSuffix=function(){if(driveModel.selectedIDs.size==driveModel.entries.size&&!driveModel.hasMore)return"all";if(driveModel.selectedIDs.size>1)return"selected";return"item"};this.createFolder=function(){if(!driveModel.viewCapabilities.canAddChildren)return;var newScope=$rootScope.$new(true);newScope.value="";var callback=function(answer){if(answer==DIALOGSERVICE.OK)dataservice.execute("drive.createfolder",{data:JSON.stringify({parentId:driveModel.selectedFolderID,
name:newScope.value}),handleSuccess:function(response){if(response==undefined)newScope.$destroy();else{newScope.errormsg=response.content;dialogservice.showInputBox(undefined,$rootScope.getMsg("drive.gui.newFolder.title"),$rootScope.getMsg("drive.gui.newFolder.message"),DIALOGSERVICE.QUESTION_MESSAGE,DIALOGSERVICE.OK_CANCEL_OPTION,callback,newScope,undefined,true)}}})};dialogservice.showInputBox(undefined,$rootScope.getMsg("drive.gui.newFolder.title"),$rootScope.getMsg("drive.gui.newFolder.message"),
DIALOGSERVICE.QUESTION_MESSAGE,DIALOGSERVICE.OK_CANCEL_OPTION,callback,newScope,undefined,true)};this.deleteSingleEntry=function(id){var newScope=$rootScope.$new(true);var idsToDelete=[id];var callback=function(answer){if(answer==DIALOGSERVICE.YES){var requestData={parentID:undefined,pollingID:websocketdataservice.getPollingID(),ids:idsToDelete};var startCallback=function(){driveModel.selectedIDs.clear()};var progressCallback=function(progress){if(progress.state=="finished")if(progress.fraction>0)errorservice.shownotificationcontent(getMsg("drive.gui.delete.success",
progress.fraction),errorservice.type.SUCCESS);else errorservice.shownotificationcontent(getMsg("drive.gui.delete.success.empty"),errorservice.type.DEFAULT);else if(progress.state=="canceled")errorservice.shownotificationcontent(getMsg("drive.gui.delete.canceled",progress.fraction),errorservice.type.DEFAULT);else if(progress.state=="error")errorservice.shownotificationcontent(getMsg("drive.gui.delete.error",progress.progressLabel),errorservice.type.WARNING)};progressService.startTask("drive.deleteentry",
requestData,undefined,startCallback,progressCallback)}newScope.$destroy()};var nodeToDelete=driveModel.findNode(id);if(nodeToDelete==undefined)for(var i=0,len=driveModel.entries.length;i<len;i++){var entry=driveModel.entries[i];if(entry.id==id){nodeToDelete=entry;break}}var name=nodeToDelete.name;dialogservice.showMessageBox(undefined,$rootScope.getMsg("drive.gui.delete.title"),$rootScope.getMsg("drive.gui.delete.message",name),DIALOGSERVICE.QUESTION_MESSAGE,DIALOGSERVICE.YES_NO_OPTION,callback,newScope,
undefined)};this.renameEntry=function(id){var newScope=$rootScope.$new(true);var nodeToRename=driveModel.findNode(id);if(nodeToRename==undefined)for(var i=0,len=driveModel.entries.length;i<len;i++){var entry=driveModel.entries[i];if(entry.id==id){nodeToRename=entry;break}}var name=nodeToRename.name;newScope.value=name;newScope.preventDialogserviceInitialFocus=true;var selectFileName=function(){if(!newScope.value||!newScope.value.length)return;var inputBox=$(".drivecontainer .dialogserviceposition.driverename input")[0];
if(inputBox==undefined)return;var dotIndex=newScope.value.lastIndexOf(".");if(dotIndex>0){var suffix=newScope.value.substring(dotIndex);if(suffix.match(/^\.\w+$/)){inputBox.setSelectionRange(0,dotIndex);return}}inputBox.select()};var callback=function(answer,value){if(answer==DIALOGSERVICE.OK)dataservice.execute("drive.renameEntry",{data:JSON.stringify({id:id,name:value}),handleSuccess:function(response){if(newScope)newScope.$destroy();if(response!=undefined){newScope=$rootScope.$new(true);newScope.errormsg=
response.content;newScope.value=value;$timeout(selectFileName);dialogservice.showInputBox(".drivecontainer",$rootScope.getMsg("drive.gui.rename.title"),$rootScope.getMsg("drive.gui.rename.message",name),DIALOGSERVICE.QUESTION_MESSAGE,DIALOGSERVICE.OK_CANCEL_OPTION,callback,newScope,"dialogserviceposition driverename",true)}}});newScope.$destroy()};$timeout(selectFileName);dialogservice.showInputBox(".drivecontainer",$rootScope.getMsg("drive.gui.rename.title"),$rootScope.getMsg("drive.gui.rename.message",
name),DIALOGSERVICE.PLAIN_MESSAGE,DIALOGSERVICE.OK_CANCEL_OPTION,callback,newScope,"dialogserviceposition driverename",true)};this.getEntryURL=function(singleID){for(var i=0,len=driveModel.entries.length;i<len;i++){var entry=driveModel.entries[i];if(entry.id==singleID)if(entry.pp)if(entry.pp=="/")singleID="/"+entry.name;else singleID=entry.pp+entry.name;else{var path="/";for(var pI=0;pI<driveModel.path.length;pI++){var part=driveModel.path[pI];if(pI==0&&part.id=="Drive")continue;if(pI==0&&singleID.startsWith("s_")){path+=
part.id+"/";continue}path+=part.name+"/"}singleID=path+entry.name;break}}var urlCoded=encodeURIComponent(singleID);urlCoded=urlCoded.replace(/%2F/g,"/");return"drive:"+urlCoded};this.getEntryName=function(singleID){for(var i=0,len=driveModel.entries.length;i<len;i++){var entry=driveModel.entries[i];if(entry.id==singleID)return entry.name}return singleID};this.copySelectedEntryURL=function(singleID){var url=$this.getEntryURL(singleID);if(navigator.clipboard){navigator.clipboard.writeText(""+url);errorservice.shownotificationcontent(getMsg("drive.gui.copyurl.success",
$this.getEntryName(singleID)),errorservice.type.SUCCESS)}else errorservice.shownotificationcontent(getMsg("drive.gui.copyurl.failed",$this.getEntryName(singleID)),errorservice.type.WARNING)};this.canDownloadSelection=function(){for(var i=0;i<driveModel.entries.length;i++){var entry=driveModel.entries[i];if(entry.type=="CONTENT"&&driveModel.selectedIDs.has(entry.id))return true}return false};this.manageMounts=function(){locationservice.addPath("mounts")};this.createLink=function(){locationservice.addPath("newlink")};
this.openFileChooser=function(event){$(".toolbarwrapper .fileinput").trigger("click")};var loadingTimeout=undefined;this.goToFolder=function(id,preselectID){if(id==undefined)if(driveModel.treeData)id=driveModel.treeData[0].id;else id="Drive";if(driveModel.loadedID==id&&driveModel.selectedFolderID==id)return;if(loadingTimeout!=undefined){$timeout.cancel(loadingTimeout);loadingTimeout=undefined}loadingTimeout=$timeout(function(){loadingTimeout=undefined;if(driveModel.loadedID==driveModel.selectedFolderID)return;
driveModel.entries=[];driveModel.hasMore=false;driveModel.loading=true},250);if($rootScope.search.term)driveModel.recentTerm=$rootScope.search.term;$rootScope.search.term=undefined;driveModel.preselectID=preselectID;locationservice.removePath("search");if(id=="Drive")if(locationservice.hasCommand("entry"))locationservice.removePath("entry");else{driveModel.clearFolderCache("Drive");$this.loadFolderContent();$this.loadEntriesDetails(driveModel.selectedFolderID)}else locationservice.addPath("entry/"+
id)}});