/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.utils;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.webgui.pluginapi.ResolveRenameHandler;
import com.inet.drive.webgui.server.events.ConflictEvent;
import com.inet.id.GUID;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a {
    @Nonnull
    public static String M(@Nullable DriveEntry driveEntry) {
        if (driveEntry == null) {
            return "";
        }
        String string = "ROOT";
        if (driveEntry.hasFeature(MetaData.class)) {
            string = driveEntry.getMetaData(MetaData.PARENT_ID);
        }
        if (string == null) {
            string = "ROOT";
        }
        return string;
    }

    @Nullable
    public static String N(@Nonnull DriveEntry driveEntry) {
        if ("Drive".equals(driveEntry.getID())) {
            return null;
        }
        if ("SharedWithMe".equals(driveEntry.getID())) {
            return "mountr_link";
        }
        Mount mount = driveEntry.getFeature(Mount.class);
        if (mount == null) {
            return "mountr_link";
        }
        while (mount.getChild() != null) {
            mount = mount.getChild();
        }
        String string = mount.getProviderKey();
        try {
            if (mount.isLinkRoot() && driveEntry.getParent() != null) {
                if ("PERSISTENCE_PROVIDER".equals(string)) {
                    return null;
                }
                return "mountf_" + string;
            }
            return "mountr_" + string;
        }
        catch (Exception exception) {
            return "mount_error";
        }
    }

    public static DriveEntry a(@Nonnull Folder folder, @Nonnull String string) {
        return folder.getChildren().stream().filter(driveEntry -> string.equals(driveEntry.getName())).findAny().orElse(null);
    }

    public static Boolean O(DriveEntry driveEntry) {
        if (driveEntry == null || !driveEntry.exists()) {
            return Boolean.FALSE;
        }
        if (!driveEntry.hasFeature(MetaData.class)) {
            return null;
        }
        GUID gUID = driveEntry.getMetaData(MetaData.CREATOR_ID);
        if (gUID == null) {
            return null;
        }
        GUID gUID2 = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID2 == null) {
            return Boolean.FALSE;
        }
        return Objects.equals(gUID, gUID2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean P(DriveEntry driveEntry) {
        try {
            while (driveEntry != null) {
                if ("Drive".equals(driveEntry.getID())) {
                    return true;
                }
                driveEntry = driveEntry.getParent();
            }
            return true;
        }
        catch (AccessDeniedException accessDeniedException) {
            return false;
        }
    }

    @Nullable
    public static String a(@Nonnull DriveEntry driveEntry, @Nonnull String string, @Nullable SupplierWithIOException<InputStream> supplierWithIOException, long l2, @Nonnull Function<String, DriveOperationConflictException.RESOLUTION> function, @Nonnull ConflictEvent conflictEvent) throws DriveEntry.UnmodifiableEntryException, IOException {
        Object object;
        Drive drive = com.inet.drive.webgui.server.a.du();
        if (!driveEntry.hasFeature(Folder.class)) {
            return null;
        }
        @Nullable Folder folder = driveEntry.getFeature(Folder.class);
        @Nullable DriveEntry driveEntry2 = a.a(folder, string);
        if (driveEntry2 == null) {
            object = UserAccountScope.createPrivileged();
            try {
                driveEntry2 = a.a(folder, string);
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        if (driveEntry2 != null) {
            boolean bl = drive.getPermissionChecker().hasPermission(driveEntry2.getID(), false, "EDITOR");
            boolean bl2 = drive.getPermissionChecker().hasPermission(driveEntry2.getID(), false, "VIEWER");
            DriveOperationConflictException.RESOLUTION rESOLUTION = function.apply(driveEntry2.getID());
            if (rESOLUTION == null) {
                com.inet.drive.webgui.server.model.a a2 = new com.inet.drive.webgui.server.model.a(driveEntry2, false);
                if (!bl) {
                    conflictEvent.addWriteProtectionConflict(a2, bl2);
                } else {
                    conflictEvent.addOverwriteConflict(a2, l2, new Date().getTime());
                }
                return driveEntry2.getID();
            }
            if (rESOLUTION == DriveOperationConflictException.RESOLUTION.skip) {
                return null;
            }
            if (supplierWithIOException == null) {
                return null;
            }
            if (rESOLUTION == DriveOperationConflictException.RESOLUTION.rename) {
                string = ResolveRenameHandler.getRenameName(string, driveEntry);
            } else {
                if (driveEntry2.hasFeature(Folder.class) || !driveEntry2.hasFeature(Content.class)) {
                    try {
                        driveEntry2.delete(null);
                    }
                    catch (DriveOperationConflictException driveOperationConflictException) {
                        conflictEvent.addConflicts(driveOperationConflictException);
                        return driveEntry2.getID();
                    }
                }
                UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                try (InputStream inputStream = (InputStream)supplierWithIOException.get();){
                    driveEntry2.getFeature(Content.class).setInputStream(inputStream, null);
                }
                try {
                    inputStream = UserAccountScope.createPrivileged();
                    try {
                        Mount mount = driveEntry2.getFeature(DriveEntry.MOUNT);
                        MetaData metaData = driveEntry2.getFeature(MetaData.class);
                        if (metaData != null && userAccount != null && (mount == null || mount.isLinkRoot() || "PERSISTENCE_PROVIDER".equals(mount.getProviderKey()))) {
                            metaData.setMetaData(MetaData.CREATOR_ID, userAccount.getID());
                            metaData.setMetaData(MetaData.CREATOR, userAccount.getDisplayName());
                            metaData.setMetaData(MetaData.CREATE, new Date().getTime());
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    DrivePlugin.LOGGER.debug("For " + driveEntry2.getExtensionName() + " is an overwrite the meta data not allowed.", (Object)throwable);
                }
                return null;
            }
            try (InputStream inputStream = (InputStream)supplierWithIOException.get();){
                DataEntry dataEntry = new DataEntry(string, inputStream);
                folder.createChild(dataEntry);
            }
        }
        if (supplierWithIOException != null) {
            object = (InputStream)supplierWithIOException.get();
            try {
                DataEntry dataEntry = new DataEntry(string, (InputStream)object);
                folder.createChild(dataEntry);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        return null;
    }
}

