/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.details;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.permission.PermissionChecker;
import com.inet.drive.server.search.c;
import com.inet.drive.webgui.pluginapi.ContextMenuExtension;
import com.inet.drive.webgui.server.details.DetailsPanelExtension;
import com.inet.drive.webgui.server.details.a;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ContentExtension
implements DetailsPanelExtension {
    private static final Set<MetaKey<?>> iT = new HashSet<MetaKey>(Arrays.asList(MetaData.CREATE, MetaData.CREATOR, MetaData.CREATOR_ID, MetaData.FILETYPE, MetaData.ID, MetaData.MODIFIED, MetaData.MODIFIEDBY, MetaData.NAME, MetaData.PARENT_ID, MetaData.PATH, MetaData.SIZE, MetaData.AUTHOR, MetaData.PRODUCER));

    @Nonnull
    public String getExtensionName() {
        return "detailspanel.content";
    }

    @Override
    public String getDisplayName() {
        return DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.content.displayname", new Object[0]);
    }

    @Override
    public String getDescription() {
        return DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.content.description", new Object[0]);
    }

    @Override
    public URL getTemplateURL() {
        return this.getClass().getResource("/com/inet/drive/webgui/client/details/contentextension.html");
    }

    @Override
    public boolean appliesTo(@Nonnull DriveEntry entry) {
        DriveIDUtils.getSourceID(entry);
        try {
            if (entry.hasFeature(DriveEntry.CONTENT)) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            if (entry.hasFeature(DriveEntry.META_DATA)) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (entry.hasFeature(DriveEntry.FOLDER)) {
            return true;
        }
        return false;
    }

    public List<ContentListEntry> a(@Nonnull DriveEntry driveEntry, @Nonnull List<String> list, @Nonnull DetailsPanelExtension.a a2) {
        Object object;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ArrayList<ContentListEntry> arrayList = new ArrayList<ContentListEntry>();
        try {
            object = driveEntry.getMetaData(MetaData.TITLE);
            if (object != null) {
                arrayList.add(new ContentListEntry(MetaData.TITLE, (String)object));
            }
        }
        catch (RuntimeException runtimeException) {
            linkedHashSet.add(runtimeException.getMessage());
        }
        try {
            object = driveEntry.getName();
            if (object != null && !((String)object).isBlank()) {
                arrayList.add(new ContentListEntry((String)object, !driveEntry.hasFeature(Folder.class)));
            } else if ("Drive".equals(driveEntry.getID())) {
                arrayList.add(new ContentListEntry(MetaData.NAME, DrivePlugin.MSG_CLIENT.getMsg("drive.gui.root", new Object[0])));
            } else {
                arrayList.add(new ContentListEntry(MetaData.NAME, DrivePlugin.MSG_SERVER.getMsg("drive.entry.noname", new Object[0])));
            }
        }
        catch (RuntimeException runtimeException) {
            linkedHashSet.add(runtimeException.getMessage());
            arrayList.add(new ContentListEntry(MetaData.NAME, DrivePlugin.MSG_SERVER.getMsg("drive.entry.noname", new Object[0])));
        }
        try {
            String string;
            object = driveEntry.getMetaData(MetaData.AUTHOR);
            if (object != null && !((String)object).isBlank()) {
                arrayList.add(new ContentListEntry(MetaData.AUTHOR, (String)object));
            }
            if ((string = driveEntry.getMetaData(MetaData.PRODUCER)) != null && !string.isBlank()) {
                arrayList.add(new ContentListEntry(MetaData.PRODUCER, string));
            }
        }
        catch (RuntimeException runtimeException) {
            linkedHashSet.add(runtimeException.getMessage());
        }
        if (a2 == DetailsPanelExtension.a.jc && (object = driveEntry.getParent()) != null) {
            if ("Drive".equals(object.getID())) {
                arrayList.add(new ContentListEntry(MetaData.PARENT_ID, DrivePlugin.MSG_CLIENT.getMsg("drive.gui.root", new Object[0]), object.getID()));
            } else {
                arrayList.add(new ContentListEntry(MetaData.PARENT_ID, object.getName(), object.getID()));
            }
        }
        this.a(driveEntry, linkedHashSet, arrayList);
        try {
            arrayList.add(new ContentListEntry(MetaData.PATH, driveEntry.getPath()));
        }
        catch (Exception exception) {
            linkedHashSet.add(exception.getMessage());
        }
        try {
            if (driveEntry.hasFeature(DriveEntry.CONTENT) && (object = driveEntry.getFeature(DriveEntry.CONTENT)) != null) {
                arrayList.add(new ContentListEntry(MetaData.SIZE, a.a(object.getSize())));
            }
        }
        catch (Exception exception) {
            linkedHashSet.add(exception.getMessage());
        }
        this.c(driveEntry, linkedHashSet, arrayList);
        this.b(driveEntry, linkedHashSet, arrayList);
        if (arrayList.size() == 0 || arrayList.size() == 1 && ((ContentListEntry)arrayList.get((int)0)).key == MetaData.ID.getKey()) {
            return null;
        }
        if (!linkedHashSet.isEmpty()) {
            list.addAll(linkedHashSet);
        }
        return arrayList;
    }

    private void a(DriveEntry driveEntry, Set<String> set, List<ContentListEntry> list) {
        try {
            String string = DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.content.type.file", new Object[0]);
            if (driveEntry.executeFeature(Mount.class, mount -> mount.isLinkRoot(), false)) {
                string = DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.content.type.mount", new Object[0]);
            } else if (driveEntry.hasFeature(DriveEntry.FOLDER)) {
                string = DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.content.type.folder", new Object[0]);
            } else if (driveEntry.hasFeature(DriveEntry.META_DATA)) {
                String string2;
                for (DriveFileTypeHandler object2 : DriveUtils.getDriveTypeHandler()) {
                    if (!object2.acceptFileTyp(driveEntry, DriveFileTypeHandler.FEATURE.filetype) || (string = object2.getFileTypeName(driveEntry)) == null) continue;
                    list.add(new ContentListEntry(MetaData.FILETYPE, string));
                    return;
                }
                String string22 = driveEntry.getMetaData(MetaData.FILETYPE);
                string = string22 != null && !string22.toString().isBlank() ? (DrivePlugin.MSG_SERVER.hasMsg(string2 = "drive.entry.filetype." + string22.toString(), ClientLocale.getThreadLocale()) ? DrivePlugin.MSG_SERVER.getMsg(string2, new Object[0]) : DrivePlugin.MSG_SERVER.getMsg("drive.entry.filetype", new Object[]{string22.toString()})) : DrivePlugin.MSG_CLIENT.getMsg("drive.gui.details.content.type.file", new Object[0]);
            }
            list.add(new ContentListEntry(MetaData.FILETYPE, string));
        }
        catch (Exception exception) {
            set.add(exception.getMessage());
        }
    }

    private void b(DriveEntry driveEntry, Set<String> set, List<ContentListEntry> list) {
        try {
            driveEntry.runFeature(DriveEntry.META_DATA, metaData -> {
                GUID gUID;
                Object object;
                GUID gUID2 = metaData.getMetaData(MetaData.CREATOR_ID);
                if (!UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)gUID2)) {
                    object = metaData.getMetaData(MetaData.CREATOR);
                    if (gUID2 != null) {
                        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID2);
                        if (userAccount != null) {
                            list.add(new ContentListEntry(MetaData.CREATOR_ID, MetaData.CREATOR_ID.formatValue(gUID2)));
                        } else {
                            gUID2 = null;
                        }
                    }
                    if (object != null && gUID2 == null) {
                        list.add(new ContentListEntry(MetaData.CREATOR, (String)object));
                    }
                }
                object = null;
                try {
                    object = driveEntry.getMetaData(MetaData.CREATE);
                    if (object != null && (Long)object > 0L) {
                        list.add(new ContentListEntry(MetaData.CREATE, MetaData.MODIFIED.formatValue((Long)object)));
                    }
                }
                catch (Exception exception) {
                    set.add(exception.getMessage());
                }
                try {
                    long l2 = driveEntry.getLastModified();
                    if (l2 > 0L && (object == null || (Long)object != l2)) {
                        list.add(new ContentListEntry(MetaData.MODIFIED, MetaData.MODIFIED.formatValue(l2)));
                    }
                }
                catch (Exception exception) {
                    set.add(exception.getMessage());
                }
                GUID gUID3 = metaData.getMetaData(MetaData.MODIFIEDBY);
                GUID gUID4 = gUID = gUID3 != null ? GUID.valueOf((String)gUID3.toString()) : null;
                if (gUID != null && !UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)gUID) && !gUID.equals((Object)gUID2)) {
                    list.add(new ContentListEntry(MetaData.MODIFIEDBY, MetaData.MODIFIEDBY.formatValue(gUID)));
                }
                boolean bl = this.dH();
                Set set2 = list.stream().map(contentListEntry -> c.G(contentListEntry.key)).filter(metaKey -> metaKey != null).collect(Collectors.toSet());
                for (MetaKey<?> metaKey2 : c.bR()) {
                    if (set2.contains(metaKey2) || !bl && (iT.contains(metaKey2) || !metaKey2.isDisplayInDetails())) continue;
                    try {
                        Object obj = metaData.getMetaData(metaKey2);
                        if (obj == null) continue;
                        list.add(new ContentListEntry(metaKey2, metaKey2.formatValue(obj)));
                    }
                    catch (AccessDeniedException accessDeniedException) {
                    }
                    catch (Exception exception) {
                        set.add(exception.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            set.add(exception.getMessage());
        }
    }

    protected boolean dH() {
        boolean bl = false;
        try {
            assert (false);
        }
        catch (AssertionError assertionError) {
            bl = true;
        }
        return bl;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void c(@Nonnull DriveEntry driveEntry, Set<String> set, List<ContentListEntry> list) {
        try {
            List<String> list2;
            Object object;
            Object object2;
            PermissionChecker permissionChecker = Drive.getInstance().getPermissionChecker();
            @Nonnull @Nonnull List list3 = ServerPluginManager.getInstance().get(DrivePermissionType.class);
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Object object3 : list3) {
                object2 = ((DrivePermissionType)object3).getPermissionTypeName();
                if (!permissionChecker.hasPermission(driveEntry.getID(), false, new String[]{object2})) continue;
                hashSet.add(object2);
            }
            if (hashSet.size() < list3.size()) {
                Object object3;
                object = ServerPluginManager.getInstance().get(ContextMenuExtension.class);
                object3 = object.iterator();
                while (object3.hasNext()) {
                    object2 = (ContextMenuExtension)object3.next();
                    list2 = object2.getImplicitPermissions(driveEntry);
                    if (list2 == null) continue;
                    hashSet.addAll(list2);
                }
            }
            object = new StringBuilder();
            int n2 = 0;
            int n3 = 0;
            for (DrivePermissionType drivePermissionType : list3) {
                if (!hashSet.contains(drivePermissionType.getPermissionTypeName())) continue;
                if (n2 < 3) {
                    if (!object.isEmpty()) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(drivePermissionType.getDisplayName());
                    ++n2;
                    continue;
                }
                ++n3;
            }
            if (n3 > 0) {
                ((StringBuilder)object).append(DrivePlugin.MSG_CLIENT.getMsg("drive.gui.permissions.more", new Object[]{n3}));
            }
            list2 = new ContentListEntry("permissions", DrivePlugin.MSG_SERVER.getMsg("permissions.label", new Object[0]), ((StringBuilder)object).toString());
            list.add((ContentListEntry)((Object)list2));
            boolean bl = driveEntry.executeFeature(Mount.class, mount -> mount.getProviderKey().equals("PERSISTENCE_PROVIDER"), false);
            if (bl && hashSet.contains("EDITOR") && com.inet.drive.webgui.server.utils.a.O(driveEntry) != Boolean.TRUE) {
                list.add(new ContentListEntry("permissions.hint", null, DrivePlugin.MSG_SERVER.getMsg("permissions.info.mountpoint", new Object[0])));
            }
        }
        catch (Exception exception) {
            set.add(exception.getMessage());
        }
    }

    public /* synthetic */ Object getEntryData(@Nonnull DriveEntry driveEntry, @Nonnull List list, @Nonnull DetailsPanelExtension.a a2) {
        return this.a(driveEntry, list, a2);
    }

    @JsonData
    static class ContentListEntry {
        private String key;
        private String label;
        private List<String> values = new ArrayList<String>();
        private a type = a.iV;

        public ContentListEntry(MetaKey<?> key, String value, String idTarget) {
            this.key = key.getKey();
            this.label = key.getLabel();
            this.values.add(value);
            this.values.add(idTarget);
            this.type = a.iW;
        }

        public ContentListEntry(MetaKey<?> key, String value) {
            this.key = key.getKey();
            this.label = key.getLabel();
            this.values.add(value);
            if (key == MetaData.PATH) {
                this.type = a.iY;
            }
        }

        public ContentListEntry(String value, boolean isFile) {
            this.key = MetaData.NAME.getKey();
            this.label = DrivePlugin.MSG_SERVER.getMsg("meta.key.NAME." + (isFile ? "FILE" : "FOLDER"), new Object[0]);
            this.values.add(value);
        }

        public ContentListEntry(String key, String label, String value) {
            this.key = key;
            this.label = label;
            this.values.add(value);
        }

        public ContentListEntry(String id) {
            this.type = a.iX;
            this.key = id;
            this.label = null;
            this.values.add(id);
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public a getType() {
            return this.type;
        }

        String getValue() {
            return this.values != null ? this.values.stream().collect(Collectors.joining(", ")) : "";
        }

        public static final class a
        extends Enum<a> {
            public static final /* enum */ a iV = new a();
            public static final /* enum */ a iW = new a();
            public static final /* enum */ a iX = new a();
            public static final /* enum */ a iY = new a();
            private static final /* synthetic */ a[] iZ;

            public static a[] values() {
                return (a[])iZ.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private static /* synthetic */ a[] dI() {
                return new a[]{iV, iW, iX, iY};
            }

            static {
                iZ = a.dI();
            }
        }
    }
}

