/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.data;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.webgui.server.data.DriveGuiEntry;
import com.inet.drive.webgui.server.model.fields.c;
import com.inet.drive.webgui.server.utils.a;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class DriveTree {
    public static final String LOADING_ID = "LOADING_ID";
    private List<DriveTreeNode> tree;
    private String rootId;
    private String idToExpand;

    public DriveTree(List<DriveTreeNode> tree) {
        this.tree = tree;
    }

    public DriveTree(String rootId, String idToExpand, List<DriveTreeNode> children) {
        this.rootId = rootId;
        this.idToExpand = idToExpand;
        this.tree = children;
    }

    public List<DriveTreeNode> getTree() {
        return this.tree;
    }

    public String getRootId() {
        return this.rootId;
    }

    public String getIdToExpand() {
        return this.idToExpand;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public static List<DriveTreeNode> getChildren(DriveEntry entry, boolean checkForChildren) {
        Object exception;
        Object runtimeException;
        Object c3;
        ArrayList<DriveTreeNode> arrayList;
        List<Object> list;
        if (entry == null) {
            void driveEntry;
            list = new ArrayList();
            arrayList = Drive.getInstance().getRoots();
            c3 = Drive.ROOT_TYPES.values();
            int n2 = ((Drive.ROOT_TYPES[])c3).length;
            boolean bl = false;
            while (driveEntry < n2) {
                runtimeException = c3[driveEntry];
                exception = (List)arrayList.get(runtimeException);
                if (exception != null && !exception.isEmpty()) {
                    list.addAll((Collection<Object>)exception);
                }
                ++driveEntry;
            }
        } else {
            try {
                arrayList = entry.getFeature(Folder.class);
                if (arrayList == null) {
                    return new ArrayList<DriveTreeNode>();
                }
                list = arrayList.getChildren();
            }
            catch (DriveIOException | ClientMessageException | IllegalStateException throwable) {
                if (DrivePlugin.LOGGER.isDebug()) {
                    DrivePlugin.LOGGER.debug((Object)throwable);
                }
                return new ArrayList<DriveTreeNode>();
            }
        }
        arrayList = new ArrayList<DriveTreeNode>();
        c3 = new c();
        for (DriveEntry driveEntry : list) {
            Object object;
            Object object22;
            block26: {
                try {
                    if (driveEntry == null) continue;
                    if (!driveEntry.hasFeature(Folder.class) && !driveEntry.executeFeature(Mount.class, m2 -> m2.isLinkRoot() && !"sharing".equals(m2.getProviderKey()), false)) {
                    }
                }
                catch (RuntimeException driveIOException) {}
                continue;
                try {
                    if (driveEntry.hasFeature(com.inet.drive.api.feature.a.class) && entry != null && ((String)(runtimeException = entry.getID())).contains((CharSequence)(object22 = (object = DriveIDUtils.splittID((String)(exception = driveEntry.getID())))[((String[])object).length - 1]))) {
                        exception = ((String)runtimeException).substring(0, ((String)runtimeException).indexOf((String)object22)) + (String)object22;
                        DriveGuiEntry.a a2 = DriveGuiEntry.a.w(driveEntry);
                        String string = a2.name().toLowerCase();
                        @Nonnull String string2 = ((c)c3).D(driveEntry);
                        DriveTreeRedirectNode driveTreeRedirectNode = new DriveTreeRedirectNode(string2, (String)exception, DriveIDUtils.getSourceID(driveEntry), a2, string);
                        arrayList.add(driveTreeRedirectNode);
                        continue;
                    }
                }
                catch (DriveIOException runtimeException2) {
                }
                catch (RuntimeException runtimeException3) {
                    if (!DrivePlugin.LOGGER.isDebug()) continue;
                    DrivePlugin.LOGGER.debug((Object)runtimeException3);
                    continue;
                }
                runtimeException = new ArrayList();
                try {
                    if (entry == null) {
                        if (driveEntry.getID().equals("Drive")) {
                            runtimeException.addAll(DriveTree.getChildren(driveEntry, true));
                        } else {
                            runtimeException.add(new DriveTreeNode(DrivePlugin.MSG_SERVER.getMsg("drive.tree.loading", new Object[0]), LOADING_ID, LOADING_ID, DriveGuiEntry.a.iL, null));
                        }
                        break block26;
                    }
                    if (!checkForChildren) break block26;
                    if (driveEntry.executeFeature(Mount.class, m2 -> {
                        if (!m2.isLinkRoot()) {
                            return false;
                        }
                        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                            String string = m2.getDescription().getProvider();
                            if ("PERSISTENCE_PROVIDER".equals(string) || "file".equals(string)) {
                                @Nonnull @Nonnull boolean bl = false;
                                return bl;
                            }
                        }
                        return true;
                    }, false)) {
                        runtimeException.add(new DriveTreeNode(DrivePlugin.MSG_SERVER.getMsg("drive.tree.loading", new Object[0]), LOADING_ID, LOADING_ID, DriveGuiEntry.a.iL, null));
                        break block26;
                    }
                    if (!driveEntry.hasFeature(Folder.class) || (exception = driveEntry.getFeature(Folder.class)) == null || !exception.hasChildren()) break block26;
                    for (Object object22 : driveEntry.executeFeatureNN(Folder.class, f2 -> f2.getChildren(), () -> new ArrayList())) {
                        try {
                            if (object22 == null || !object22.hasFeature(Folder.class)) continue;
                            runtimeException.add(new DriveTreeNode(DrivePlugin.MSG_SERVER.getMsg("drive.tree.loading", new Object[0]), LOADING_ID, LOADING_ID, DriveGuiEntry.a.iL, null));
                            break;
                        }
                        catch (Exception exception2) {
                        }
                    }
                }
                catch (Exception exception3) {
                    if (!DrivePlugin.LOGGER.isDebug()) break block26;
                    DrivePlugin.LOGGER.debug((Object)exception3);
                }
            }
            exception = DriveGuiEntry.a.w(driveEntry);
            object = ((Enum)exception).name().toLowerCase();
            if (exception == DriveGuiEntry.a.iN && (object22 = a.N(driveEntry)) != null) {
                object = object22;
            }
            object22 = ((c)c3).D(driveEntry);
            exception = new DriveTreeNode((String)object22, driveEntry.getID(), DriveIDUtils.getSourceID(driveEntry), (DriveGuiEntry.a)((Object)exception), (String)object, (List<DriveTreeNode>)runtimeException);
            arrayList.add((DriveTreeNode)exception);
        }
        Collections.sort(arrayList, (c1, c2) -> {
            int n2 = Integer.compare(c1.type.dE(), c2.type.dE());
            if (n2 != 0) {
                return n2;
            }
            n2 = c1.name.toLowerCase().compareTo(c2.name.toLowerCase());
            if (n2 != 0) {
                return n2;
            }
            n2 = c1.name.compareTo(c2.name);
            if (n2 != 0) {
                return n2;
            }
            return c1.id.compareTo(c2.id);
        });
        return arrayList;
    }

    @Nonnull
    public String toString() {
        return "Root: " + this.rootId + ", expand: " + this.idToExpand + ", children: " + this.tree.size();
    }

    @JsonData
    public static class DriveTreeRedirectNode
    extends DriveTreeNode {
        private String redirectID;

        public DriveTreeRedirectNode(@Nonnull String name, String id, String sourceId, DriveGuiEntry.a type, String mimeKey) {
            super(name, "REDIRECT_TO_" + id, sourceId, type, mimeKey, new ArrayList<DriveTreeNode>());
            this.redirectID = id;
        }
    }

    @JsonData
    public static class DriveTreeNode {
        @Nonnull
        private String name;
        private DriveGuiEntry.a type;
        private String mimeKey;
        @Nonnull
        private String id;
        private transient String sourceId;
        private List<DriveTreeNode> children;

        public DriveTreeNode(@Nonnull String name, @Nonnull String id, String sourceId, DriveGuiEntry.a type, List<DriveTreeNode> children) {
            this.name = name;
            this.id = id;
            this.sourceId = sourceId;
            this.type = type;
            this.mimeKey = type.name().toLowerCase();
            this.children = children;
        }

        public DriveTreeNode(@Nonnull String name, @Nonnull String id, String sourceId, DriveGuiEntry.a type, String mimeKey, List<DriveTreeNode> children) {
            this.name = name;
            this.id = id;
            this.sourceId = sourceId;
            this.type = type;
            this.mimeKey = mimeKey;
            this.children = children;
        }

        public List<DriveTreeNode> getChildren() {
            return this.children;
        }

        public String getId() {
            return this.id;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public String getName() {
            return this.name;
        }

        public void setChildren(List<DriveTreeNode> children) {
            this.children = children;
        }
    }
}

